/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;

public class WriterPreferenceReadWriteLock
implements ReadWriteLock {
    protected long activeReaders_ = 0L;
    protected Thread activeWriter_ = null;
    protected long waitingReaders_ = 0L;
    protected long waitingWriters_ = 0L;
    protected final ReaderLock readerLock_ = new ReaderLock();
    protected final WriterLock writerLock_ = new WriterLock();

    public Sync writeLock() {
        return this.writerLock_;
    }

    public Sync readLock() {
        return this.readerLock_;
    }

    protected synchronized void cancelledWaitingReader() {
        --this.waitingReaders_;
    }

    protected synchronized void cancelledWaitingWriter() {
        --this.waitingWriters_;
    }

    protected boolean allowReader() {
        return this.activeWriter_ == null && this.waitingWriters_ == (long)0;
    }

    protected synchronized boolean startRead() {
        boolean allowRead = this.allowReader();
        if (allowRead) {
            ++this.activeReaders_;
        }
        return allowRead;
    }

    protected synchronized boolean startWrite() {
        boolean allowWrite;
        boolean bl = allowWrite = this.activeWriter_ == null && this.activeReaders_ == (long)0;
        if (allowWrite) {
            this.activeWriter_ = Thread.currentThread();
        }
        return allowWrite;
    }

    protected synchronized boolean startReadFromNewReader() {
        boolean pass = this.startRead();
        if (!pass) {
            ++this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromNewWriter() {
        boolean pass = this.startWrite();
        if (!pass) {
            ++this.waitingWriters_;
        }
        return pass;
    }

    protected synchronized boolean startReadFromWaitingReader() {
        boolean pass = this.startRead();
        if (pass) {
            --this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromWaitingWriter() {
        boolean pass = this.startWrite();
        if (pass) {
            --this.waitingWriters_;
        }
        return pass;
    }

    protected synchronized Signaller endRead() {
        if (--this.activeReaders_ == (long)0 && this.waitingWriters_ > (long)0) {
            return this.writerLock_;
        }
        return null;
    }

    protected synchronized Signaller endWrite() {
        this.activeWriter_ = null;
        if (this.waitingReaders_ > (long)0 && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > (long)0) {
            return this.writerLock_;
        }
        return null;
    }

    protected class WriterLock
    extends Signaller
    implements Sync {
        protected WriterLock() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                try {
                    if (!WriterPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
                        try {
                            do {
                                this.wait();
                            } while (!WriterPreferenceReadWriteLock.this.startWriteFromWaitingWriter());
                            return;
                        }
                        catch (InterruptedException ex) {
                            WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
                            this.notify();
                            ie = ex;
                        }
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
            if (ie != null) {
                WriterPreferenceReadWriteLock.this.readerLock_.signalWaiters();
                throw ie;
            }
        }

        public void release() {
            Signaller s = WriterPreferenceReadWriteLock.this.endWrite();
            if (s != null) {
                s.signalWaiters();
            }
        }

        synchronized void signalWaiters() {
            this.notify();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                block9: {
                    try {
                        if (msecs <= (long)0) {
                            return WriterPreferenceReadWriteLock.this.startWrite();
                        }
                        if (WriterPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
                            return true;
                        }
                        long waitTime = msecs;
                        long start = System.currentTimeMillis();
                        do {
                            try {
                                this.wait(waitTime);
                            }
                            catch (InterruptedException ex) {
                                WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
                                this.notify();
                                ie = ex;
                                break block9;
                            }
                            if (!WriterPreferenceReadWriteLock.this.startWriteFromWaitingWriter()) continue;
                            return true;
                        } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > (long)0);
                        WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
                        this.notify();
                    }
                    catch (Throwable throwable) {
                        Object var13_9 = null;
                        throw throwable;
                    }
                }
                Object var13_8 = null;
                {
                }
            }
            WriterPreferenceReadWriteLock.this.readerLock_.signalWaiters();
            if (ie == null) return false;
            throw ie;
        }
    }

    protected class ReaderLock
    extends Signaller
    implements Sync {
        protected ReaderLock() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                try {
                    if (!WriterPreferenceReadWriteLock.this.startReadFromNewReader()) {
                        try {
                            do {
                                this.wait();
                            } while (!WriterPreferenceReadWriteLock.this.startReadFromWaitingReader());
                            return;
                        }
                        catch (InterruptedException ex) {
                            WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
                            ie = ex;
                        }
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
            if (ie != null) {
                WriterPreferenceReadWriteLock.this.writerLock_.signalWaiters();
                throw ie;
            }
        }

        public void release() {
            Signaller s = WriterPreferenceReadWriteLock.this.endRead();
            if (s != null) {
                s.signalWaiters();
            }
        }

        synchronized void signalWaiters() {
            this.notifyAll();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                block9: {
                    try {
                        if (msecs <= (long)0) {
                            return WriterPreferenceReadWriteLock.this.startRead();
                        }
                        if (WriterPreferenceReadWriteLock.this.startReadFromNewReader()) {
                            return true;
                        }
                        long waitTime = msecs;
                        long start = System.currentTimeMillis();
                        do {
                            try {
                                this.wait(waitTime);
                            }
                            catch (InterruptedException ex) {
                                WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
                                ie = ex;
                                break block9;
                            }
                            if (!WriterPreferenceReadWriteLock.this.startReadFromWaitingReader()) continue;
                            return true;
                        } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > (long)0);
                        WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
                    }
                    catch (Throwable throwable) {
                        Object var13_9 = null;
                        throw throwable;
                    }
                }
                Object var13_8 = null;
                {
                }
            }
            WriterPreferenceReadWriteLock.this.writerLock_.signalWaiters();
            if (ie == null) return false;
            throw ie;
        }
    }

    protected abstract class Signaller {
        protected Signaller() {
        }

        abstract void signalWaiters();
    }
}

