/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.populator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class DefaultLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$populator$DefaultLdapAuthoritiesPopulator == null ? (class$org$acegisecurity$providers$ldap$populator$DefaultLdapAuthoritiesPopulator = DefaultLdapAuthoritiesPopulator.class$("org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator")) : class$org$acegisecurity$providers$ldap$populator$DefaultLdapAuthoritiesPopulator));
    private GrantedAuthority defaultRole = null;
    private InitialDirContextFactory initialDirContextFactory = null;
    private LdapTemplate ldapTemplate;
    private SearchControls searchControls = new SearchControls();
    private String groupRoleAttribute = "cn";
    private String groupSearchBase = null;
    private String groupSearchFilter = "(member={0})";
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$populator$DefaultLdapAuthoritiesPopulator;

    public DefaultLdapAuthoritiesPopulator(InitialDirContextFactory initialDirContextFactory, String groupSearchBase) {
        Assert.notNull((Object)initialDirContextFactory, (String)"InitialDirContextFactory must not be null");
        Assert.notNull((Object)groupSearchBase, (String)"The groupSearchBase (name to search under), must not be null.");
        this.initialDirContextFactory = initialDirContextFactory;
        this.groupSearchBase = groupSearchBase;
        if (groupSearchBase.length() == 0) {
            logger.info((Object)("groupSearchBase is empty. Searches will be performed from the root: " + initialDirContextFactory.getRootDn()));
        }
        this.ldapTemplate = new LdapTemplate(initialDirContextFactory);
        this.ldapTemplate.setSearchControls(this.searchControls);
    }

    protected Set getAdditionalRoles(LdapUserDetails ldapUser) {
        return null;
    }

    public final GrantedAuthority[] getGrantedAuthorities(LdapUserDetails userDetails) {
        Set extraRoles;
        String userDn = userDetails.getDn();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting authorities for user " + userDn));
        }
        Set roles = this.getGroupMembershipRoles(userDn, userDetails.getUsername());
        Set oldGroupRoles = this.getGroupMembershipRoles(userDn, userDetails.getAttributes());
        if (oldGroupRoles != null) {
            roles.addAll(oldGroupRoles);
        }
        if ((extraRoles = this.getAdditionalRoles(userDetails)) != null) {
            roles.addAll(extraRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        return roles.toArray(new GrantedAuthority[roles.size()]);
    }

    public final Set getGroupMembershipRoles(String userDn, String username) {
        HashSet<GrantedAuthorityImpl> authorities = new HashSet<GrantedAuthorityImpl>();
        if (this.groupSearchBase == null) {
            return authorities;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for roles for user '" + username + "', DN = " + "'" + userDn + "', with filter " + this.groupSearchFilter + " in search base '" + this.groupSearchBase + "'"));
        }
        Set userRoles = this.ldapTemplate.searchForSingleAttributeValues(this.groupSearchBase, this.groupSearchFilter, new String[]{userDn, username}, this.groupRoleAttribute);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Roles from search: " + userRoles));
        }
        Iterator it = userRoles.iterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            authorities.add(new GrantedAuthorityImpl(this.rolePrefix + role));
        }
        return authorities;
    }

    protected Set getGroupMembershipRoles(String userDn, Attributes userAttributes) {
        return new HashSet();
    }

    protected InitialDirContextFactory getInitialDirContextFactory() {
        return this.initialDirContextFactory;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new GrantedAuthorityImpl(defaultRole);
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        Assert.notNull((Object)groupRoleAttribute, (String)"groupRoleAttribute must not be null");
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        Assert.notNull((Object)groupSearchFilter, (String)"groupSearchFilter must not be null");
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        this.rolePrefix = rolePrefix;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

