/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CLOB;
import oracle.sql.Datum;

class ClobAccessor
extends Accessor {
    static final int max_length = 4000;

    ClobAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 112, 112, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    ClobAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 112, 112, s, false);
        this.initForDescribe(112, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    InputStream getAsciiStream(int n) throws SQLException {
        CLOB cLOB = this.getCLOB(n);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getAsciiStream();
    }

    InputStream getBinaryStream(int n) throws SQLException {
        CLOB cLOB = this.getCLOB(n);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getAsciiStream();
    }

    CLOB getCLOB(int n) throws SQLException {
        CLOB cLOB = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            cLOB = new CLOB(this.stmt.connection, byArray, this.formOfUse);
        }
        return cLOB;
    }

    Reader getCharacterStream(int n) throws SQLException {
        CLOB cLOB = this.getCLOB(n);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getCharacterStream();
    }

    Object getObject(int n) throws SQLException {
        return this.getCLOB(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getCLOB(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getCLOB(n);
    }

    String getString(int n) throws SQLException {
        CLOB cLOB = this.getCLOB(n);
        if (cLOB == null) {
            return null;
        }
        Reader reader = cLOB.getCharacterStream();
        int n2 = cLOB.getBufferSize();
        int n3 = 0;
        StringWriter stringWriter = new StringWriter(n2);
        char[] cArray = new char[n2];
        try {
            while ((n3 = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n3);
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DatabaseError.throwSqlException(151);
        }
        return stringWriter.toString();
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        this.t_max_length = 4000;
        if (n2 > 0 && n2 < this.t_max_length) {
            this.t_max_length = n2;
        }
        this.byteLength = this.t_max_length;
    }
}

