/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

public class RAW
extends Datum {
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050624";

    public RAW() {
    }

    public RAW(Object object) throws SQLException {
        this();
        if (object instanceof byte[]) {
            this.setShareBytes((byte[])object);
        } else if (object instanceof String) {
            this.setShareBytes(RAW.hexString2Bytes((String)object));
        } else {
            DatabaseError.check_error(59, object);
        }
    }

    public RAW(byte[] byArray) {
        super(byArray);
    }

    public InputStream asciiStreamValue() throws SQLException {
        int n = (int)this.getLength();
        char[] cArray = new char[n * 2];
        byte[] byArray = this.shareBytes();
        DBConversion.RAWBytesToHexChars(byArray, n, cArray);
        byte[] byArray2 = new byte[n * 2];
        DBConversion.javaCharsToAsciiBytes(cArray, n * 2, byArray2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        return byteArrayInputStream;
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    public Reader characterStreamValue() throws SQLException {
        int n = (int)this.getLength();
        char[] cArray = new char[n * 2];
        byte[] byArray = this.shareBytes();
        DBConversion.RAWBytesToHexChars(byArray, n, cArray);
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        return charArrayReader;
    }

    static int hexDigit2Nibble(char c) throws SQLException {
        int n = Character.digit(c, 16);
        if (n == -1) {
            throw new SQLException("Invalid hex digit: " + c);
        }
        return n;
    }

    public static byte[] hexString2Bytes(String string) throws SQLException {
        byte[] byArray;
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            return new byte[0];
        }
        if (n % 2 > 0) {
            byArray = new byte[(n + 1) / 2];
            byArray[n2++] = (byte)RAW.hexDigit2Nibble(cArray[n3++]);
        } else {
            byArray = new byte[n / 2];
        }
        while (n2 < byArray.length) {
            byArray[n2] = (byte)(RAW.hexDigit2Nibble(cArray[n3++]) << 4 | RAW.hexDigit2Nibble(cArray[n3++]));
            ++n2;
        }
        return byArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Object makeJdbcArray(int n) {
        return new byte[n][];
    }

    public static RAW newRAW(Object object) throws SQLException {
        RAW rAW = new RAW(object);
        return rAW;
    }

    public static RAW oldRAW(Object object) throws SQLException {
        RAW rAW;
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = null;
            try {
                byArray = string.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                DatabaseError.throwSqlException(109, "ISO8859_1 character encoding not found");
            }
            rAW = new RAW(byArray);
        } else {
            rAW = new RAW(object);
        }
        return rAW;
    }

    public String stringValue() {
        String string = RepConversion.bArray2String(this.getBytes());
        return string;
    }

    public Object toJdbc() throws SQLException {
        return this.getBytes();
    }
}

