/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.i18n.net.MimeUtility;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.LocaleMapper;
import oracle.sql.converter.CharacterConverters;

public class MimeUtility {
    static final byte BYTE_ERROR = -1;
    private static final byte M_C_BYTE_NULL = 0;
    private static final byte M_C_BYTE_LF = 10;
    private static final byte M_C_BYTE_CR = 13;
    private static final byte M_C_BYTE_SP = 32;
    private static final byte M_C_BYTE_PLUS = 43;
    private static final byte M_C_BYTE_SLASH = 47;
    private static final byte M_C_BYTE_ZERO = 48;
    private static final byte M_C_BYTE_NINE = 57;
    private static final byte M_C_BYTE_EQUAL = 61;
    private static final byte M_C_BYTE_GT = 62;
    private static final byte M_C_BYTE_QUESTION = 63;
    private static final byte M_C_BYTE_ATMARK = 64;
    private static final byte M_C_BYTE_CAP_A = 65;
    private static final byte M_C_BYTE_CAP_F = 70;
    private static final byte M_C_BYTE_CAP_Z = 90;
    private static final byte M_C_BYTE_LOWLINE = 95;
    private static final byte M_C_BYTE_A = 97;
    private static final byte M_C_BYTE_F = 102;
    private static final byte M_C_BYTE_Z = 122;
    private static final byte M_C_BYTE_TILDE = 126;
    private static final byte M_C_BYTE_ESC = 27;
    private static final byte[] M_C_HEX2VAL_TBL = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int resw = "=??b??=".length();
    private static final int M_C_MAX_BASE64_WIDTH = 64;
    private static final int M_C_MAX_QP_WIDTH = 75;
    private static final byte[] M_C_BASE64_MAPPING = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte[] M_C_QP_MAPPING = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int AL16UTF16_CHARSET = 2000;
    private static final int AL16UTF16LE_CHARSET = 2002;
    private static final int UNICODE_1_CHARSET = 870;
    private static final int UNICODE_2_CHARSET = 871;
    private static final int AL32UTF8_CHARSET = 873;
    private static final int ISO_2022_JP_CHARSET = 9999;
    private static String defaultJavaCharset;
    private static String defaultMIMECharset;
    private static boolean decodeStrict;
    private static boolean foldEncodedWords;
    private static Hashtable mime2java;
    private static Hashtable java2mime;
    static final int ALL_ASCII = 1;
    static final int MOSTLY_ASCII = 2;
    static final int MOSTLY_NONASCII = 3;
    private static final char[] base64_array;
    private static String SPECIALWORD;
    private static String SPECIALTEXT;
    private static final char[] hex_array;

    private MimeUtility() {
    }

    static byte hex2val(byte by) {
        return by > 0 ? M_C_HEX2VAL_TBL[by] : (byte)-1;
    }

    private static String getIANACharset(String string) throws UnsupportedEncodingException {
        String string2 = null;
        String string3 = null;
        string2 = LocaleMapper.getIANACharacterSet(1, string);
        if (string2 == null) {
            string3 = LocaleMapper.getOraCharacterSet(2, string);
            if (string3 == null) {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
            }
            string2 = string;
        } else {
            string3 = string;
        }
        return string2.toLowerCase(Locale.US);
    }

    public static String encodeHeader(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = MimeUtility.getIANACharset(string2);
        String string5 = string3.equalsIgnoreCase("B") ? "B" : "Q";
        int n = string5 == "B" ? 64 - resw - string4.length() : 75 - resw - string4.length();
        String string6 = MimeUtility.encodeBody(string, string4, string5, n);
        StringBuffer stringBuffer = new StringBuffer(string6.length() + resw + string4.length());
        String string7 = "=?" + string4 + "?" + string5 + "?";
        StringTokenizer stringTokenizer = new StringTokenizer(string6, "\r\n");
        int n2 = stringTokenizer.countTokens();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(string7);
            String string8 = stringTokenizer.nextToken();
            stringBuffer.append(string8);
            stringBuffer.append("?=");
            if (n3 < n2 - 1) {
                stringBuffer.append("\r\n ");
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    static String encodeBody(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = MimeUtility.getIANACharset(string2);
        String string5 = string3.equalsIgnoreCase("B") ? "B" : "Q";
        int n = string5 == "B" ? 64 : 75;
        return MimeUtility.encodeBody(string, string4, string5, n);
    }

    private static String encodeBody(String string, String string2, String string3, int n) throws UnsupportedEncodingException {
        String string4 = null;
        string4 = string3 == "B" ? MimeUtility.encodeBodyBase64(string, string2, n) : MimeUtility.encodeBodyQP(string, string2, n);
        return string4;
    }

    private static byte base64_byte1(byte by) {
        return (byte)(by >>> 2 & 0x3F);
    }

    private static byte base64_byte2(byte by, byte by2) {
        return (byte)((by << 4 | by2 >>> 4 & 0xF) & 0x3F);
    }

    private static byte base64_byte3(byte by, byte by2) {
        return (byte)((by << 2 | by2 >>> 6 & 3) & 0x3F);
    }

    private static byte base64_byte4(byte by) {
        return (byte)(by & 0x3F);
    }

    private static String encodeBodyBase64(String string, String string2, int n) throws UnsupportedEncodingException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3 / 2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        int n5 = 0;
        while (n2 < n3) {
            String string3;
            int n6;
            n5 = n3 - n2;
            n4 = n5 < n4 ? n5 : n4;
            byte[] byArray = null;
            while ((n6 = (byArray = MimeUtility.getBytes(string3 = string.substring(n2, n2 + n4), string2)).length * 4 / 3) >= n) {
                n4 /= 2;
            }
            n2 += n4;
            int n7 = 0;
            while (n7 + 2 < byArray.length) {
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], byArray[n7 + 1])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte3(byArray[n7 + 1], byArray[n7 + 2])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte4(byArray[n7 + 2])]);
                n7 += 3;
            }
            switch (byArray.length - n7) {
                case 0: {
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], (byte)0)]);
                    byteArrayOutputStream.write(61);
                    byteArrayOutputStream.write(61);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], byArray[n7 + 1])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte3(byArray[n7 + 1], (byte)0)]);
                    byteArrayOutputStream.write(61);
                }
            }
            byteArrayOutputStream.write(13);
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toString("ISO-8859-1");
    }

    private static String encodeBodyQP(String string, String string2, int n) throws UnsupportedEncodingException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3 / 2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n5 = 0;
        while (n2 < n3) {
            String string3;
            int n6;
            n5 = n3 - n2;
            n4 = n5 < n4 ? n5 : n4;
            byte[] byArray = null;
            while ((n6 = (byArray = MimeUtility.getBytes(string3 = string.substring(n2, n2 + n4), string2)).length * 3) >= n) {
                n4 /= 2;
            }
            n2 += n4;
            int n7 = 0;
            while (n7 < byArray.length) {
                if ((n6 = byArray[n7++] & 0xFF) == 13 && n7 < byArray.length && byArray[n7] == 10) {
                    byteArrayOutputStream.write(13);
                    byteArrayOutputStream.write(byArray[n7++]);
                    continue;
                }
                if (n6 == 63 || n6 == 95 || n6 == 61 || n6 <= 32 || n6 > 126) {
                    byteArrayOutputStream.write(61);
                    byteArrayOutputStream.write(M_C_QP_MAPPING[n6 >>> 4]);
                    byteArrayOutputStream.write(M_C_QP_MAPPING[n6 & 0xF]);
                    continue;
                }
                byteArrayOutputStream.write(n6);
            }
            byteArrayOutputStream.write(13);
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toString("ISO-8859-1");
    }

    public static String decodeHeader(String string) throws UnsupportedEncodingException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n \t");
        String string2 = null;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (!((String)object).startsWith("=?")) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5205));
                }
                int n = ((String)object).indexOf(63, 2);
                string2 = ((String)object).substring(2, n);
                String string3 = ((String)object).substring(n + 1, n + 2);
                String string4 = ((String)object).substring(n + 3, ((String)object).indexOf(63, n + 3));
                byteArrayOutputStream.write(MimeUtility.decodeBodyArray(string4, string3));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 != null) {
            object = byteArrayOutputStream.toByteArray();
            return MimeUtility.toString((byte[])object, 0, ((Object)object).length, string2);
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    static String decodeBody(String var0, String var1_1, String var2_2) throws UnsupportedEncodingException {
        block2: {
            var3_3 = MimeUtility.getIANACharset(var1_1);
            var4_4 = var2_2.equalsIgnoreCase("B") != false ? "B" : "Q";
            var5_5 = new StringBuffer("");
            var6_6 = new StringTokenizer(var0, "\r\n");
            if (var4_4 != "B") ** GOTO lbl13
            while (var6_6.hasMoreTokens()) {
                var5_5.append(MimeUtility.decodeBodyBase64(var6_6.nextToken(), var3_3));
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var5_5.append(MimeUtility.decodeBodyQP(var6_6.nextToken(), var3_3));
lbl13:
                // 2 sources

                ** while (var6_6.hasMoreTokens())
            }
        }
        return var5_5.toString();
    }

    private static byte[] decodeBodyArray(String string, String string2) throws UnsupportedEncodingException {
        String string3;
        String string4 = string3 = string2.equalsIgnoreCase("B") ? "B" : "Q";
        if (string3 == "B") {
            return MimeUtility.decodeBodyArrayBase64(string);
        }
        return MimeUtility.decodeBodyArrayQP(string);
    }

    private static String decodeBodyQP(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = MimeUtility.decodeBodyArrayQP(string);
        return MimeUtility.toString(byArray, 0, byArray.length, string2);
    }

    private static byte[] decodeBodyArrayQP(String string) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes("iso-8859-1");
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block9: while (n4 < n) {
            byte by = byArray[n4++];
            switch (by) {
                case 61: {
                    if (n4 >= n) continue block9;
                    by = byArray[n4++];
                    switch (by) {
                        case 0: {
                            --n4;
                            break;
                        }
                        case 10: 
                        case 13: {
                            byte by2;
                            n2 = n3;
                            if (n4 >= n || (by2 = byArray[n4]) != 13 && by2 != 10) continue block9;
                            ++n4;
                            break;
                        }
                        default: {
                            byte by3;
                            if (n4 >= n || (by = MimeUtility.hex2val(by)) == -1 || (by3 = MimeUtility.hex2val(byArray[n4++])) == -1) {
                                throw new IllegalArgumentException(GDKMessage.getMessage(5204));
                            }
                            byArray2[n3++] = (byte)(by3 + (by << 4));
                            n2 = n3;
                            break;
                        }
                    }
                    continue block9;
                }
                case 32: {
                    byArray2[n3++] = by;
                    break;
                }
                case 13: {
                    n3 = n2;
                    byArray2[n3++] = by;
                    n2 = n3;
                    break;
                }
                default: {
                    byArray2[n3++] = by;
                    n2 = n3;
                }
            }
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    private static String decodeBodyBase64(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = MimeUtility.decodeBodyArrayBase64(string);
        return MimeUtility.toString(byArray, 0, byArray.length, string2);
    }

    private static byte[] decodeBodyArrayBase64(String string) throws UnsupportedEncodingException {
        int n;
        byte[] byArray = string.getBytes("iso-8859-1");
        int n2 = n = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            byte by = 0;
            if (byArray[n4] == 61) break;
            if (byArray[n4] >= 65 && byArray[n4] <= 90) {
                by = (byte)(byArray[n4] - 65);
            } else if (byArray[n4] >= 97 && byArray[n4] <= 122) {
                by = (byte)(byArray[n4] - 97 + 26);
            } else if (byArray[n4] >= 48 && byArray[n4] <= 57) {
                by = (byte)(byArray[n4] - 48 + 52);
            } else if (byArray[n4] == 43) {
                by = (byte)62;
            } else if (byArray[n4] == 47) {
                by = (byte)63;
            } else {
                by = (byte)64;
                if (byArray[n4] == 10 || byArray[n4] == 13) {
                    --n5;
                }
            }
            if (by < 64) {
                switch (n5 & 3) {
                    case 0: {
                        byArray2[n3] = (byte)(by << 2);
                        break;
                    }
                    case 1: {
                        int n6 = n3++;
                        byArray2[n6] = (byte)(byArray2[n6] | (byte)(by >>> 4));
                        byArray2[n3] = (byte)((by & 0xF) << 4);
                        break;
                    }
                    case 2: {
                        int n7 = n3++;
                        byArray2[n7] = (byte)(byArray2[n7] | (byte)((by & 0x3C) >>> 2));
                        byArray2[n3] = (byte)((by & 3) << 6);
                        break;
                    }
                    default: {
                        int n8 = n3++;
                        byArray2[n8] = (byte)(byArray2[n8] | by);
                    }
                }
            }
            ++n4;
            ++n5;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    static byte[] getBytes(String string, String string2) throws UnsupportedEncodingException {
        String string3 = MimeUtility.getOraCharacterSet(string2);
        String string4 = OraBoot.getInstance().getCharSetId(string3);
        if (string4 == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
        }
        int n = Integer.parseInt(string4);
        switch (n) {
            case 870: 
            case 871: {
                return string.getBytes("UTF-8");
            }
            case 873: {
                return string.getBytes("UTF-8");
            }
            case 9999: {
                return string.getBytes("X-ORACLE-ISO2022-JP");
            }
            case 2000: 
            case 2002: {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
            }
        }
        CharacterConverters characterConverters = CharacterConverterOGS.getInstance(n);
        if (characterConverters == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
        }
        return characterConverters.toOracleStringWithReplacement(string);
    }

    static String toString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        String string2 = MimeUtility.getOraCharacterSet(string);
        String string3 = OraBoot.getInstance().getCharSetId(string2);
        if (string3 == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
        }
        int n3 = Integer.parseInt(string3);
        switch (n3) {
            case 870: 
            case 871: {
                return new String(byArray, n, n2, "UTF-8");
            }
            case 873: {
                return new String(byArray, n, n2, "UTF-8");
            }
            case 9999: {
                return new String(byArray, n, n2, "X-ORACLE-ISO2022-JP");
            }
            case 2000: 
            case 2002: {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
            }
        }
        CharacterConverters characterConverters = CharacterConverterOGS.getInstance(n3);
        if (characterConverters == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
        }
        return characterConverters.toUnicodeStringWithReplacement(byArray, n, n2);
    }

    static String getOraCharacterSet(String string) {
        String string2 = LocaleMapper.getOraCharacterSet(2, string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static String mimeCharset(String string) {
        String string2 = (String)java2mime.get(string.toLowerCase());
        return string2 == null ? string : string2;
    }

    public static String javaCharset(String string) {
        String string2 = (String)mime2java.get(string.toLowerCase());
        return string2 == null ? string : string2;
    }

    public static String getDefaultJavaCharset() {
        block6: {
            if (defaultJavaCharset == null) {
                String string = null;
                try {
                    string = System.getProperty("mail.mime.charset");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (string != null && string.length() > 0) {
                    defaultJavaCharset = MimeUtility.javaCharset(string);
                    return defaultJavaCharset;
                }
                try {
                    defaultJavaCharset = System.getProperty("file.encoding", "8859_1");
                }
                catch (SecurityException securityException) {
                    class NullInputStream
                    extends InputStream {
                        NullInputStream() {
                        }

                        public int read() {
                            return 0;
                        }
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(new NullInputStream());
                    defaultJavaCharset = inputStreamReader.getEncoding();
                    if (defaultJavaCharset != null) break block6;
                    defaultJavaCharset = "8859_1";
                }
            }
        }
        return defaultJavaCharset;
    }

    static String getDefaultMIMECharset() {
        if (defaultMIMECharset == null) {
            try {
                defaultMIMECharset = System.getProperty("mail.mime.charset");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (defaultMIMECharset == null) {
            defaultMIMECharset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        return defaultMIMECharset;
    }

    public static String decodeWord(String string, String string2) throws UnsupportedEncodingException {
        if (!string.startsWith("=?")) {
            throw new UnsupportedEncodingException();
        }
        String string3 = string2 == null ? MimeUtility.getDefaultJavaCharset() : (string2.toUpperCase().equals("ISO-2022-JP") ? LocaleMapper.getJavaCharacterSet(2, string2) : MimeUtility.javaCharset(string2));
        int n = 2;
        int n2 = string.indexOf(63, n);
        if (n2 == -1) {
            throw new UnsupportedEncodingException();
        }
        n = n2 + 1;
        if ((n2 = string.indexOf(63, n)) == -1) {
            throw new UnsupportedEncodingException();
        }
        String string4 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf("?=", n)) == -1) {
            throw new UnsupportedEncodingException();
        }
        String string5 = string.substring(n, n2);
        try {
            byte[] byArray = MimeUtility.decodeBodyArray(string5, string4);
            String string6 = new String(byArray, string3);
            if (n2 + 2 < string.length()) {
                String string7 = string.substring(n2 + 2);
                if (!decodeStrict) {
                    string7 = MimeUtility.decodeInnerWords(string7);
                }
                string6 = string6 + string7;
            }
            return string6;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw new UnsupportedEncodingException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException();
        }
    }

    public static String decodeWord(String string) throws UnsupportedEncodingException {
        if (!string.startsWith("=?")) {
            throw new UnsupportedEncodingException();
        }
        int n = 2;
        int n2 = string.indexOf(63, n);
        if (n2 == -1) {
            throw new UnsupportedEncodingException();
        }
        String string2 = MimeUtility.javaCharset(string.substring(n, n2));
        n = n2 + 1;
        if ((n2 = string.indexOf(63, n)) == -1) {
            throw new UnsupportedEncodingException();
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf("?=", n)) == -1) {
            throw new UnsupportedEncodingException();
        }
        String string4 = string.substring(n, n2);
        try {
            byte[] byArray = MimeUtility.decodeBodyArray(string4, string3);
            String string5 = new String(byArray, string2);
            if (n2 + 2 < string.length()) {
                String string6 = string.substring(n2 + 2);
                if (!decodeStrict) {
                    string6 = MimeUtility.decodeInnerWords(string6);
                }
                string5 = string5 + string6;
            }
            return string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw new UnsupportedEncodingException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException();
        }
    }

    private static String decodeInnerWords(String string) throws UnsupportedEncodingException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf("=?", n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            int n3 = string.indexOf("?=", n);
            if (n3 < 0) break;
            String string2 = string.substring(n, n3 + 2);
            try {
                string2 = MimeUtility.decodeWord(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append(string2);
            n2 = n3 + 2;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private static String decodeInnerWords(String string, String string2) throws UnsupportedEncodingException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf("=?", n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            int n3 = string.indexOf("?=", n);
            if (n3 < 0) break;
            String string3 = string.substring(n, n3 + 2);
            try {
                string3 = MimeUtility.decodeWord(string3, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append(string3);
            n2 = n3 + 2;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String encodeText(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(string, null, null);
    }

    public static String encodeText(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, false);
    }

    public static String decodeText(String string) throws UnsupportedEncodingException {
        String string2 = MimeUtility.normalizeText(string);
        String string3 = "\t\n\r";
        if (string2.indexOf("=?") == -1) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            block6: {
                String string5 = stringTokenizer.nextToken();
                char c = string5.charAt(0);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    stringBuffer2.append(c);
                    continue;
                }
                try {
                    string4 = MimeUtility.decodeWord(string5);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string4 = string5;
                    if (!decodeStrict) {
                        string4 = MimeUtility.decodeInnerWords(string4);
                    }
                    if (stringBuffer2.length() <= 0) break block6;
                    stringBuffer.append(stringBuffer2);
                }
            }
            stringBuffer.append(string4);
            stringBuffer2.setLength(0);
        }
        return stringBuffer.toString();
    }

    public static String decodeText(String string, String string2) throws UnsupportedEncodingException {
        String string3 = MimeUtility.normalizeText(string);
        String string4 = "\t\n\r";
        if (string3.indexOf("=?") == -1) {
            return string3;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string4, true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            block6: {
                String string6 = stringTokenizer.nextToken();
                char c = string6.charAt(0);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    stringBuffer2.append(c);
                    continue;
                }
                try {
                    string5 = MimeUtility.decodeWord(string6, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string5 = string6;
                    if (!decodeStrict) {
                        string5 = MimeUtility.decodeInnerWords(string5, string2);
                    }
                    if (stringBuffer2.length() <= 0) break block6;
                    stringBuffer.append(stringBuffer2);
                }
            }
            stringBuffer.append(string5);
            stringBuffer2.setLength(0);
        }
        return stringBuffer.toString();
    }

    public static String encodeWord(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, null, null);
    }

    public static String encodeWord(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, true);
    }

    private static String encodeWord(String string, String string2, String string3, boolean bl) throws UnsupportedEncodingException {
        boolean bl2;
        String string4;
        int n = MimeUtility.checkAscii(string);
        if (n == 1) {
            return string;
        }
        if (string2 == null) {
            string4 = MimeUtility.getDefaultJavaCharset();
            string2 = MimeUtility.getDefaultMIMECharset();
        } else {
            string4 = string2.toUpperCase().equals("ISO-2022-JP") ? LocaleMapper.getJavaCharacterSet(2, string2) : MimeUtility.javaCharset(string2);
        }
        if (string3 == null) {
            string3 = n != 3 ? "Q" : "B";
        }
        if (string3.equalsIgnoreCase("B")) {
            bl2 = true;
        } else if (string3.equalsIgnoreCase("Q")) {
            bl2 = false;
        } else {
            throw new UnsupportedEncodingException("Unknown transfer encoding: " + string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        MimeUtility.doEncode(string, bl2, string4, 68 - string2.length(), "=?" + string2 + "?" + string3 + "?", true, bl, stringBuffer);
        return stringBuffer.toString();
    }

    static int checkAscii(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            if (MimeUtility.nonascii(string.charAt(n4))) {
                ++n2;
            } else {
                ++n;
            }
            ++n4;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n > n2) {
            return 2;
        }
        return 3;
    }

    static final boolean nonascii(int n) {
        return n >= 127 || n < 32 && n != 13 && n != 10 && n != 9;
    }

    private static void doEncode(String string, boolean bl, String string2, int n, String string3, boolean bl2, boolean bl3, StringBuffer stringBuffer) throws UnsupportedEncodingException {
        int n2;
        byte[] byArray = string.getBytes(string2);
        int n3 = bl ? (byArray.length + 2) / 3 * 4 : MimeUtility.QencodedLength(byArray, bl3);
        if (n3 > n && (n2 = string.length()) > 1) {
            MimeUtility.doEncode(string.substring(0, n2 / 2), bl, string2, n, string3, bl2, bl3, stringBuffer);
            MimeUtility.doEncode(string.substring(n2 / 2, n2), bl, string2, n, string3, false, bl3, stringBuffer);
        } else {
            byte[] byArray2 = new byte[]{};
            try {
                byArray2 = bl ? MimeUtility.encodeWordBase64(byArray) : MimeUtility.encodeWordQP(byArray, bl3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl2) {
                if (foldEncodedWords) {
                    stringBuffer.append("\r\n ");
                } else {
                    stringBuffer.append(" ");
                }
            }
            stringBuffer.append(string3);
            int n4 = 0;
            while (n4 < byArray2.length) {
                stringBuffer.append((char)byArray2[n4]);
                ++n4;
            }
            stringBuffer.append("?=");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] encodeWordBase64(byte[] var0) {
        var1_1 = 0;
        var2_2 = 0;
        var3_3 = new byte[(var0.length + 2) / 3 * 4];
        var4_4 = var0.length;
        if (var0.length != 0) ** GOTO lbl33
        return var0;
lbl-1000:
        // 1 sources

        {
            if (var4_4 == 1) {
                var5_5 = var0[var1_1++];
                var6_6 = 0;
                var7_7 = 0;
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[var5_5 >>> 2 & 63];
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[(var5_5 << 4 & 48) + (var6_6 >>> 4 & 15)];
                var3_3[var2_2++] = 61;
                var3_3[var2_2++] = 61;
            } else if (var4_4 == 2) {
                var5_5 = var0[var1_1++];
                var6_6 = var0[var1_1++];
                var7_7 = 0;
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[var5_5 >>> 2 & 63];
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[(var5_5 << 4 & 48) + (var6_6 >>> 4 & 15)];
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[(var6_6 << 2 & 60) + (var7_7 >>> 6 & 3)];
                var3_3[var2_2++] = 61;
            } else {
                var5_5 = var0[var1_1++];
                var6_6 = var0[var1_1++];
                var7_7 = var0[var1_1++];
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[var5_5 >>> 2 & 63];
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[(var5_5 << 4 & 48) + (var6_6 >>> 4 & 15)];
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[(var6_6 << 2 & 60) + (var7_7 >>> 6 & 3)];
                var3_3[var2_2++] = (byte)MimeUtility.base64_array[var7_7 & 63];
            }
            var4_4 -= 3;
lbl33:
            // 2 sources

            ** while (var4_4 > 0)
        }
lbl34:
        // 1 sources

        return var3_3;
    }

    private static int QencodedLength(byte[] byArray, boolean bl) {
        int n = 0;
        String string = bl ? SPECIALWORD : SPECIALTEXT;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            n = n3 < 32 || n3 >= 127 || string.indexOf(n3) != 0 ? (n += 3) : ++n;
            ++n2;
        }
        return n;
    }

    private static void encodeWordQP_output(int n, boolean bl, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (bl) {
            byteArrayOutputStream.write(61);
            byteArrayOutputStream.write(hex_array[n >> 4]);
            byteArrayOutputStream.write(hex_array[n & 0xF]);
        } else {
            byteArrayOutputStream.write(n);
        }
    }

    private static byte[] encodeWordQP(byte[] byArray, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = bl ? SPECIALWORD : SPECIALTEXT;
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 == 32) {
                MimeUtility.encodeWordQP_output(95, false, byteArrayOutputStream);
            } else if (n2 < 32 || n2 >= 127 || string.indexOf(n2) >= 0) {
                MimeUtility.encodeWordQP_output(n2, true, byteArrayOutputStream);
            } else {
                MimeUtility.encodeWordQP_output(n2, false, byteArrayOutputStream);
            }
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static String normalizeText(String string) {
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        String string2 = new String();
        n = 0;
        while (n < string.length()) {
            if (string.length() - 1 - n >= 2 && string.charAt(n) == '=' && string.charAt(n + 1) == '?') {
                if (string2.length() != 0 && bl3) {
                    if (string2.charAt(string2.length() - 1) != ' ') {
                        string2 = string2 + ' ';
                    }
                    string2 = string2 + '\n';
                }
                bl2 = true;
                bl3 = false;
            } else if (string.length() >= 2 && string.charAt(n) == '?' && string.charAt(n + 1) == '=') {
                bl2 = false;
            }
            string2 = string.charAt(n) == ' ' && !bl2 ? (bl3 ? string2 + string.charAt(n) : string2 + '\n') : string2 + string.charAt(n);
            ++n;
        }
        return string2;
    }

    static {
        decodeStrict = true;
        foldEncodedWords = false;
        mime2java = new Hashtable(40);
        java2mime = new Hashtable(10);
        try {
            String string = System.getProperty("mail.mime.decodetext.strict");
            decodeStrict = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.foldencodedwords");
            foldEncodedWords = string != null && string.equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        java2mime.put("8859_1", "ISO-8859-1");
        java2mime.put("iso8859_1", "ISO-8859-1");
        java2mime.put("iso8859-1", "ISO-8859-1");
        java2mime.put("8859_2", "ISO-8859-2");
        java2mime.put("iso8859_2", "ISO-8859-2");
        java2mime.put("iso8859-2", "ISO-8859-2");
        java2mime.put("8859_3", "ISO-8859-3");
        java2mime.put("iso8859_3", "ISO-8859-3");
        java2mime.put("iso8859-3", "ISO-8859-3");
        java2mime.put("8859_4", "ISO-8859-4");
        java2mime.put("iso8859_4", "ISO-8859-4");
        java2mime.put("iso8859-4", "ISO-8859-4");
        java2mime.put("8859_5", "ISO-8859-5");
        java2mime.put("iso8859_5", "ISO-8859-5");
        java2mime.put("iso8859-5", "ISO-8859-5");
        java2mime.put("8859_6", "ISO-8859-6");
        java2mime.put("iso8859_6", "ISO-8859-6");
        java2mime.put("iso8859-6", "ISO-8859-6");
        java2mime.put("8859_7", "ISO-8859-7");
        java2mime.put("iso8859_7", "ISO-8859-7");
        java2mime.put("iso8859-7", "ISO-8859-7");
        java2mime.put("8859_8", "ISO-8859-8");
        java2mime.put("iso8859_8", "ISO-8859-8");
        java2mime.put("iso8859-8", "ISO-8859-8");
        java2mime.put("8859_9", "ISO-8859-9");
        java2mime.put("iso8859_9", "ISO-8859-9");
        java2mime.put("iso8859-9", "ISO-8859-9");
        java2mime.put("sjis", "Shift_JIS");
        java2mime.put("ms932", "Shift_JIS");
        java2mime.put("jis", "ISO-java-JP");
        java2mime.put("iso2022jp", "ISO-2022-JP");
        java2mime.put("euc_jp", "euc-jp");
        java2mime.put("koi8_r", "koi8-r");
        java2mime.put("euc_cn", "euc-cn");
        java2mime.put("euc_tw", "euc-tw");
        java2mime.put("euc_kr", "euc-kr");
        java2mime.put("x-oracle-iso2022-jp", "ISO-2022-JP");
        java2mime.put("x-oracle-iso2022-jp-outlook", "ISO-2022-JP");
        java2mime.put("x-oracle-iso2022-jp-outlook-hwkana", "ISO-2022-JP");
        java2mime.put("iso8859_8", "ISO-8859-8-I");
        java2mime.put("iso-8859-8", "ISO-8859-8-I");
        mime2java.put("iso-2022-cn", "ISO2022CN");
        mime2java.put("iso-2022-kr", "ISO2022KR");
        mime2java.put("utf-8", "UTF8");
        mime2java.put("utf8", "UTF8");
        mime2java.put("ja_jp.iso2022-7", "ISO2022JP");
        mime2java.put("ja_jp.eucjp", "EUCJIS");
        mime2java.put("euc-kr", "KSC5601");
        mime2java.put("euckr", "KSC5601");
        mime2java.put("us-ascii", "ISO-8859-1");
        mime2java.put("x-us-ascii", "ISO-8859-1");
        mime2java.put("x-gbk", "GBK");
        mime2java.put("iso-8859-8-i", "ISO-8859-8");
        base64_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        SPECIALWORD = "=_?\"[\\]#$(),.:;%&'<>@^`{|}~";
        SPECIALTEXT = "=_?";
        hex_array = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

