/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.taglib.rt;

import java.text.ParseException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.servlet.taglib.rt.TagUtility;
import oracle.i18n.text.OraDecimalFormat;
import oracle.i18n.text.OraDecimalFormatSymbols;
import oracle.i18n.text.OraNumberFormat;
import oracle.i18n.util.GDKMessage;

public class FormatNumberTag
extends BodyTagSupport {
    private Object m_value = null;
    private String m_type = "";
    private String m_pattern = null;
    private String m_currencyCode = null;
    private String m_var = null;
    private int m_scope = -1;

    public void setValue(Number number) {
        this.m_value = number;
    }

    public void setValue(String string) {
        this.m_value = string;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void setPattern(String string) {
        this.m_pattern = string;
    }

    public void setCurrencyCode(String string) {
        this.m_currencyCode = string;
    }

    public void setVar(String string) {
        this.m_var = string;
    }

    public void setScope(String string) {
        this.m_scope = TagUtility.getScope(string);
    }

    public int doStartTag() throws JspException {
        if (this.m_scope != -1 && this.m_var == null) {
            throw new JspException(GDKMessage.getMessage(5216));
        }
        if (this.m_value != null) {
            if (!this.m_value.equals("")) {
                this.parseValue();
                TagUtility.output(this.m_var, this.m_scope, this.pageContext, this.getFormattedText());
            } else {
                TagUtility.removeValue(this.m_var, this.m_scope, this.pageContext);
            }
            return 0;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        this.m_value = this.getBodyContent().getString();
        if (this.m_value != null && !this.m_value.equals("")) {
            this.parseValue();
            TagUtility.output(this.m_var, this.m_scope, this.pageContext, this.getFormattedText());
        } else {
            TagUtility.removeValue(this.m_var, this.m_scope, this.pageContext);
        }
        return 0;
    }

    private void parseValue() throws JspException {
        if (this.m_value instanceof String) {
            int n = ((String)this.m_value).indexOf(46);
            try {
                this.m_value = n < 0 ? (Number)new Long((String)this.m_value) : (Number)new Double((String)this.m_value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JspException(numberFormatException.getMessage());
            }
        }
    }

    private String getFormattedText() throws JspException {
        LocaleSource localeSource = (LocaleSource)this.pageContext.findAttribute("oracle.i18n.servlet.localesource.LocaleSource.sessionkey");
        String string = null;
        if (this.m_pattern != null && !this.m_pattern.equals("")) {
            try {
                if (this.m_currencyCode != null) {
                    OraDecimalFormatSymbols oraDecimalFormatSymbols = new OraDecimalFormatSymbols(localeSource.getLocale());
                    oraDecimalFormatSymbols.setInternationalCurrencySymbol(this.m_currencyCode);
                    string = new OraDecimalFormat(this.m_pattern, oraDecimalFormatSymbols).format(this.m_value);
                }
                string = new OraDecimalFormat(this.m_pattern).format(this.m_value);
            }
            catch (ParseException parseException) {
                throw new JspException(parseException.getMessage());
            }
        } else if (this.m_type.equals("currency")) {
            OraNumberFormat oraNumberFormat = null;
            if (this.m_currencyCode == null) {
                oraNumberFormat = localeSource.getCurrencyFormat();
                if (oraNumberFormat == null) {
                    oraNumberFormat = OraNumberFormat.getCurrencyInstance(localeSource.getLocale());
                }
            } else {
                OraDecimalFormatSymbols oraDecimalFormatSymbols = new OraDecimalFormatSymbols(localeSource.getLocale());
                oraDecimalFormatSymbols.setInternationalCurrencySymbol(this.m_currencyCode);
                oraNumberFormat = localeSource.getCurrencyFormat();
                oraNumberFormat = oraNumberFormat == null ? OraNumberFormat.getCurrencyInstance(localeSource.getLocale()) : (OraDecimalFormat)oraNumberFormat.clone();
                ((OraDecimalFormat)oraNumberFormat).setOraDecimalFormatSymbols(oraDecimalFormatSymbols);
            }
            string = oraNumberFormat.format(this.m_value);
        } else {
            OraNumberFormat oraNumberFormat = localeSource.getNumberFormat();
            string = oraNumberFormat != null ? oraNumberFormat.format(this.m_value) : OraNumberFormat.getNumberInstance(localeSource.getLocale()).format(this.m_value);
        }
        return string;
    }

    public void release() {
        this.m_value = null;
        this.m_type = "";
        this.m_pattern = null;
        this.m_currencyCode = null;
        this.m_var = null;
        this.m_scope = -1;
    }
}

