/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.taglib.rt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import oracle.i18n.servlet.taglib.rt.TagUtility;
import oracle.i18n.util.GDKMessage;

public class MessageTag
extends BodyTagSupport {
    static final String M_C_KEY = "oracle.i18n.servlet.taglib.message";
    private String m_key = null;
    private ResourceBundle m_bundle = null;
    private String m_var = null;
    private int m_scope = -1;
    private List m_args = new ArrayList();
    private String m_key_prefix = "";

    public void setKey(String string) {
        this.m_key = this.m_key_prefix + string;
    }

    public void setBundle(ResourceBundle resourceBundle) {
        this.m_bundle = resourceBundle;
    }

    public void setVar(String string) {
        this.m_var = string;
    }

    public void setScope(String string) {
        this.m_scope = TagUtility.getScope(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArg(Object object) {
        List list = this.m_args;
        synchronized (list) {
            this.m_args.add(object);
        }
    }

    public int doStartTag() throws JspException {
        if (this.m_scope != -1 && this.m_var == null) {
            throw new JspException(GDKMessage.getMessage(5216));
        }
        if (this.m_bundle == null) {
            this.m_bundle = (ResourceBundle)this.pageContext.getAttribute("oracle.i18n.servlet.taglib.bundle");
        }
        this.m_key_prefix = (String)this.pageContext.getAttribute("oracle.i18n.servlet.taglib.bundle.prefix");
        return 2;
    }

    public int doAfterBody() throws JspException {
        if (this.m_key == null) {
            this.m_key = this.getBodyContent().getString();
        }
        String string = "";
        if (this.m_key == null || this.m_key.equals("")) {
            string = "??????";
        } else if (this.m_bundle == null) {
            string = "???<" + this.m_key + ">???";
        } else {
            Object[] objectArray = this.m_args.toArray(new Object[0]);
            if (objectArray.length == 0) {
                try {
                    string = this.m_bundle.getString(this.m_key);
                }
                catch (MissingResourceException missingResourceException) {
                    string = "???<" + this.m_key + ">???";
                }
            } else {
                string = MessageFormat.format(this.m_bundle.getString(this.m_key), objectArray);
            }
        }
        TagUtility.output(this.m_var, this.m_scope, this.pageContext, this.getPreviousOut(), string);
        return 0;
    }

    public void release() {
        this.m_key = null;
        this.m_bundle = null;
        this.m_var = null;
        this.m_scope = -1;
        this.m_args = new ArrayList();
        this.m_key_prefix = "";
    }
}

