/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.Sort;

public class OraBoot
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static OraBoot upCache = null;
    private static final String FILENAME = "/oracle/i18n/data/lx0boot.glb";
    protected HashMap languageIdMap = null;
    protected HashMap territoryIdMap = null;
    protected HashMap linguisticIdMap = null;
    protected HashMap charSetIdMap = null;
    protected HashMap tableIdMap = null;
    protected HashMap idtoLanguageMap = null;
    protected HashMap idtoTerritoryMap = null;
    protected HashMap idtoCharSetMap = null;
    protected HashMap idtoLinguisticMap = null;
    protected HashMap idtoTableMap = null;
    protected String[] availableLang = null;
    protected String[] availableTerr = null;
    protected String[] availableCharSet = null;
    protected String[] availableLing = null;

    protected OraBoot() {
    }

    public static synchronized OraBoot getInstance() {
        if (upCache == null) {
            ConverterArchive converterArchive = new ConverterArchive();
            upCache = (OraBoot)converterArchive.readObj(FILENAME);
        }
        return upCache;
    }

    public String getLanguageFileName(String string) {
        return (String)this.languageIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getTerritoryFileName(String string) {
        return (String)this.territoryIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getTerritoryFileName(String string, String string2) {
        if (string == null) {
            return (String)this.territoryIdMap.get(string2.toUpperCase(Locale.US));
        }
        String string3 = string.toUpperCase(Locale.US);
        String string4 = string2.toUpperCase(Locale.US);
        String string5 = (String)this.territoryIdMap.get(string3 + "_" + string4);
        if (string5 != null) {
            return string5;
        }
        return (String)this.territoryIdMap.get(string4);
    }

    public String getLinguisticFileName(String string) {
        return (String)this.linguisticIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getCharSetFileName(String string) {
        return OraBoot.formatFileName("lx2", (String)this.charSetIdMap.get(string.toUpperCase(Locale.US)));
    }

    public String getTableFileName(String string) {
        return (String)this.tableIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getCharSetId(String string) {
        return (String)this.charSetIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getLanguageName(String string) {
        return (String)this.idtoLanguageMap.get(string);
    }

    public String getTerritoryName(String string) {
        return (String)this.idtoTerritoryMap.get(string);
    }

    public String getCharSetName(String string) {
        return (String)this.idtoCharSetMap.get(string);
    }

    public String getLinguisticName(String string) {
        return (String)this.idtoLinguisticMap.get(string);
    }

    public String getTableName(String string) {
        return (String)this.idtoTableMap.get(string);
    }

    public synchronized String[] availableLanguages() {
        if (this.availableLang != null) {
            return this.availableLang;
        }
        this.availableLang = new String[this.languageIdMap.size()];
        this.availableLang = this.languageIdMap.keySet().toArray(this.availableLang);
        Sort.quickSort(this.availableLang, 0, this.availableLang.length - 1);
        return this.availableLang;
    }

    public synchronized String[] availableTerritories() {
        if (this.availableTerr != null) {
            return this.availableTerr;
        }
        Vector vector = new Vector();
        vector.addAll(this.territoryIdMap.keySet());
        int n = 0;
        while (n < vector.size()) {
            if (((String)vector.elementAt(n)).indexOf(95) != -1) {
                vector.removeElementAt(n--);
            }
            ++n;
        }
        vector.trimToSize();
        this.availableTerr = new String[vector.size()];
        this.availableTerr = vector.toArray(this.availableTerr);
        Sort.quickSort(this.availableTerr, 0, this.availableTerr.length - 1);
        return this.availableTerr;
    }

    public synchronized String[] availableCharacterSets() {
        return this.availableCharSet;
    }

    public synchronized String[] availableLinguisticSorts() {
        if (this.availableLing != null) {
            return this.availableLing;
        }
        this.availableLing = new String[this.linguisticIdMap.size()];
        this.availableLing = this.linguisticIdMap.keySet().toArray(this.availableLing);
        Sort.quickSort(this.availableLing, 0, this.availableLing.length - 1);
        return this.availableLing;
    }

    protected static String formatFileName(String string, String string2) {
        String string3 = "0000";
        String string4 = Integer.toHexString(Integer.parseInt(string2));
        String string5 = string3.substring(0, string3.length() - string4.length()) + string4;
        return string + string5;
    }

    public static void main(String[] stringArray) {
        OraBoot oraBoot = OraBoot.getInstance();
        System.out.println(oraBoot.getTerritoryFileName("AMERIcAN", "FInlAND"));
        System.out.println(oraBoot.getTerritoryFileName("SwedIsH", "FInlAND"));
        System.out.println(oraBoot.getCharSetFileName("us7ascii"));
        System.out.println(oraBoot.getCharSetId("us7ascii"));
        System.out.println(oraBoot.getTableFileName("CHAR_SUPERSET_MAPPING"));
        System.out.println(oraBoot.getLinguisticFileName("BENGALI"));
        System.out.println(oraBoot.getLanguageFileName("ESTONIAN"));
    }
}

