/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.HashMap;
import java.util.Vector;
import oracle.i18n.util.Sort;
import oracle.i18n.util.builder.NLTParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.NLTSchemaParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BootParser
extends NLTSchemaParser {
    private static final String HEXPREFIX = "0000";

    public BootParser(String string) throws NLTParserException {
        super(string);
        this.topNode = NLTParser.findNode((Node)this.doc, "NLSBOOT");
        if (this.topNode == null) {
            throw new NLTParserException("Pattern NLSBOOT not found!");
        }
    }

    public String getVERSION() {
        return this.getStringValue("VERSION");
    }

    public HashMap getLanguage() throws NLTParserException {
        NodeList nodeList = NLTParser.findNodes(this.topNode, "LANGUAGE");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeName() == "LANGUAGE") {
                String string = node.getFirstChild().getNodeValue();
                NamedNodeMap namedNodeMap = node.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                String string2 = node.getNodeValue();
                hashMap.put(string, BootParser.formatFileName("lx0", string2));
            }
            ++n2;
        }
        return hashMap;
    }

    public HashMap getTerritory() throws NLTParserException {
        NodeList nodeList = NLTParser.findNodes(this.topNode, "TERRITORY");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeName() == "TERRITORY") {
                String string = node.getFirstChild().getNodeValue();
                NamedNodeMap namedNodeMap = node.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                String string2 = node.getNodeValue();
                node = namedNodeMap.getNamedItem("language");
                hashMap.put(string, BootParser.formatFileName("lx1", string2));
                if (node != null) {
                    String string3;
                    String string4 = node.getNodeValue();
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 1;
                    while ((n4 = string4.indexOf(44, n3)) != -1) {
                        string3 = string4.substring(n3, n4);
                        hashMap.put(string3 + "_" + string, BootParser.formatFileName("lx1", string2, n5++));
                        n3 = n4 + 1;
                    }
                    string3 = string4.substring(n3);
                    hashMap.put(string3 + "_" + string, BootParser.formatFileName("lx1", string2, n5));
                }
            }
            ++n2;
        }
        return hashMap;
    }

    public String[] getAvailableCharacterSet() throws NLTParserException {
        Object object;
        NodeList nodeList = NLTParser.findNodes(this.topNode, "CHARACTER_SET");
        int n = nodeList.getLength();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            object = nodeList.item(n2);
            if (object.getNodeName() == "CHARACTER_SET") {
                String string;
                String string2 = object.getFirstChild().getNodeValue();
                NamedNodeMap namedNodeMap = object.getAttributes();
                if ((object = namedNodeMap.getNamedItem("support")) == null || (string = object.getNodeValue()) == null || !string.equals("conversion_only")) {
                    object = namedNodeMap.getNamedItem("id");
                    string = object.getNodeValue();
                    int n3 = 0;
                    int n4 = 0;
                    while ((n4 = string2.indexOf(44, n3)) != -1) {
                        vector.add(string2.substring(n3, n4));
                        n3 = n4 + 1;
                    }
                    vector.add(string2.substring(n3));
                }
            }
            ++n2;
        }
        vector.trimToSize();
        object = new String[vector.size()];
        object = vector.toArray((T[])object);
        Sort.quickSort((Object[])object, 0, ((String[])object).length - 1);
        return object;
    }

    public HashMap getCharacterSet() throws NLTParserException {
        NodeList nodeList = NLTParser.findNodes(this.topNode, "CHARACTER_SET");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeName() == "CHARACTER_SET") {
                String string = node.getFirstChild().getNodeValue();
                NamedNodeMap namedNodeMap = node.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                String string2 = node.getNodeValue();
                int n3 = 0;
                int n4 = 0;
                while ((n4 = string.indexOf(44, n3)) != -1) {
                    hashMap.put(string.substring(n3, n4), string2);
                    n3 = n4 + 1;
                }
                hashMap.put(string.substring(n3), string2);
            }
            ++n2;
        }
        return hashMap;
    }

    public HashMap getLinguistic() throws NLTParserException {
        NodeList nodeList = NLTParser.findNodes(this.topNode, "LINGUISTIC_DEFINITION");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeName() == "LINGUISTIC_DEFINITION") {
                String string = node.getFirstChild().getNodeValue();
                NamedNodeMap namedNodeMap = node.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                String string2 = node.getNodeValue();
                hashMap.put(string, BootParser.formatFileName("lx3", string2));
            }
            ++n2;
        }
        return hashMap;
    }

    public HashMap getTable() throws NLTParserException {
        NodeList nodeList = NLTParser.findNodes(this.topNode, "TABLE");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeName() == "TABLE") {
                String string = node.getFirstChild().getNodeValue();
                NamedNodeMap namedNodeMap = node.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                String string2 = node.getNodeValue();
                hashMap.put(string, BootParser.formatFileName("lx4", string2));
            }
            ++n2;
        }
        return hashMap;
    }

    private HashMap getIdtoObject(String string) throws NLTParserException {
        NodeList nodeList = NLTParser.findNodes(this.topNode, string);
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeName() == string) {
                String string2 = node.getFirstChild().getNodeValue();
                NamedNodeMap namedNodeMap = node.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                String string3 = node.getNodeValue();
                int n3 = 0;
                n3 = string2.indexOf(44);
                if (n3 != -1) {
                    hashMap.put(string3, string2.substring(0, n3));
                } else {
                    hashMap.put(string3, string2);
                }
            }
            ++n2;
        }
        return hashMap;
    }

    public HashMap getIdtoLanguage() throws NLTParserException {
        return this.getIdtoObject("LANGUAGE");
    }

    public HashMap getIdtoTerritory() throws NLTParserException {
        return this.getIdtoObject("TERRITORY");
    }

    public HashMap getIdtoCharacterSet() throws NLTParserException {
        return this.getIdtoObject("CHARACTER_SET");
    }

    public HashMap getIdtoLinguistic() throws NLTParserException {
        return this.getIdtoObject("LINGUISTIC_DEFINITION");
    }

    public HashMap getIdtoTable() throws NLTParserException {
        return this.getIdtoObject("TABLE");
    }

    private static String formatFileName(String string, String string2) {
        String string3 = Integer.toHexString(Integer.parseInt(string2));
        String string4 = HEXPREFIX.substring(0, HEXPREFIX.length() - string3.length()) + string3;
        return string + string4;
    }

    private static String formatFileName(String string, String string2, int n) {
        String string3 = Integer.toHexString(Integer.parseInt(string2));
        String string4 = Integer.toHexString(n);
        String string5 = HEXPREFIX.substring(0, HEXPREFIX.length() - string3.length()) + string3 + string4;
        return string + string5;
    }
}

