/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterJAEUC;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.sql.converter.CharacterConverters;

public class CharConvJAEUCBuilder
extends CharConvBuilder {
    static final boolean DEBUG = false;
    static final int LCSHIFT = 16;
    static final int LCMASK = 65535;
    static final int INVALIDLC = 65535;
    static final int MAXCHARVALUE = 65535;
    int m_l1BlockSize;
    char[] m_leadingCode;
    int m_lcCount;
    CharacterConverterJAEUC charConvJAEUCObj = new CharacterConverterJAEUC();

    public void buildGLB(CharacterConverters characterConverters, String string, String string2, String string3, boolean bl) throws IOException {
        try {
            int n;
            CharSetParser charSetParser = new CharSetParser(string3);
            String string4 = charSetParser.getName();
            this.charConvJAEUCObj.m_oracleId = Integer.parseInt(charSetParser.getId());
            this.charConvJAEUCObj.m_ucsCharReplacement = 65533;
            String string5 = charSetParser.getDefaultReplacementChar();
            if (string5 != null) {
                n = CharConvBuilder.stringToInt(string5);
                if (((long)n & 0xFFFFFFFFL) > 255L) {
                    throw new NLTParserException("ReplacementChar too big");
                }
                this.charConvJAEUCObj.m_1ByteOraCharReplacement = (char)(n & 0xFF);
            }
            if ((string5 = charSetParser.getDefaultMultibyteReplacementChar()) != null) {
                n = CharConvBuilder.stringToInt(string5);
                if (((long)n & 0xFFFFFFFFL) > 65535L) {
                    throw new NLTParserException("ReplacementChar too big");
                }
                this.charConvJAEUCObj.m_2ByteOraCharReplacement = (char)(n & 0xFFFF);
            }
            if (string4 == null || this.charConvJAEUCObj.m_oracleId == 0) {
                System.err.println("Missing data in file " + string3);
                System.err.println("No output file created");
                return;
            }
            boolean bl2 = charSetParser.haveExtraUnicodeMapping();
            String string6 = CharConvBuilder.formatCharConvClassName(this.charConvJAEUCObj.m_oracleId);
            if (characterConverters != null) {
                if (this.charConvJAEUCObj.m_ucsCharReplacement == 0) {
                    this.charConvJAEUCObj.m_ucsCharReplacement = characterConverters.getUCS2CharRep();
                }
                if (this.charConvJAEUCObj.m_1ByteOraCharReplacement == '\u0000') {
                    this.charConvJAEUCObj.m_1ByteOraCharReplacement = characterConverters.getOraChar1ByteRep();
                }
                if (this.charConvJAEUCObj.m_2ByteOraCharReplacement == '\u0000') {
                    this.charConvJAEUCObj.m_2ByteOraCharReplacement = characterConverters.getOraChar2ByteRep();
                }
            }
            if (this.charConvJAEUCObj.m_1ByteOraCharReplacement == '\u0000') {
                this.charConvJAEUCObj.m_1ByteOraCharReplacement = (char)63;
            }
            if (this.charConvJAEUCObj.m_2ByteOraCharReplacement == '\u0000') {
                this.charConvJAEUCObj.m_2ByteOraCharReplacement = this.charConvJAEUCObj.m_1ByteOraCharReplacement;
            }
            this.setUcsChar(charSetParser, characterConverters);
            this.setExtraUnicodeMapping(charSetParser, characterConverters);
            if (this.charConvJAEUCObj != null) {
                ConverterArchive converterArchive = new ConverterArchive();
                try {
                    if (bl) {
                        converterArchive.insertObjtoFile(string, string6 + ".glb", this.charConvJAEUCObj);
                    } else {
                        converterArchive.insertSingleObj(string2, this.charConvJAEUCObj, "/oracle/i18n/data/" + string6 + ".glb");
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    return;
                }
            }
            return;
        }
        catch (NLTParserException nLTParserException) {
            System.out.println(nLTParserException.getMessage());
            return;
        }
    }

    private void setExtraUnicodeMapping(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        Vector vector;
        Vector vector2 = new Vector();
        if (characterConverters != null) {
            characterConverters.extractExtraMappings(vector2);
        }
        if (this.charConvJAEUCObj.extraUnicodeToOracleMapping != null) {
            this.charConvJAEUCObj.extractExtraMappings(vector2);
        }
        if ((vector = charSetParser.getReplacementChars()) != null) {
            int n = vector.size();
            try {
                int n2 = 0;
                while (n2 < n) {
                    Object[] objectArray = (Object[])vector.elementAt(n2);
                    int n3 = ((int[])objectArray[0])[0];
                    int n4 = ((int[])objectArray[1])[0];
                    this.setExtraUnicodeMappingPair(n3, n4, vector2);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new NLTParserException("bad number");
            }
        }
        this.finishExtraUnicodeMapping(vector2);
    }

    private void setExtraUnicodeMappingPair(int n, int n2, Vector vector) throws IOException {
        int[] nArray = new int[]{n = (int)CharConvBuilder.convertUTF32toUTF16((long)n & 0xFFFFFFFFL), n2};
        vector.addElement(nArray);
    }

    private void finishExtraUnicodeMapping(Vector vector) {
        int n = 0;
        int[] nArray = null;
        int n2 = vector.size();
        this.charConvJAEUCObj.extraUnicodeToOracleMapping = new int[n2][2];
        n = 0;
        while (n < vector.size()) {
            nArray = (int[])vector.elementAt(n);
            this.charConvJAEUCObj.extraUnicodeToOracleMapping[n][0] = nArray[0];
            this.charConvJAEUCObj.extraUnicodeToOracleMapping[n][1] = nArray[1];
            ++n;
        }
    }

    private void setUcsChar(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        try {
            int n;
            Vector vector;
            this.m_l1BlockSize = 256;
            this.m_leadingCode = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
            Vector[] vectorArray = new Vector[this.m_leadingCode.length];
            this.m_lcCount = 0;
            if (characterConverters != null) {
                vector = new Vector(65535, 28671);
                characterConverters.extractCodepoints(vector);
                n = 0;
                while (n < vector.size()) {
                    int[] nArray = (int[])vector.elementAt(n);
                    this.setUcsCharPair(nArray[0], nArray[1], vectorArray);
                    ++n;
                }
            }
            vector = charSetParser.getCharacterData();
            int n2 = vector.size();
            n = 0;
            while (n < n2) {
                Object[] objectArray = (Object[])vector.elementAt(n);
                int n3 = ((int[])objectArray[0])[0];
                int n4 = ((int[])objectArray[1])[0];
                this.setUcsCharPair(n3, n4, vectorArray);
                ++n;
            }
            this.finishUcsChar(vectorArray);
        }
        catch (IOException iOException) {
            throw new NLTParserException("bad number");
        }
    }

    void setArray2(int[] nArray) {
        int n = nArray.length;
        this.charConvJAEUCObj.m_ucsCharLevel2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.charConvJAEUCObj.m_ucsCharLevel2[n2] = nArray[n2];
            ++n2;
        }
    }

    private void setUcsCharPair(int n, int n2, Vector[] vectorArray) throws IOException {
        Vector<int[]> vector;
        if ((n2 = (int)CharConvBuilder.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL)) == 65533) {
            return;
        }
        int n3 = n >> 16 & 0xFFFF;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.m_lcCount) {
            if (n3 == this.m_leadingCode[n5]) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        if (n4 == -1) {
            if (n5 < this.m_leadingCode.length) {
                this.m_leadingCode[n5] = (char)n3;
                n4 = n5;
                this.m_lcCount = n5 + 1;
            } else {
                System.err.println("***** Error: too many leading codes: " + Integer.toHexString(n3));
                return;
            }
        }
        if ((vector = vectorArray[n5]) == null) {
            vectorArray[n5] = vector = new Vector<int[]>();
        }
        int[] nArray = new int[]{n, n2};
        vector.addElement(nArray);
    }

    private void finishUcsChar(Vector[] vectorArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        Vector vector;
        int n7;
        int n8 = 8;
        int n9 = 8;
        int n10 = (1 << n8) - 1;
        int n11 = (1 << n9) - 1;
        int n12 = this.m_l1BlockSize * this.m_lcCount;
        char[] cArray = new char[n12];
        char[][] cArray2 = new char[n12][2];
        int n13 = 0;
        while (n13 < n12) {
            cArray[n13] = 65535;
            cArray2[n13][0] = (char)n11;
            cArray2[n13][1] = '\u0000';
            ++n13;
        }
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        int n14 = 0;
        while (n14 < this.m_lcCount) {
            n7 = this.m_l1BlockSize * n14;
            vector = vectorArray[n14];
            n6 = vector.size();
            n13 = 0;
            while (n13 < n6) {
                nArray = (int[])vector.elementAt(n13);
                n5 = nArray[1];
                if (n5 != -1) {
                    n4 = nArray[0];
                    if (hashtable.get(new Integer(n5)) == null) {
                        hashtable.put(new Integer(n5), new Integer(n4));
                    } else {
                        hashtable2.put(new Integer(n5), hashtable.get(new Integer(n5)));
                    }
                    n3 = (n4 >> n9 & n10) + n7;
                    cArray[n3] = '\u0001';
                    n2 = n4 & n11;
                    if (n2 < cArray2[n3][0]) {
                        cArray2[n3][0] = (char)n2;
                    }
                    if (n2 > cArray2[n3][1]) {
                        cArray2[n3][1] = (char)n2;
                    }
                }
                ++n13;
            }
            ++n14;
        }
        int n15 = n = n11 + 1;
        int n16 = 0;
        n13 = 0;
        while (n13 < n12) {
            if (cArray[n13] != '\uffff') {
                int n17 = cArray2[n13][0];
                cArray[n13] = (char)(n15 - (n16 < n17 ? n16 : n17));
                n15 = cArray[n13] + n;
                n16 = n - cArray2[n13][1] - 1;
            }
            ++n13;
        }
        int[] nArray2 = new int[n15];
        n13 = 0;
        while (n13 < n15) {
            nArray2[n13] = -1;
            ++n13;
        }
        n14 = 0;
        while (n14 < this.m_lcCount) {
            n7 = this.m_l1BlockSize * n14;
            vector = vectorArray[n14];
            n6 = vector.size();
            n13 = 0;
            while (n13 < n6) {
                nArray = (int[])vector.elementAt(n13);
                n5 = nArray[1];
                if (n5 != -1) {
                    n4 = nArray[0];
                    n3 = (n4 >> n9 & n10) + n7;
                    n2 = n4 & n11;
                    int n18 = cArray[n3] + n2;
                    nArray2[n18] = n5;
                }
                ++n13;
            }
            ++n14;
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setLCTable();
        this.setDuplicateMapping(hashtable2);
    }

    void setArray(char[] cArray) {
        int n = cArray.length;
        this.charConvJAEUCObj.m_ucsCharLevel1 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            this.charConvJAEUCObj.m_ucsCharLevel1[n2] = cArray[n2];
            ++n2;
        }
    }

    void setLCTable() {
        this.charConvJAEUCObj.m_ucsCharLeadingCode = new char[this.m_lcCount][2];
        int n = 0;
        while (n < this.m_lcCount) {
            this.charConvJAEUCObj.m_ucsCharLeadingCode[n][0] = this.m_leadingCode[n];
            this.charConvJAEUCObj.m_ucsCharLeadingCode[n][1] = (char)(n * this.m_l1BlockSize);
            ++n;
        }
    }

    void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.charConvJAEUCObj.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.charConvJAEUCObj.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.charConvJAEUCObj.extraUnicodeToOracleMapping[n++][1] = (Integer)hashtable.get(k);
        }
    }
}

