/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.HashMap;
import java.util.Vector;
import oracle.i18n.util.builder.NLTParser;
import oracle.i18n.util.builder.NLTParserException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinguisticParser
extends NLTParser {
    public LinguisticParser(String string) throws NLTParserException {
        super(string);
        this.topNode = NLTParser.findNode(this.topNode, "LINGUISTIC_DEFINITION");
        if (this.topNode == null) {
            throw new NLTParserException("Pattern LINGUISTIC_DEFINITION not found!");
        }
    }

    public Vector getMajorSort() throws NLTParserException {
        return this.getPBlockVector("major_sort");
    }

    public HashMap getMinorSort() throws NLTParserException {
        return this.getPHashMap("minor_sort");
    }

    public Vector getBaseLetter() throws NLTParserException {
        Vector vector = this.getPBlockVector("base_letter");
        NodeList nodeList = NLTParser.findNodes(this.topNode, "special_base_letter");
        if (nodeList == null) {
            return vector;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            int n3 = nodeList2.getLength();
            int[][] nArrayArray = new int[2][];
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeList2.item(n4);
                String string = node.getNodeName();
                if (string.equals("char")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <char>");
                } else if (string.equals("base1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <major1>");
                } else if (string.equals("base2")) {
                    nArrayArray[1][1] = this.getValueOfHex(node, "Element <major2>");
                }
                ++n4;
            }
            vector.addElement(nArrayArray);
            ++n2;
        }
        return vector;
    }

    public Vector getSpecialLetter() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = NLTParser.findNodes(this.topNode, "special_letter");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            int n3 = nodeList2.getLength();
            int[][] nArrayArray = new int[3][];
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeList2.item(n4);
                String string = node.getNodeName();
                if (string.equals("char")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <char>");
                } else if (string.equals("major1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <major1>");
                } else if (string.equals("major2")) {
                    nArrayArray[1][1] = this.getValueOfHex(node, "Element <major2>");
                } else if (string.equals("minor1")) {
                    nArrayArray[2] = new int[2];
                    nArrayArray[2][0] = this.getValueOfHex(node, "Element <minor1>");
                } else if (string.equals("minor2")) {
                    nArrayArray[2][1] = this.getValueOfHex(node, "Element <minor2>");
                }
                ++n4;
            }
            vector.addElement(nArrayArray);
            ++n2;
        }
        return vector;
    }

    public Vector getCombinationLetter() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = NLTParser.findNodes(this.topNode, "combination_letter");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            int n3 = nodeList2.getLength();
            int[][] nArrayArray = new int[3][];
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeList2.item(n4);
                String string = node.getNodeName();
                if (string.equals("char1")) {
                    nArrayArray[0] = new int[2];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <char1>");
                } else if (string.equals("char2")) {
                    nArrayArray[0][1] = this.getValueOfHex(node, "Element <char2>");
                } else if (string.equals("major")) {
                    nArrayArray[1] = new int[1];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <major>");
                } else if (string.equals("minor")) {
                    nArrayArray[2] = new int[1];
                    nArrayArray[2][0] = this.getValueOfHex(node, "Element <minor>");
                }
                ++n4;
            }
            vector.addElement(nArrayArray);
            ++n2;
        }
        return vector;
    }

    public Vector getSpecialUppercase() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = NLTParser.findNodes(this.topNode, "special_uppercase");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            int n3 = nodeList2.getLength();
            int[][] nArrayArray = new int[2][];
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeList2.item(n4);
                String string = node.getNodeName();
                if (string.equals("lower")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <lower>");
                } else if (string.equals("lower1")) {
                    nArrayArray[0] = new int[2];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <lower1>");
                } else if (string.equals("lower2")) {
                    nArrayArray[0][1] = this.getValueOfHex(node, "Element <lower2>");
                } else if (string.equals("upper")) {
                    nArrayArray[1] = new int[1];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <upper>");
                } else if (string.equals("upper1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <upper1>");
                } else if (string.equals("upper2")) {
                    nArrayArray[1][1] = this.getValueOfHex(node, "Element <upper2>");
                } else if (string.equals("upper3")) {
                    int[] nArray = new int[]{nArrayArray[1][0], nArrayArray[1][1], this.getValueOfHex(node, "Element <upper3>")};
                    nArrayArray[1] = nArray;
                }
                ++n4;
            }
            vector.addElement(nArrayArray);
            ++n2;
        }
        return vector;
    }

    public Vector getSpecialLowercase() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = NLTParser.findNodes(this.topNode, "special_lowercase");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            int n3 = nodeList2.getLength();
            int[][] nArrayArray = new int[2][];
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeList2.item(n4);
                String string = node.getNodeName();
                if (string.equals("upper")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <upper>");
                } else if (string.equals("upper1")) {
                    nArrayArray[0] = new int[2];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <upper1>");
                } else if (string.equals("upper2")) {
                    nArrayArray[0][1] = this.getValueOfHex(node, "Element <upper2>");
                } else if (string.equals("lower")) {
                    nArrayArray[1] = new int[1];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <lower>");
                } else if (string.equals("lower1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <lower1>");
                } else if (string.equals("lower2")) {
                    nArrayArray[1][1] = this.getValueOfHex(node, "Element <lower2>");
                }
                ++n4;
            }
            vector.addElement(nArrayArray);
            ++n2;
        }
        return vector;
    }

    public Vector getSpecialBaseLetter() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = NLTParser.findNodes(this.topNode, "special_base_letter");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            int n3 = nodeList2.getLength();
            int[][] nArrayArray = new int[2][];
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeList2.item(n4);
                String string = node.getNodeName();
                if (string.equals("char")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <char>");
                } else if (string.equals("base1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <base1>");
                } else if (string.equals("base2")) {
                    nArrayArray[1][1] = this.getValueOfHex(node, "Element <base2>");
                }
                ++n4;
            }
            vector.addElement(nArrayArray);
            ++n2;
        }
        return vector;
    }

    public String getVersion() {
        return this.getStringValue("VERSION");
    }

    public String getName() {
        return this.getStringValue("Name");
    }

    public String getId() {
        return this.getStringValue("Id");
    }

    public String getSortName() {
        return this.getStringValue("SORT_NAME");
    }

    public String getSortId() {
        return this.getStringValue("SORT_ID");
    }

    public String getBaseSortId() {
        return this.getStringValue("BASE_SORT_ID");
    }

    public String getBaseSortName() {
        return this.getStringValue("BASE_SORT_NAME");
    }

    public String getCollationFunctionID() {
        return this.getStringValue("collation_function_id");
    }

    public String getComparisonFunctionID() {
        return this.getStringValue("comparison_function_id");
    }

    public String getCanonicalEquivalence() {
        return this.getStringValue("Canonical_equivalence");
    }

    public String getReverseSecondary() {
        return this.getStringValue("Reverse_secondary");
    }

    public String getSwapWithNext() {
        return this.getStringValue("Swap_with_next");
    }

    public String LinInternalFlag() {
        return this.getStringValue("Lin_internal_flag");
    }

    public String getHangulJamoComp() {
        return this.getStringValue("Hangul_Jamo_Composition");
    }

    public Vector getCollationRules(byte by) throws NLTParserException {
        Node node = NLTParser.findNode(this.topNode, "COLLATION_RULES");
        if (node == null) {
            return null;
        }
        Vector vector = new Vector();
        int[] nArray = new int[]{0};
        switch (by) {
            case 1: {
                node = NLTParser.findNode(node, "Ign_Sec");
                break;
            }
            case 2: {
                node = NLTParser.findNode(node, "Ign_Ter");
                break;
            }
            case 3: {
                node = NLTParser.findNode(node, "Non_Ign");
                break;
            }
            default: {
                return null;
            }
        }
        this.getColRulesNonRecur(node, vector);
        return vector;
    }

    public void getColRulesNonRecur(Node node, Vector vector) throws NLTParserException {
        if (node == null) {
            return;
        }
        Node node2 = node.getFirstChild();
        int[] nArray = new int[]{0};
        while (node2 != null) {
            int[] nArray2;
            String string = node2.getNodeName();
            if (string.equals("Prim")) {
                nArray[0] = nArray[0] | 1;
            } else if (string.equals("Sec")) {
                nArray[0] = nArray[0] | 2;
            } else if (string.equals("Ter")) {
                nArray[0] = nArray[0] | 4;
            } else if (string.equals("CP")) {
                if (nArray[0] != 0) {
                    nArray2 = new int[]{nArray[0], this.getValueOfHex(node2, "ELEMENT CP")};
                    vector.addElement(nArray2);
                    nArray[0] = 0;
                } else {
                    nArray2 = (int[])vector.lastElement();
                    int[] nArray3 = new int[nArray2.length + 1];
                    int n = 0;
                    while (n < nArray2.length) {
                        nArray3[n] = nArray2[n];
                        ++n;
                    }
                    nArray3[nArray2.length] = this.getValueOfHex(node2, "ELEMENT CP");
                    vector.setElementAt(nArray3, vector.size() - 1);
                }
            } else if (string.equals("EQ")) {
                nArray[0] = nArray[0] | 0x10;
            } else if (string.equals("Gap")) {
                nArray[0] = nArray[0] | 8;
                nArray2 = new int[]{nArray[0], this.getValueOfHex(node2, "ELEMENT Gap")};
                vector.addElement(nArray2);
                nArray[0] = 0;
            }
            node2 = this.getNextNode(node2, node);
        }
    }

    private Node getNextNode(Node node, Node node2) {
        if (node.hasChildNodes()) {
            node = node.getFirstChild();
        } else {
            Node node3 = null;
            while ((node3 = node.getNextSibling()) == null) {
                if ((node = node.getParentNode()) != node2 && node != null) continue;
                return null;
            }
            node = node3;
        }
        return node;
    }

    public Vector getExpandingRules() throws NLTParserException {
        return this.getPBlockVector("EXPANDING_RULES");
    }

    public Vector getContextSensitiveRules() throws NLTParserException {
        Node node = NLTParser.findNode(this.topNode, "CONTEXT_SENSITIVE_RULES");
        if (node == null) {
            return null;
        }
        Vector vector = new Vector();
        int[] nArray = new int[]{0};
        this.getColRulesNonRecur(node, vector);
        return vector;
    }

    public static void printColVector(Vector vector) {
        if (vector == null) {
            System.out.println("Null Vector!");
            return;
        }
        vector.trimToSize();
        int n = vector.size();
        if (n == 0) {
            System.out.println("Empty Vector!");
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = (int[])vector.elementAt(n2);
            if ((nArray[0] & 1) != 0) {
                System.out.print("PrimStart ");
            }
            if ((nArray[0] & 2) != 0) {
                System.out.print("SecStart  ");
            }
            if ((nArray[0] & 4) != 0) {
                System.out.print("TerStart  ");
            }
            if ((nArray[0] & 0x10) != 0) {
                System.out.print("Equal     ");
            }
            if ((nArray[0] & 8) != 0) {
                System.out.print("Gap       ");
            }
            int n3 = 1;
            while (n3 < nArray.length) {
                System.out.print(nArray[n3] + "  ");
                ++n3;
            }
            System.out.println();
            ++n2;
        }
    }
}

