/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.builder.MapTableParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.OraMapTableSetter;
import oracle.i18n.util.builder.UnicodeMapChar;

public class MapTableBuilder {
    private static final boolean DEBUG = false;
    private static final String LANGPREFIX = "lx4";
    private static final String CONVERTERDIR = "/oracle/i18n/data/";
    private static final String HEXPREFIX = "0000";

    public static void buildGLB(String string, String string2, String string3, boolean bl) throws IOException {
        OraMapTableSetter oraMapTableSetter = new OraMapTableSetter();
        try {
            MapTableParser mapTableParser = new MapTableParser(string3);
            oraMapTableSetter.setVERSION(mapTableParser.getVERSION());
            oraMapTableSetter.setName(mapTableParser.getName());
            oraMapTableSetter.setId(mapTableParser.getId());
            HashMap hashMap = mapTableParser.getISO_A2_LANG_2_ORACLE_LANG();
            if (hashMap != null) {
                oraMapTableSetter.setAttribute("ISO_A2_LANG_2_ORACLE_LANG", hashMap);
                oraMapTableSetter.setAttribute("ORACLE_LANG_2_ISO_A2_LANG", MapTableBuilder.combRevHashMap(hashMap, mapTableParser.getORACLE_LANG_2_ISO_A2_LANG()));
            }
            if ((hashMap = mapTableParser.getISO_A2_TERR_2_ORACLE_TERR()) != null) {
                oraMapTableSetter.setAttribute("ISO_A2_TERR_2_ORACLE_TERR", hashMap);
                oraMapTableSetter.setAttribute("ORACLE_TERR_2_ISO_A2_TERR", MapTableBuilder.combRevHashMap(hashMap, mapTableParser.getORACLE_TERR_2_ISO_A2_TERR()));
            }
            oraMapTableSetter.setAttribute("ISO_LANGUAGE_DEFAULT_TERRITORY", mapTableParser.getISO_LANGUAGE_DEFAULT_TERRITORY());
            oraMapTableSetter.setAttribute("ISO_LOCALE_2_ORACLE_LOCALE", mapTableParser.getISO_LOCALE_2_ORACLE_LOCALE());
            oraMapTableSetter.setAttribute("IANA_2_ORACLE", mapTableParser.getIANA_2_ORACLE());
            oraMapTableSetter.setAttribute("ORACLE_2_IANA", mapTableParser.getORACLE_2_IANA());
            oraMapTableSetter.setAttribute("COMMON_DISPLAY_LOCALES", mapTableParser.getCOMMON_DISPLAY_LOCALES());
            oraMapTableSetter.setAttribute("COMMON_LOCALES", mapTableParser.getCOMMON_LOCALES());
            oraMapTableSetter.setAttribute("SUPERSET", mapTableParser.getSUPERSET());
            oraMapTableSetter.setAttribute("EMAIL_CHARSET_2_CHARSET", mapTableParser.getEMAIL_CHARSET_2_CHARSET());
            oraMapTableSetter.setAttribute("EMAIL_CHARSET_2_CHARSET_WIN", mapTableParser.getEMAIL_CHARSET_2_CHARSET_WIN());
            oraMapTableSetter.setAttribute("EMAIL_LANG_2_CHARSET", mapTableParser.getEMAIL_LANG_2_CHARSET());
            oraMapTableSetter.setAttribute("EMAIL_LANG_2_CHARSET_WIN", mapTableParser.getEMAIL_LANG_2_CHARSET_WIN());
            oraMapTableSetter.setAttribute("COMMON_TIMEZONES", mapTableParser.getCOMMON_TIMEZONES());
            oraMapTableSetter.setAttribute("NLS_LOCALE_2_JAVA_LOCALE", mapTableParser.getNLS_LOCALE_2_JAVA_LOCALE());
            oraMapTableSetter.setAttribute("NLS_CHARSET_2_JAVA_CHARSET", mapTableParser.getNLS_CHARSET_2_JAVA_CHARSET());
            oraMapTableSetter.setAttribute("JAVA_CHARSET_2_NLS_CHARSET", mapTableParser.getJAVA_CHARSET_2_NLS_CHARSET());
            oraMapTableSetter.setAttribute("JAVA_LOCALE_2_NLS_LOCALE", mapTableParser.getJAVA_LOCALE_2_NLS_LOCALE());
            oraMapTableSetter.setAttribute("JAVA_LOCALE_2_NLS_LANG", mapTableParser.getJAVA_LOCALE_2_NLS_LANG());
            oraMapTableSetter.setAttribute("JAVA_CHARSET_2_IANA_CHARSET", mapTableParser.getJAVA_2_IANA());
            oraMapTableSetter.setAttribute("IANA_CHARSET_2_JAVA_CHARSET", mapTableParser.getIANA_2_JAVA());
            oraMapTableSetter.setAttribute("NLS_LANG_2_NLS_CHARSET", mapTableParser.getNLS_LANG_2_NLS_CHARSET());
            oraMapTableSetter.setAttribute("NLS_LANG_2_NLS_TERRITORY", mapTableParser.getNLS_LANG_2_NLS_TERRITORY());
            oraMapTableSetter.setAttribute("LANG_DIRECTION", mapTableParser.getLANG_DIRECTION());
            oraMapTableSetter.setAttribute("CHAR_ENTITY_REFERENCE", mapTableParser.getCHAR_ENTITY_REFERENCE());
            oraMapTableSetter.setAttribute("ISO4217_2_CURRENCY", mapTableParser.getISO4217_2_CURRENCY());
            oraMapTableSetter.setAttribute("BINARY_BASE_LETTER", new UnicodeMapChar(mapTableParser.getBINARY_BASE_LETTER()));
            oraMapTableSetter.setAttribute("CASE_FOLD_TAB", new UnicodeMapChar(mapTableParser.getCASE_FOLD_TAB()));
            oraMapTableSetter.setAttribute("CONTAINS_CHARSET", mapTableParser.getCONTAINS_CHARSET());
            if (oraMapTableSetter != null) {
                ConverterArchive converterArchive = new ConverterArchive();
                if (bl) {
                    converterArchive.insertObjtoFile(string, MapTableBuilder.formatFileName(oraMapTableSetter.getId()) + ".glb", oraMapTableSetter);
                } else {
                    converterArchive.insertSingleObj(string2, oraMapTableSetter, CONVERTERDIR + MapTableBuilder.formatFileName(oraMapTableSetter.getId()) + ".glb");
                }
            }
        }
        catch (NLTParserException nLTParserException) {
            System.err.println(nLTParserException.getMessage());
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return;
        }
    }

    private static HashMap combRevHashMap(HashMap hashMap, HashMap hashMap2) {
        HashMap hashMap3 = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = hashMap.get(k);
            if (v == null) continue;
            hashMap3.put(v, k);
        }
        hashMap3.putAll(hashMap2);
        return hashMap3;
    }

    private static String formatFileName(String string) {
        String string2 = Integer.toHexString(Integer.parseInt(string));
        String string3 = HEXPREFIX.substring(0, HEXPREFIX.length() - string2.length()) + string2;
        return LANGPREFIX + string3;
    }
}

