/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.cache;

import com.posdata.glue.PosException;
import com.posdata.glue.cache.PosCacheHolder;
import com.posdata.glue.cache.PosCacheLoader;
import com.posdata.glue.cache.PosCacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;

public class PosCacheManagerJCS
implements PosCacheManager {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected static final String DEFAULT_REGION = "_default-region";
    protected PosCacheHolder cacheHolder = PosCacheHolder.getInstance();

    private JCS getCacheRegion(String string) {
        JCS jCS = (JCS)this.cacheHolder.getCache(string);
        if (jCS == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cache does not exist for region [" + string + "]. Create new cache object"));
            }
            try {
                jCS = JCS.getInstance((String)string);
            }
            catch (CacheException cacheException) {
                throw new PosException(cacheException.getMessage(), cacheException);
            }
            this.cacheHolder.putCache(string, jCS);
        }
        return jCS;
    }

    public Object getCacheObject(Object object) {
        return this.getCacheObject(object, DEFAULT_REGION, null);
    }

    public Object getCacheObject(Object object, String string) {
        return this.getCacheObject(object, string, null);
    }

    public Object getCacheObject(Object object, String string, PosCacheLoader posCacheLoader) {
        JCS jCS = this.getCacheRegion(string);
        Object object2 = jCS.get(object);
        if (object2 == null && posCacheLoader != null && (object2 = posCacheLoader.loadCacheObject(object, string)) != null) {
            try {
                jCS.put(object, object2);
            }
            catch (CacheException cacheException) {
                throw new PosException(cacheException.getMessage(), cacheException);
            }
        }
        return object2;
    }

    public void putCacheObject(Object object, Object object2) {
        this.putCacheObject(object, object2, DEFAULT_REGION);
    }

    public void putCacheObject(Object object, Object object2, String string) {
        JCS jCS = this.getCacheRegion(string);
        try {
            jCS.put(object, object2);
        }
        catch (CacheException cacheException) {
            throw new PosException(cacheException.getMessage(), cacheException);
        }
    }

    public boolean isPresent(Object object) {
        return this.isPresent(object, DEFAULT_REGION);
    }

    public boolean isPresent(Object object, String string) {
        return this.getCacheRegion(string).get(object) != null;
    }

    public void removeCacheObject(Object object) {
        this.removeCacheObject(object, DEFAULT_REGION);
    }

    public void removeCacheObject(Object object, String string) {
        try {
            this.getCacheRegion(string).remove(object);
        }
        catch (CacheException cacheException) {
            throw new PosException(cacheException.getMessage(), cacheException);
        }
    }

    public void clear() {
        this.clear(DEFAULT_REGION);
    }

    public void clear(String string) {
        try {
            this.getCacheRegion(string).clear();
        }
        catch (CacheException cacheException) {
            throw new PosException(cacheException.getMessage(), cacheException);
        }
    }
}

