/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.cache.remote;

import com.posdata.glue.PosException;
import com.posdata.glue.cache.remote.PosCacheEvent;
import com.posdata.glue.cache.remote.PosCacheEventSender;
import com.posdata.glue.cache.remote.PosRemoteCacheException;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.beans.factory.InitializingBean;

public class PosHttpCacheEventSender
implements PosCacheEventSender,
InitializingBean {
    protected PosLog log = PosLogFactory.getLogger(this.getClass());
    private HttpClient a;
    private List b;
    private int c = 0;
    private long d = 15000L;
    private String e;
    private int f = 0;
    private static final String g = "\\|";

    public List getTargetUrl() {
        return this.b;
    }

    public void setTargetUrl(List list) {
        this.b = list;
    }

    public long getTimeout() {
        return this.d;
    }

    public void setTimeout(long l) {
        this.d = l;
    }

    public int getRequestRetryCount() {
        return this.f;
    }

    public void setRequestRetryCount(int n) {
        this.f = n;
    }

    public String sendEvent(PosCacheEvent posCacheEvent) {
        String[] stringArray = new String[this.c];
        posCacheEvent.setRequestor(this.e);
        int n = 0;
        while (n < this.c) {
            stringArray[n] = this.sendEventInternal(posCacheEvent, (String)this.b.get(n));
            ++n;
        }
        return this.concatResultCodes(stringArray);
    }

    protected String sendEventInternal(PosCacheEvent posCacheEvent, String string) {
        PostMethod postMethod = this.createPostMethod(posCacheEvent, string);
        postMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.f, false));
        postMethod.getParams().setParameter("http.socket.timeout", (Object)new Integer((int)this.d));
        String string2 = null;
        try {
            try {
                int n = this.a.executeMethod((HttpMethod)postMethod);
                string2 = new String(postMethod.getResponseBody());
                if (n == 800) {
                    throw new PosRemoteCacheException("Cannot remove remote cached object : target[" + string + "], event info[" + posCacheEvent.toString() + "], remote error message[" + string2 + "]");
                }
                this.log.logInfo("response:" + string2);
                this.log.logInfo("status line:" + postMethod.getStatusLine());
            }
            catch (HttpException httpException) {
                throw new PosException("Fatal protocol violation: " + httpException.getMessage(), httpException);
            }
            catch (IOException iOException) {
                throw new PosException("Fatal transport error: " + iOException.getMessage(), iOException);
            }
            catch (PosRemoteCacheException posRemoteCacheException) {
                throw posRemoteCacheException;
            }
        }
        finally {
            postMethod.releaseConnection();
        }
        return string2;
    }

    protected PostMethod createPostMethod(PosCacheEvent posCacheEvent, String string) {
        PostMethod postMethod = new PostMethod(string);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>(5);
        arrayList.add(new NameValuePair("__cache_key__", posCacheEvent.getCacheKey()));
        arrayList.add(new NameValuePair("__region_name__", posCacheEvent.getRegionName()));
        arrayList.add(new NameValuePair("__requestor__", posCacheEvent.getRequestor()));
        if (this.log.isDebugEnabled()) {
            this.log.logDebug("Cache Event Parameters :" + arrayList);
        }
        NameValuePair[] nameValuePairArray = new NameValuePair[arrayList.size()];
        postMethod.setRequestBody(arrayList.toArray(nameValuePairArray));
        return postMethod;
    }

    private String concatResultCodes(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(this.b.get(n)).append("=").append(stringArray[n]).append(", ");
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.b == null || this.b.size() == 0) {
            throw new PosException("Plz specify targetUrl in applicationContext.xml");
        }
        this.c = this.b.size();
        this.logTargetUrl();
        this.initializeLocalAddress();
        this.a = new HttpClient();
    }

    private void initializeLocalAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        this.e = inetAddress.getHostAddress();
        this.log.logInfo("Local host address :" + this.e);
    }

    private void logTargetUrl() {
        int n = this.b.size();
        int n2 = 0;
        while (n2 < n) {
            this.log.logInfo("Remote target URLs [" + this.b.get(n2) + "]");
            ++n2;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

