/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.component.layout;

import com.posdata.glue.cache.PosCacheManager;
import com.posdata.glue.component.PosMessageDefinitionException;
import com.posdata.glue.component.PosMessageParserException;
import com.posdata.glue.component.layout.PosMessageLayoutIF;
import com.posdata.glue.context.PosContext;
import com.posdata.glue.msg.PosMessage;
import com.posdata.glue.msg.PosMessageAttributeDefinition;
import com.posdata.glue.msg.PosMessageDefinition;
import com.posdata.glue.msg.util.PosMessageUtil;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import com.posdata.glue.util.xml.PosXMLUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PosXmlMessageLayout
implements PosMessageLayoutIF {
    private PosCacheManager b;
    private PosLog c;
    private String d;
    static Class a;

    public PosXmlMessageLayout() {
        Class<?> clazz = a;
        if (clazz == null) {
            try {
                clazz = a = Class.forName("com.posdata.glue.component.layout.PosXmlMessageLayout");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.c = PosLogFactory.getLogger(clazz);
        this.setMsgParsingType(PosContext.getGlueProperty("msg.parsing.type"));
        this.c.logInfo("Message Parsing Type : " + this.d);
        this.getCahceManager();
    }

    public void setMsgParsingType(String string) {
        this.d = "string".equalsIgnoreCase(string) ? "string" : "byte";
    }

    public String getMsgParsingType() {
        if (this.d == null) {
            this.d = "byte";
        }
        return this.d;
    }

    public String makeMessageString(PosMessageDefinition posMessageDefinition, PosMessage posMessage) {
        String string = "";
        int n = 0;
        while (n < posMessageDefinition.getLength()) {
            PosMessageAttributeDefinition posMessageAttributeDefinition = posMessageDefinition.getAttribute(n);
            String string2 = posMessageAttributeDefinition.getType();
            if ("G".equals(string2)) {
                ArrayList arrayList = posMessageDefinition.getGroupAttrs(n);
                string = String.valueOf(string) + this.makeGroupString(arrayList, posMessageAttributeDefinition.getLength(), posMessage);
            } else if ("E".equals(string2)) {
                string = String.valueOf(string) + this.createString(posMessageAttributeDefinition, posMessage, 0);
            }
            ++n;
        }
        return string;
    }

    private String makeGroupString(ArrayList arrayList, int n, PosMessage posMessage) {
        String string = "";
        PosMessageAttributeDefinition posMessageAttributeDefinition = null;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < arrayList.size()) {
                posMessageAttributeDefinition = (PosMessageAttributeDefinition)arrayList.get(n3);
                string = String.valueOf(string) + this.createString(posMessageAttributeDefinition, posMessage, n2);
                ++n3;
            }
            ++n2;
        }
        return string;
    }

    private String createString(PosMessageAttributeDefinition posMessageAttributeDefinition, PosMessage posMessage, int n) {
        String string = "";
        String string2 = posMessageAttributeDefinition.getDatatype();
        if ("STRING".equals(string2) || "VARCHAR2".equals(string2) || "CHAR".equals(string2)) {
            if ("byte".equals(this.getMsgParsingType())) {
                string = PosMessageUtil.getByteMsgString(posMessageAttributeDefinition, posMessage, n);
            } else if ("string".equals(this.getMsgParsingType())) {
                string = PosMessageUtil.getMsgString(posMessageAttributeDefinition, posMessage, n);
            }
        } else if ("NUMBER".equals(string2)) {
            string = PosMessageUtil.getMsgNumber(posMessageAttributeDefinition, posMessage, n);
        } else if ("DATE".equals(string2)) {
            string = PosMessageUtil.getMsgDate(posMessageAttributeDefinition, posMessage, n);
        } else {
            this.c.logError("Not support Message Type : Attribute ID-" + posMessageAttributeDefinition.getId() + " DataType-" + posMessageAttributeDefinition.getDatatype() + " Value-" + posMessage.get(posMessageAttributeDefinition.getId()));
        }
        if (this.c.isDebugEnabled()) {
            this.c.logDebug(String.valueOf(posMessageAttributeDefinition.getId()) + "=" + string);
        }
        return string;
    }

    public PosMessageDefinition getAttributes(PosContext posContext) throws PosMessageDefinitionException {
        PosMessage posMessage = posContext.getMessage();
        String string = posMessage.getTCID();
        PosMessageDefinition posMessageDefinition = this.getCacheAttributes(string);
        if (posMessageDefinition == null) {
            ArrayList arrayList = this.getXMLAttributes(posContext);
            posMessageDefinition = new PosMessageDefinition();
            if (arrayList instanceof List) {
                posMessageDefinition.setAttributes(arrayList);
            } else if (arrayList instanceof Map) {
                ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
                arrayList2.add(0, arrayList);
                posMessageDefinition.setAttributes(arrayList2);
            }
            this.setCacheAttributes(string, posMessageDefinition);
        }
        return posMessageDefinition;
    }

    public PosMessageDefinition getAttributes(String string) throws PosMessageDefinitionException {
        PosMessageDefinition posMessageDefinition = this.getCacheAttributes(string);
        if (posMessageDefinition == null) {
            ArrayList arrayList = this.getXMLAttributes(string);
            posMessageDefinition = new PosMessageDefinition();
            if (arrayList instanceof List) {
                posMessageDefinition.setAttributes(arrayList);
            } else if (arrayList instanceof Map) {
                ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
                arrayList2.add(0, arrayList);
                posMessageDefinition.setAttributes(arrayList2);
            }
            this.setCacheAttributes(string, posMessageDefinition);
        }
        return posMessageDefinition;
    }

    private PosMessageDefinition getCacheAttributes(String string) {
        PosMessageDefinition posMessageDefinition = (PosMessageDefinition)this.b.getCacheObject(string, "_message-definition-region");
        if (posMessageDefinition == null) {
            this.c.logInfo("CacheRegion is not loading MessageDefinition");
        }
        return posMessageDefinition;
    }

    private void setCacheAttributes(String string, PosMessageDefinition posMessageDefinition) {
        if (posMessageDefinition != null) {
            this.b.putCacheObject(string, posMessageDefinition, "_message-definition-region");
        } else {
            this.c.logWarn("It will not be able to store MessageDefinition in the CacheRegion.");
        }
    }

    private void getCahceManager() {
        this.b = (PosCacheManager)PosContext.getBeanFactory().getBeanObject("cacheManager");
    }

    protected String getTransactionCodeID(String string) {
        if (string == null) {
            throw new PosMessageParserException("TC is null");
        }
        if (string.length() < 8) {
            throw new PosMessageParserException("TC is a abnormal. TC [" + string + "]");
        }
        return string.substring(0, 8);
    }

    private ArrayList getXMLAttributes(PosContext posContext) throws PosMessageDefinitionException {
        String string = posContext.getMessage().getTCID();
        String string2 = String.valueOf(string) + "-msg.xml";
        String string3 = "layout" + File.separator + string2;
        Map map = null;
        try {
            map = new PosXMLUtil().loadXMLFromClasspath(string3);
        }
        catch (Exception exception) {
            throw new PosMessageDefinitionException("Message Layout loading error!! : " + string3, exception);
        }
        Map map2 = (Map)PosMessageUtil.getSource(map, "msgs");
        Object object = PosMessageUtil.getSource(map2, "msg");
        Map map3 = null;
        if (PosMessageUtil.isList(object)) {
            int n = 0;
            while (n < ((List)object).size()) {
                map3 = (Map)PosMessageUtil.getSource(object, String.valueOf(n));
                String string4 = (String)PosMessageUtil.getSource(map3, "id");
                if (!string.equals(string4)) {
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            map3 = (Map)object;
        }
        ArrayList arrayList = (ArrayList)PosMessageUtil.getSource(map3, "attribute");
        return arrayList;
    }

    private ArrayList getXMLAttributes(String string) throws PosMessageDefinitionException {
        String string2 = String.valueOf(string) + "-msg.xml";
        String string3 = "layout" + File.separator + string2;
        Map map = null;
        try {
            map = new PosXMLUtil().loadXMLFromClasspath(string3);
        }
        catch (Exception exception) {
            throw new PosMessageDefinitionException("Message Layout loading error!! : " + string3, exception);
        }
        Map map2 = (Map)PosMessageUtil.getSource(map, "msgs");
        Object object = PosMessageUtil.getSource(map2, "msg");
        Map map3 = null;
        if (PosMessageUtil.isList(object)) {
            int n = 0;
            while (n < ((List)object).size()) {
                map3 = (Map)PosMessageUtil.getSource(object, String.valueOf(n));
                String string4 = (String)PosMessageUtil.getSource(map3, "id");
                if (!string.equals(string4)) {
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            map3 = (Map)object;
        }
        ArrayList arrayList = (ArrayList)PosMessageUtil.getSource(map3, "attribute");
        return arrayList;
    }

    public PosMessage makeMessageParsing(PosMessageDefinition posMessageDefinition, PosMessage posMessage) throws PosMessageParserException {
        try {
            String string = posMessage.getTC();
            int n = 0;
            int n2 = 0;
            PosMessageAttributeDefinition posMessageAttributeDefinition = null;
            int n3 = 0;
            while (n3 < posMessageDefinition.getLength()) {
                posMessageAttributeDefinition = posMessageDefinition.getAttribute(n3);
                String string2 = posMessageAttributeDefinition.getType();
                String string3 = posMessageAttributeDefinition.getDatatype();
                String string4 = posMessageAttributeDefinition.getId();
                int n4 = posMessageAttributeDefinition.getLength();
                int n5 = posMessageAttributeDefinition.getPrecision();
                if ("G".equals(string2)) {
                    Object object;
                    PosMessageAttributeDefinition posMessageAttributeDefinition2 = null;
                    ArrayList arrayList = posMessageDefinition.getGroupAttrs(n3);
                    int n6 = 0;
                    while (n6 < n4) {
                        int n7 = 0;
                        while (n7 < arrayList.size()) {
                            posMessageAttributeDefinition2 = (PosMessageAttributeDefinition)arrayList.get(n7);
                            object = posMessageAttributeDefinition2.getDatatype();
                            String string5 = posMessageAttributeDefinition2.getId();
                            int n8 = posMessageAttributeDefinition2.getLength();
                            int n9 = posMessageAttributeDefinition2.getPrecision();
                            String string6 = posMessageAttributeDefinition2.getType();
                            n2 += n8;
                            if ("byte".equals(this.getMsgParsingType())) {
                                this.cutParseByteData(n, n2, string6, string, string5, (String)object, n9, posMessage, n6);
                            } else if ("string".equals(this.getMsgParsingType())) {
                                this.cutParseStringData(n, n2, string6, string, string5, (String)object, n9, posMessage, n6);
                            }
                            n = n2;
                            ++n7;
                        }
                        ++n6;
                    }
                    n6 = 0;
                    while (n6 < arrayList.size()) {
                        posMessageAttributeDefinition2 = (PosMessageAttributeDefinition)arrayList.get(n6);
                        String string7 = posMessageAttributeDefinition2.getId();
                        object = new ArrayList();
                        int n10 = 0;
                        while (n10 < n4) {
                            String string8 = String.valueOf(string7) + n10;
                            ((ArrayList)object).add(n10, posMessage.get(string8));
                            ++n10;
                        }
                        posMessage.setObject(string7, object);
                        ++n6;
                    }
                } else if ("E".equals(string2)) {
                    n2 += n4;
                    if ("byte".equals(this.getMsgParsingType())) {
                        this.cutParseByteData(n, n2, string2, string, string4, string3, n5, posMessage, 0);
                    } else if ("string".equals(this.getMsgParsingType())) {
                        this.cutParseStringData(n, n2, string2, string, string4, string3, n5, posMessage, 0);
                    }
                    n = n2;
                }
                ++n3;
            }
        }
        catch (PosMessageParserException posMessageParserException) {
            throw posMessageParserException;
        }
        catch (Exception exception) {
            throw new PosMessageParserException("Message Parseing Error!! - " + exception.getMessage(), exception);
        }
        return posMessage;
    }

    private void cutParseStringData(int n, int n2, String string, String string2, String string3, String string4, int n3, PosMessage posMessage, int n4) {
        String string5 = null;
        if (string2.length() < n2) {
            throw new PosMessageParserException("Short Message Length : Message Attribute-" + string3 + ", Message Atttribute Length=" + n2 + ", Message Total Length-" + string2.length());
        }
        string5 = PosMessageUtil.rightTrim(string2.substring(n, n2));
        this.setParseData(string, string3, string4, string5, n3, posMessage, n4);
    }

    private void cutParseByteData(int n, int n2, String string, String string2, String string3, String string4, int n3, PosMessage posMessage, int n4) {
        byte[] byArray = string2.getBytes();
        int n5 = byArray.length;
        String string5 = null;
        if (n5 < n2) {
            throw new PosMessageParserException("Short Message Length : Message Attribute-" + string3 + ", Message Atttribute Length=" + n2 + ", Message Total Length-" + string2.length());
        }
        string5 = PosMessageUtil.rightTrim(PosMessageUtil.substringByte(byArray, n, n2));
        this.setParseData(string, string3, string4, string5, n3, posMessage, n4);
    }

    private void setParseData(String string, String string2, String string3, String string4, int n, PosMessage posMessage, int n2) {
        if (string.equals("GE")) {
            string2 = String.valueOf(string2) + String.valueOf(n2);
        }
        if ("STRING".equals(string3) || "VARCHAR2".equals(string3) || "CHAR".equals(string3)) {
            posMessage.setObject(string2, string4);
        } else if ("NUMBER".equals(string3)) {
            if (string4 == null || string4.equals("")) {
                posMessage.setObject(string2, null);
            } else {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string4);
                    if (n > 0) {
                        bigDecimal = bigDecimal.movePointLeft(n);
                    }
                    posMessage.setObject(string2, bigDecimal);
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = "NumberFormatException : Message Attribute-" + string2 + ", Message Data-" + string4 + ",  Data Type-" + string3;
                    this.c.logError(string5);
                    throw new PosMessageParserException(string5, numberFormatException);
                }
            }
        } else if ("DATE".equals(string3)) {
            try {
                posMessage.setObject(string2, PosMessageUtil.convertStringToDate(string4));
            }
            catch (Exception exception) {
                String string6 = "DateFormatException : Message Attribute-" + string2 + ", Message Data-" + string4 + ",  Data Type-" + string3;
                this.c.logError(string6);
                throw new PosMessageParserException(string6, exception);
            }
        }
    }
}

