/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.scheduling;

import com.posdata.glue.context.PosContext;
import com.posdata.glue.scheduling.PosJobDetail;
import com.posdata.glue.scheduling.PosJobFirer;
import com.posdata.glue.scheduling.PosJobTrigger;
import com.posdata.glue.scheduling.PosSchedulerException;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class PosJobScheduler
extends SchedulerFactoryBean {
    private static final String a = "\\|";
    public static final String DEFAULT_GROUP = "DEFAULT";
    private PosJobFirer b;
    protected PosLog log = PosLogFactory.getLogger(((Object)((Object)this)).getClass());
    private List c = new ArrayList();

    public void fireJob(String string) {
        this.b.fireJob(string);
    }

    public void fireJob(String string, String string2) {
        this.b.fireJob(string, string2);
    }

    public void fireJob(String string, String string2, String string3) {
        this.b.fireJob(string, string2, string3);
    }

    public void pauseJob(String string) {
        this.pauseJob(string, DEFAULT_GROUP);
    }

    public void pauseJob(String string, String string2) {
        try {
            this.getScheduler().pauseJob(string, string2);
            this.log.logInfo("Pause a Job [" + string + ", " + string2 + "]");
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot pause a job[job name, group name] : [" + string + ", " + string2 + "]", exception);
        }
    }

    public void pauseTrigger(String string) {
        this.pauseTrigger(string, DEFAULT_GROUP);
    }

    public void pauseTrigger(String string, String string2) {
        try {
            this.getScheduler().pauseTrigger(string, string2);
            this.log.logInfo("Pause a Trigger [" + string + "," + string2 + "]");
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot pause a trigger[trigger name, group name] : [" + string + "," + string2 + "]", exception);
        }
    }

    protected Scheduler getScheduler() {
        return (Scheduler)super.getObject();
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.b = new PosJobFirer(this);
        this.initStatefulJobGroups();
    }

    public Object getObject() {
        return this;
    }

    public List getAllJobNames() {
        return this.getAllJobNames(DEFAULT_GROUP);
    }

    public List getAllJobNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Scheduler scheduler = this.getScheduler();
            String[] stringArray = scheduler.getJobNames(string);
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Can not get job informations: " + exception.getMessage());
        }
        return arrayList;
    }

    public List getAllTriggerNames() {
        return this.getAllTriggerNames(DEFAULT_GROUP);
    }

    public List getAllTriggerNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Scheduler scheduler = this.getScheduler();
            String[] stringArray = scheduler.getTriggerNames(string);
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Can not get trigger informations: " + exception.getMessage(), exception);
        }
        return arrayList;
    }

    public void resumeJob(String string) {
        this.resumeJob(string, DEFAULT_GROUP);
    }

    public void resumeJob(String string, String string2) {
        try {
            this.getScheduler().resumeJob(string, string2);
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot resume a job [" + string + ", " + string2 + "]: " + exception.getMessage(), exception);
        }
    }

    public void resumeTrigger(String string) {
        this.resumeTrigger(string, DEFAULT_GROUP);
    }

    public void resumeTrigger(String string, String string2) {
        try {
            this.getScheduler().resumeTrigger(string, string2);
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot resume a trigger [" + string + ", " + string2 + "]: " + exception.getMessage(), exception);
        }
    }

    public boolean unscheduleJob(String string) {
        return this.unscheduleJob(string, DEFAULT_GROUP);
    }

    public boolean unscheduleJob(String string, String string2) {
        try {
            return this.getScheduler().unscheduleJob(string, string2);
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot unschedule a trigger [" + string + ", " + string2 + "]: " + exception.getMessage(), exception);
        }
    }

    public Date scheduleJob(String string, String string2) {
        try {
            PosJobTrigger posJobTrigger = (PosJobTrigger)((Object)PosContext.getBeanFactory().getBeanObject(string2));
            PosJobDetail posJobDetail = (PosJobDetail)((Object)PosContext.getBeanFactory().getBeanObject(string));
            return this.getScheduler().scheduleJob((JobDetail)posJobDetail, (Trigger)posJobTrigger);
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot schedule a trigger/job [" + string2 + "/" + string + "]: " + exception.getMessage(), exception);
        }
    }

    public Date scheduleJob(String string) {
        try {
            PosJobTrigger posJobTrigger = (PosJobTrigger)((Object)PosContext.getBeanFactory().getBeanObject(string));
            return this.getScheduler().scheduleJob((Trigger)posJobTrigger);
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot schedule a job [" + string + "]: " + exception.getMessage(), exception);
        }
    }

    public void standby() {
        try {
            this.getScheduler().standby();
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot standby scheduler: " + exception.getMessage());
        }
    }

    public void shutdown() {
        try {
            this.getScheduler().shutdown();
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot shutdown scheduler: " + exception.getMessage());
        }
    }

    public void start() {
        try {
            this.getScheduler().start();
        }
        catch (Exception exception) {
            throw new PosSchedulerException("Cannot start scheduler: " + exception.getMessage());
        }
    }

    public void fireAlreadyScheduledJob(String string) {
        this.b.fireAlreadyScheduledJob(string);
    }

    public List getStatefulJobGroups() {
        return this.c;
    }

    public void setStatefulJobGroups(List list) {
        this.c = list;
    }

    protected void initStatefulJobGroups() {
        int n = this.c.size();
        if (n < 1) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.c.get(n2);
            String[] stringArray = string.split(a);
            int n3 = 0;
            while (n3 < stringArray.length) {
                PosJobDetail posJobDetail = (PosJobDetail)((Object)PosContext.getBeanFactory().getBeanObject(stringArray[n3]));
                posJobDetail.setStatefulJobGroups(true);
                int n4 = 0;
                while (n4 < stringArray.length) {
                    posJobDetail.putStatefulJobToGroup(stringArray[n4]);
                    ++n4;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.logDebug((Object)posJobDetail);
                }
                ++n3;
            }
            ++n2;
        }
    }
}

