/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.scheduling.remote;

import com.posdata.glue.PosException;
import com.posdata.glue.scheduling.PosSchedulerException;
import com.posdata.glue.scheduling.remote.PosJobDefinition;
import com.posdata.glue.scheduling.remote.PosJobEventSender;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public class PosHttpJobEventSender
implements PosJobEventSender {
    protected static final String HTTP_PREFIX = "http://";
    protected PosLog log = PosLogFactory.getLogger(this.getClass());
    private String a;
    private String b;
    private int c;
    private String d = "euc-kr";

    public PosHttpJobEventSender() {
        Object object;
        try {
            object = InetAddress.getLocalHost();
            this.b = ((InetAddress)object).getHostAddress();
            this.log.logInfo("Local host address :" + this.b);
        }
        catch (UnknownHostException unknownHostException) {
            throw new PosException("Cannot get localhost address -" + unknownHostException.getMessage());
        }
        object = System.getProperty("glue.scheduler.server.targeturl");
        if (object == null) {
            throw new PosSchedulerException("Plz specify 'scheduler server target url' via java option: like that '-Dglue.scheduler.server.targeturl=127.0.0.1:8805/glue-scheduler'");
        }
        if (((String)object).indexOf(HTTP_PREFIX) == -1) {
            this.a = HTTP_PREFIX + (String)object;
        }
        this.log.logInfo("Scheduler Server Target URL : " + this.a);
        this.c = 2;
        this.log.logInfo("Http request retry count :" + this.c);
    }

    public String getTargetUrl() {
        return this.a;
    }

    public void setTargetUrl(String string) {
        this.a = string;
    }

    public String getAddress() {
        return this.b;
    }

    public void setAddress(String string) {
        this.b = string;
    }

    public int getRetryCount() {
        return this.c;
    }

    public void setRetryCount(int n) {
        this.c = n;
    }

    public String sendJobEvent(PosJobDefinition posJobDefinition) {
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = this.createPostMethod(posJobDefinition);
        postMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.c, false));
        String string = null;
        try {
            try {
                int n = httpClient.executeMethod((HttpMethod)postMethod);
                if (n != 700) {
                    this.log.logError("Method failed: " + postMethod.getStatusLine());
                }
                string = new String(postMethod.getResponseBody());
                this.log.logInfo("Response Body :" + string);
                this.log.logInfo("Status Line :" + postMethod.getStatusLine());
            }
            catch (HttpException httpException) {
                throw new PosException("Fatal protocol violation: " + httpException.getMessage(), httpException);
            }
            catch (IOException iOException) {
                throw new PosException("Fatal transport error: " + iOException.getMessage(), iOException);
            }
        }
        finally {
            postMethod.releaseConnection();
        }
        return string;
    }

    protected PostMethod createPostMethod(PosJobDefinition posJobDefinition) {
        NameValuePair[] nameValuePairArray;
        PostMethod postMethod = new PostMethod(this.a);
        postMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.d);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add(new NameValuePair("request_id", posJobDefinition.getRequestId()));
        arrayList.add(new NameValuePair("job_name", posJobDefinition.getJobName()));
        arrayList.add(new NameValuePair("client_ip", this.b));
        Map map = posJobDefinition.getParameters();
        if (map != null && map.size() > 0) {
            nameValuePairArray = map.keySet().iterator();
            while (nameValuePairArray.hasNext()) {
                Object e = nameValuePairArray.next();
                Object v = map.get(e);
                String string = v != null ? v.toString() : "";
                arrayList.add(new NameValuePair("jobParam-" + e, string));
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.logDebug(arrayList);
        }
        nameValuePairArray = new NameValuePair[arrayList.size()];
        nameValuePairArray = arrayList.toArray(nameValuePairArray);
        postMethod.setRequestBody(nameValuePairArray);
        return postMethod;
    }

    private NameValuePair[] encodeNameValuePairs(NameValuePair[] nameValuePairArray) {
        if (nameValuePairArray == null || nameValuePairArray.length == 0) {
            return nameValuePairArray;
        }
        int n = 0;
        while (n < nameValuePairArray.length) {
            String string = nameValuePairArray[n].getValue();
            try {
                nameValuePairArray[n].setValue(URLEncoder.encode(string, this.d));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.log.logWarn("Fail to encode value[" + string + "] - " + unsupportedEncodingException.getMessage());
            }
            ++n;
        }
        return nameValuePairArray;
    }

    public String getCharset() {
        return this.d;
    }

    public void setCharset(String string) {
        this.d = string;
    }
}

