/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.scheduling.store;

import com.posdata.glue.dao.PosGenericDao;
import com.posdata.glue.dao.vo.PosParameter;
import com.posdata.glue.scheduling.PosSchedulerException;
import com.posdata.glue.transaction.PosTransactionManager;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.util.HashMap;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.beans.factory.InitializingBean;

public class PosScheduledJobInfoLogger
implements JobListener,
InitializingBean {
    protected PosGenericDao dao;
    protected PosTransactionManager transactionManager;
    protected PosLog log = PosLogFactory.getLogger(this.getClass());
    protected static final String RESULT = "__ReSuLt__";
    protected static final String ROW_KEY = "__primary_key__";
    protected static final String RUNNIG = "RUNNIG";
    protected static final String COMPLETE = "COMPLETED";
    protected static final String ERROR = "ERROR";
    protected static final String SUCCESS = "S";
    protected static final String FAILURE = "F";
    private static final String a = "insert into GLUE_SCH_FIRED_TRIGGER_HISTORY values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    private static final String b = "select * from GLUE_SCH_FIRED_TRIGGER_HISTORY where request_id = ?";
    private static final String c = "update GLUE_SCH_FIRED_TRIGGER_HISTORY set state=?, result_flag=?, start_time=?, end_time=?, last_update_timestamp=? where request_id = ?";
    private static final String d = "SQ_GLUE_SCH_FI_TIG_HIS";

    public PosScheduledJobInfoLogger() {
        this.log.logInfo("ScheduledJob Info Logger is initialized...");
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        block5: {
            this.log.logDebug("full name:" + jobExecutionContext.getJobDetail().getFullName());
            this.log.logDebug("simple name:" + jobExecutionContext.getJobDetail().getName());
            this.log.logDebug("job description:" + jobExecutionContext.getJobDetail().getDescription());
            try {
                try {
                    this.transactionManager.startTransaction();
                    this.createJobInformationRow(jobExecutionContext);
                    this.transactionManager.commit();
                }
                catch (Throwable throwable) {
                    this.transactionManager.rollback();
                    this.log.logError("Fail to log scheduled job information - " + throwable.getMessage(), throwable);
                    this.transactionManager.clearTransactionStatus();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.transactionManager.clearTransactionStatus();
                throw throwable;
            }
            this.transactionManager.clearTransactionStatus();
        }
        this.log.logInfo("Job will be executed..:" + jobExecutionContext.getJobDetail().getFullName());
    }

    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
        this.log.logInfo("Job was vetoed..:" + jobExecutionContext.getJobDetail().getFullName());
    }

    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        try {
            try {
                this.transactionManager.startTransaction();
                this.updateScheduledJobInformation(jobExecutionContext, jobExecutionException);
                this.transactionManager.commit();
            }
            catch (Throwable throwable) {
                this.transactionManager.rollback();
                this.log.logError("Fail to log scheduled job information - " + throwable.getMessage(), throwable);
                this.transactionManager.clearTransactionStatus();
            }
        }
        finally {
            this.transactionManager.clearTransactionStatus();
        }
    }

    protected int updateScheduledJobInformation(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) throws PosSchedulerException {
        String string = (String)jobExecutionContext.get((Object)ROW_KEY);
        String string2 = jobExecutionException == null ? SUCCESS : FAILURE;
        String string3 = jobExecutionException == null ? COMPLETE : ERROR;
        int n = -1;
        PosParameter posParameter = new PosParameter();
        posParameter.setValueParamter(++n, (Object)string3);
        posParameter.setValueParamter(++n, (Object)string2);
        posParameter.setValueParamter(++n, jobExecutionContext.get((Object)"_job_start_time_"));
        posParameter.setValueParamter(++n, jobExecutionContext.get((Object)"_job_end_time_"));
        posParameter.setValueParamter(++n, (Object)new Timestamp(System.currentTimeMillis()));
        posParameter.setValueParamter(++n, (Object)string);
        int n2 = this.dao.updateByQueryStatement(c, posParameter);
        if (n2 < 1) {
            Trigger trigger = jobExecutionContext.getTrigger();
            JobDetail jobDetail = jobExecutionContext.getJobDetail();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("JobStartTime", jobExecutionContext.get((Object)"_job_start_time_"));
            hashMap.put("JobEndTime", jobExecutionContext.get((Object)"_job_end_time_"));
            hashMap.put("JobName", jobDetail.getName());
            hashMap.put("JobGroup", jobDetail.getGroup());
            hashMap.put("TriggerName", trigger.getName());
            hashMap.put("TriggerGroup", trigger.getGroup());
            hashMap.put("ResultFlag", string2);
            hashMap.put("STATE", string3);
            hashMap.put("JobDataMap", jobExecutionContext.getJobDetail().getJobDataMap().getWrappedMap());
            throw new PosSchedulerException(new StringBuffer(300).append("Cannot find created ROW, request id[").append(string).append("], JobInformation:").append(hashMap).toString());
        }
        this.log.logInfo("Request ID [" + string + "] Job was successfully saved to Glue History Table");
        return n2;
    }

    private int createJobInformationRow(JobExecutionContext jobExecutionContext) throws SchedulerException, IOException {
        PosParameter posParameter = this.createParameterForInsertFromJobContext(jobExecutionContext);
        return this.dao.insertByQueryStatement(a, posParameter);
    }

    protected PosParameter createParameterForInsertFromJobContext(JobExecutionContext jobExecutionContext) throws SchedulerException, IOException {
        String string;
        Trigger trigger = jobExecutionContext.getTrigger();
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        if (jobDataMap != null && jobDataMap.size() > 0 && (string = jobDataMap.getString("_user_id_")) != null && !"".equals(string)) {
            trigger.setName(string);
            this.log.logDebug("Requestor -> " + string);
        }
        long l = System.currentTimeMillis();
        byte[] byArray = jobDataMap.getWrappedMap().size() == 0 ? null : this.serializeJobData(jobDataMap).toByteArray();
        String string2 = this.dao.getSequence().getNextStringValue(d);
        jobExecutionContext.put((Object)ROW_KEY, (Object)string2);
        int n = -1;
        PosParameter posParameter = new PosParameter();
        posParameter.setValueParamter(++n, (Object)string2);
        posParameter.setValueParamter(++n, (Object)"E_ID");
        posParameter.setValueParamter(++n, (Object)jobExecutionContext.getScheduler().getSchedulerInstanceId());
        posParameter.setValueParamter(++n, (Object)trigger.getName());
        posParameter.setValueParamter(++n, (Object)trigger.getGroup());
        posParameter.setValueParamter(++n, (Object)jobDetail.getName());
        posParameter.setValueParamter(++n, (Object)jobDetail.getGroup());
        posParameter.setValueParamter(++n, (Object)this.getBooleanFlag(trigger.isVolatile()));
        posParameter.setValueParamter(++n, (Object)this.getBooleanFlag(jobDetail.isStateful()));
        posParameter.setValueParamter(++n, (Object)this.getBooleanFlag(jobDetail.requestsRecovery()));
        posParameter.setValueParamter(++n, (Object)RUNNIG);
        posParameter.setValueParamter(++n, null);
        posParameter.setValueParamter(++n, (Object)trigger.getNextFireTime());
        posParameter.setValueParamter(++n, (Object)new Timestamp(l));
        posParameter.setValueParamter(++n, null);
        posParameter.setValueParamter(++n, (Object)new Timestamp(l));
        posParameter.setValueParamter(++n, (Object)new Timestamp(l));
        posParameter.setValueParamter(++n, (Object)byArray);
        return posParameter;
    }

    private String getBooleanFlag(boolean bl) {
        return bl ? "Y" : "N";
    }

    public void setDao(PosGenericDao posGenericDao) {
        this.dao = posGenericDao;
    }

    public void setTransactionManager(PosTransactionManager posTransactionManager) {
        this.transactionManager = posTransactionManager;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dao == null) {
            throw new PosSchedulerException("Set property 'dao' in " + this.getName());
        }
        if (this.transactionManager == null) {
            throw new PosSchedulerException("Set property 'transactionManager' in " + this.getName());
        }
    }

    protected ByteArrayOutputStream serializeJobData(JobDataMap jobDataMap) throws IOException {
        if (jobDataMap != null) {
            jobDataMap.removeTransientData();
            return this.serializeObject(jobDataMap);
        }
        return this.serializeObject(null);
    }

    protected ByteArrayOutputStream serializeObject(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (object != null) {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        return byteArrayOutputStream;
    }
}

