/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.web.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.util.WebUtils;

public class PosContextResource
extends AbstractResource {
    private final ServletContext a;
    private final String b;

    public PosContextResource(ServletContext servletContext, String string) {
        Assert.notNull((Object)servletContext, (String)"Cannot resolve ServletContextResource without ServletContext");
        this.a = servletContext;
        Assert.notNull((Object)string, (String)"path is required");
        this.b = StringUtils.cleanPath((String)string);
    }

    public final ServletContext getServletContext() {
        return this.a;
    }

    public final String getPath() {
        return this.b;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        inputStream = this.a.getResourceAsStream(this.b);
        if (inputStream == null) {
            inputStream = new FileInputStream(new File(Thread.currentThread().getContextClassLoader().getResource(this.b).getFile()));
        }
        if (inputStream == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return inputStream;
    }

    public URL getURL() throws IOException {
        URL uRL = this.a.getResource(this.b);
        if (uRL == null) {
            throw new FileNotFoundException(String.valueOf(this.getDescription()) + " cannot be resolved to URL because it does not exist");
        }
        return uRL;
    }

    public File getFile() throws IOException {
        String string = WebUtils.getRealPath((ServletContext)this.a, (String)this.b);
        return new File(string);
    }

    public Resource createRelative(String string) throws IOException {
        String string2 = StringUtils.applyRelativePath((String)this.b, (String)string);
        return new ServletContextResource(this.a, string2);
    }

    public String getFilename() {
        return StringUtils.getFilename((String)this.b);
    }

    public String getDescription() {
        return "ServletContext resource [" + this.b + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof ServletContextResource;
    }

    public int hashCode() {
        return this.b.hashCode();
    }
}

