﻿function xforms_submit_error() {
	commMsgBox(error.description);
	event.stoppropagation();
}

function commCurDateTimeFormat() {
	var dte = new Date();

	var year = dte.getYear();
	var month = (dte.getMonth() + 1);
	var day = dte.getDate();
	var hour = dte.getHours();
	var minute = dte.getMinutes();
	var seconds = dte.getSeconds();
	dte = null;

	if(month < 10) month = "0" + month; 
	if(day < 10) day = "0" + day; 
	if (hour < 10) hour = "0" + hour;
	if (minute < 10) minute = "0" + minute;
	if (seconds < 10) seconds = "0" + seconds;

//	return year + "-" + month + "-" + day + " " +
//		hour + ":" + minute + ":" + seconds;
	return year + "" + month + "" + day + "" +
		hour + "" + minute + "" + seconds;
}

function showProgressBar() {
	var pbWidth = 200;
	var pbHeight = 100;	
	var width = window.width;
	var height = window.height;	
	var left = window.screenLeft + (width - pbWidth) / 2;
	var top = window.screenTop + (height - pbHeight) / 2;	
	body.createChild("xforms:group", "id:progressBar;left:" + left + "px; top:" + top + "px; width:" + pbWidth + "px; height:" + pbHeight + "px; popup:true; showeffect:blend 300; background-color:#dddddd; background-image:../../images/progress.gif; background-position:center; background-stretch:no-stretch;");
}

function removeProgressBar() {
	body.removeChild("progressBar");
}

function commAddRow(datagrid) {
	if( typeof datagrid == 'string' ) datagrid = document.controls(datagrid);
	datagrid.addRow();
	//datagrid.rowStyle(datagrid.rows-1,"data","background-color") = insertRowStyle;
	var row = datagrid.rows-1;
	if (arguments.length > 1) {
		var cols = arguments[1];
		if ( typeof cols == 'string' && cols != "")
			cellStyle(datagrid, row, cols);
	}
	datagrid.row = row;
	datagrid.isSelected(datagrid.rows) = true;
}	

function commDelRow(datagrid, chkRef) {
	if( typeof datagrid == 'string' ) datagrid = document.controls(datagrid);
	var length = arguments.length;
	chkRef = datagrid.colRef(chkRef);
	for (var i=datagrid.rows; i>(datagrid.fixedRows-1); i--) {
		if(datagrid.valueMatrix(i, chkRef)=='true' || datagrid.valueMatrix(i, chkRef)=='Y') {
			if( datagrid.rowStatus(i)==1 || datagrid.rowStatus(i)==3 ) {
				datagrid.deleteRow(i);	
			} else {
				datagrid.isReadOnly(i, 0, i, (datagrid.cols-1)) = true;
				datagrid.isReadOnly(i, chkRef, i, chkRef) = false;
				if (length > 2) {
					var cols = arguments[2].split(",");
					for(var j = 0; j<cols.length; j++) {
						var col = datagrid.colRef(cols[j]);
						datagrid.isReadOnly(i, col, i, col) = false;
					}
				}
				datagrid.rowStyle(i, "data", "background-color") = deleteRowStyle;
				datagrid.addStatus(i, "delete");
			}
		} else {
			datagrid.isReadOnly(i, 0, i, (datagrid.cols-1)) = false;
			if (length > 3) {
				var cols = arguments[3].split(",");
				for(var j = 0; j<cols.length; j++) {
					var col = datagrid.colRef(cols[j]);
					datagrid.isReadOnly(i, col, i, col) = true;
				}
			}
			datagrid.rowStyle(i, "data", "background-color") = initCellStyle;
			datagrid.removeStatus(i, "delete");
			if (length > 4) cellStyle(datagrid, i, arguments[4]);
		}
	}
}

function commMultiUpdate(gridID,newNodesetPath,multiFlag,bRebuild,newEleName,addonNode) {
	var oGrid = (typeof gridID == 'string')?document.controls(gridID):gridID;
	var data = oGrid.getUpdateData();
	var rowSep = (oGrid.attribute("rowsep")=='')?'|':oGrid.attribute('rowsep');
	var colSep = (oGrid.attribute("colsep")=='')?'^':oGrid.attribute('colsep');
	var up_data    = data.split(rowSep);
	var nHeaderLen = 2;
	var nodesetPath = oGrid.attribute("nodeset");
	if(up_data.length <= nHeaderLen){
	   return false;
	}
	
	var insertFlag = 0;
	var updateFlag = 0;
	var deleteFlag = 0;
		
	var arrHeader = new Array();
	var arrData   = new Array();
	var oldNodeset = model.instances(0).selectSingleNode(nodesetPath);
	var strNodesetName = nodesetPath.substring(nodesetPath.lastIndexOf("/")+1);
	model.makeNode(newNodesetPath);
        var parentNode = model.instances(0).selectSingleNode(newNodesetPath);

	for(var i=0;i<up_data.length-1;i++){
		var vRow = up_data[i].split(colSep);
			
		if(i==0) {
			arrHeader = vRow;
			continue;
		}
		var up_flag = vRow[0];
		var bInsert = (up_flag == "i" && multiFlag=="I")?true:false;
		var bUpdate = (up_flag == "u" && multiFlag=="U")?true:false;
		var bDelete = (up_flag == "d" && multiFlag=="D")?true:false;
		var bMulti  = (multiFlag=="A")?true:false;

		if(bInsert){
    		if(!bRebuild) {
				var rowNode = model.instances(0).createElement(newEleName);
				rowNode.nodeValue = up_data[i];
				parentNode.appendChild(rowNode);
			} else {			    
				arrData[insertFlag++] = vRow;
			}
		} else if(bUpdate){
			if(!bRebuild) {
				var rowNode = model.instances(0).createElement(newEleName);
				rowNode.nodeValue = up_data[i];
				parentNode.appendChild(rowNode);
			} else {   
				arrData[updateFlag++] = vRow;
			}
		}else if(bDelete){
			if(!bRebuild) {
				var rowNode = model.instances(0).createElement(newEleName);
				rowNode.nodeValue = up_data[i];
				parentNode.appendChild(rowNode);
			} else {   
				arrData[deleteFlag++] = vRow;
			}
		}else if(bMulti){
			if(!bRebuild) {
				var rowNode = model.instances(0).createElement(newEleName);
				rowNode.nodeValue = up_data[i];
				parentNode.appendChild(rowNode);
			} else { 
				arrData[(i-1)] = vRow;
			}
		}
	}

	if(arrData.length < 1 && bRebuild) return false;
    
	if(bRebuild) {
		var addonNodes, endIdx = -1, startRow = oGrid.fixedRows, startCol = oGrid.fixedCols;
		if (typeof addonNode == "string" && addonNode != "") {
			addonNodes = addonNode.split(",");
			endIdx = addonNodes.length;
//			for (var i=0; i<endIdx; i++)
//				addonNodes[i] = addonNodes[i].Trim();
		}
		for(var i=0; i<arrData.length; i++) {
			var r = arrData[i];
			var rowNode = model.instances(0).createElement(strNodesetName);
			for(var j=0; j<arrHeader.length; j++) {
				var colName;
				if(j==1) {
					for (var n=0; n<endIdx; n++) {
						colName = addonNodes[n];
						if (colName == "") continue;
						var colNode = model.instances(0).createElement(colName);
						var curFocusedIdx = Number(r[1]) - startRow + 1;
						colNode.nodeValue = model.getValue(nodesetPath + "[" + curFocusedIdx + "]/" + colName);
						rowNode.appendChild(colNode);
					}
					continue;
				}
				if(j==0) {
					colName = newEleName;
				} else {
					colName = arrHeader[j];
					// key = false
					if (oGrid.colAttribute(j-2+startCol, "key") == "false" )
						continue;
				}
				var colNode = model.instances(0).createElement(colName);

				colNode.nodeValue = r[j];
				rowNode.appendChild(colNode);
			}
			parentNode.appendChild(rowNode);
			var flagNode = model.instances(0).selectNodes(newNodesetPath+"/"+strNodesetName+"["+(i+1)+"]/"+newEleName);
			if( flagNode.length > 1 ) {
				for( var k = 2; k <= flagNode.length; k++ ) {
					model.removeNode(newNodesetPath+"/"+strNodesetName+"["+(i+1)+"]/"+newEleName+"["+k+"]");
				}
			}
		}
	}
	return true;
}

function commGridLevels(gridID) {
	var datagrid = (typeof gridID == 'string')?document.controls(gridID):gridID;
	var nodeset = datagrid.nodeset;
	var start = datagrid.fixedRows;
	var cnt = model.getXPathValue("count(" + nodeset + ")");
	for(var i=1; i<=cnt; i++)
		datagrid.outlinelevel(start+i-1) = model.getValue(nodeset + "["+i+"]/LEVEL");
	datagrid.outlinebar = 4;
	datagrid.treecolor = "red";
}

function commGridLevel2(gridID) {
	var datagrid = (typeof gridID == 'string')?document.controls(gridID):gridID;
	datagrid.rebuild();
	commGridInit(datagrid);
	if (datagrid.rows > datagrid.fixedRows) {
		commGridLevels(datagrid);
		var rows = datagrid.rows;
		var colChk = datagrid.colRef("CHK");
		var alternate = false;
		for (var i=datagrid.fixedRows; i<rows; i++) {
			datagrid.valueMatrix(i, colChk) = "N";
			if (model.getValue(datagrid.nodeset + "[" + i + "]/LEVEL") == "2") {
				datagrid.rowStyle(i, "data", "background-color") = deleteRowStyle;
				datagrid.isReadOnly(i, colChk, i, colChk) = true;
			} else {
				datagrid.isCollapsed(i) = 1;
				if (alternate) {
					datagrid.rowStyle(i, "data", "background-color") = "#F7F9F9";
					alternate = false;
				} else {
					alternate = true;
				}
			}
		}
	}
}

function commSendReq() {
	try {
		var length = arguments.length;

		model.removeNodeset("/root/reqData");
		model.makeNode("/root/reqData");
		
		for(var j = 0; j<length; j++) {
			var srcref = arguments[j];
		
			var dup_node = instance1.selectSingleNode(srcref);
			var dup_nodeList = dup_node.childNodes;
			var nodeCnt = dup_nodeList.length;
			if (nodeCnt == 0) {
				model.duplicate("/root/reqData", srcref);
			} else {
				var cnt =1;
				for (var i = 0; i < nodeCnt; i++) {
					var copy_node = srcref + "/" + dup_nodeList.item(i).nodeName;
					var nodeSetYn = instance1.selectNodes(copy_node);

					if(nodeSetYn.length>1) {
						model.duplicate("/root/reqData", copy_node+"["+cnt+"]");
						cnt++;
					} else {
						model.duplicate("/root/reqData", copy_node); 
					}	
				}
			}
		}
	} catch (e) {
		model.alert("Error", "Node Error!");
		return false;
	}
}

var submitID = "mes-service";
var action = "glueAction.do";
function exec(searchInfo, datagrid, serviceTag) {
	if(typeof searchInfo == "string" && searchInfo != "") {
		var searchInfos = searchInfo.split(",");
		searchInfo = "'" + searchInfos[0] + "'";
		for (var i = 1; i < searchInfos.length; i++)
			searchInfo += ", '" + searchInfos[i] + "'";
		eval("commSendReq(" + searchInfo + ")");
	}

	var Idx = 3;
	var length = arguments.length;
	var multiStatus = false; // multi grids
	if (length > Idx && typeof arguments[Idx] == "boolean") {
		multiStatus = arguments[Idx];
		Idx++;
	}
	var multiFlag = "A";
	if (length > Idx && typeof arguments[Idx] == "string") {
		multiFlag = arguments[Idx];
		if (multiFlag == "A" || multiFlag == "U" || multiFlag == "I" || multiFlag == "D")
			Idx++;
		else multiFlag = "A";
	}
	var addonNode = "";
	if (length > Idx && typeof arguments[Idx] == "string" && arguments[Idx].indexOf("/") == -1) {
		addonNode = arguments[Idx];
		Idx++;
	}
	if(typeof datagrid == "string" && datagrid != "") {
		var datagrids = datagrid.split(",");
		for (var i=0; i<datagrids.length; i++) {
			datagrid = datagrids[i];
			if (datagrid == "") continue;
			if (multiStatus)
				commMultiUpdate(datagrid, "/root/reqData", "A", true, "rowStatus_"+i, addonNode);
			else commMultiUpdate(datagrid, "/root/reqData", "A", true, "rowStatus", addonNode);
		}
	} else if(typeof datagrid == "object") {
		commMultiUpdate(datagrid, "/root/reqData", "A", true, "rowStatus", addonNode);
	}

	if(serviceTag == null || serviceTag == "")
		serviceTag = "success";
	commSubmit(submitID, serviceTag, action);

	if (model.getValue("/root/resData/errorData") != "") {
		removeProgressBar();
		alert(model.getValue("/root/resData/errorData"));
	} else {
		for (var i = Idx; i < length; i++) {
			var srcref = arguments[i];
			var Idx = srcref.lastIndexOf("/");
			var lastref = srcref.substr(Idx + 1);
			commAppendData(srcref, "/root/resData/" + lastref);
		};
	}
}

function alertXML(nodeset) {
	if (typeof nodeset == "undefined") nodeset = "/root/reqData";
	try {
		model.alert(model.instances(0).selectSingleNode(nodeset).xml);
	} catch(e) {
		model.alert(nodeset);
	}
}

function alertGrid(gridID, addonNode) {
	var oGrid = (typeof gridID == 'string')?document.controls(gridID):gridID;
	commMultiUpdate(oGrid, "/root/reqData", "A", true, "rowStatus", addonNode);
	alertXML();
}

/*
var _countTimer = 0;
var _clockTimer = new Array();
var _msg = new Array();
function alert(msg) {
	body.removeChild("progressBar");
	_clockTimer[_countTimer] = window.setInterval("intervalRun()", 100);
	_msg[_countTimer++] = msg;
}

function intervalRun() {
	window.clearInterval(_clockTimer[--_countTimer]);
	model.alert(_msg[_countTimer]);
}
*/

function InitParams(node) {
	if (typeof node == "undefined" && typeof node != "object") return;
	model.removenode("/root/initData/rcvInfo");
	model.makeNode("/root/initData/rcvInfo");
	var nodeList = node.childNodes;
	node = model.instances(0).selectSingleNode("/root/initData/rcvInfo");
	for (var i = 0; i < nodeList.length; i++)
		node.appendChild(nodeList.item(i));
}

function copyNode(srcnode, destref) {
	if (srcnode == null || destref == "") return;
	model.removenode(destref);
	model.makeNode(destref);
	var destnode = model.instances(0).selectSingleNode(destref);
	var nodeList = srcnode.childNodes;
	for (var i = 0; i < nodeList.length; i++)
		destnode.appendChild(nodeList.item(i));
}

function duplicate(srcnode, destnode) {
	if (srcnode == null || destnode == null) return;
	var nodeList = destnode.childNodes;
	for (var i = 0; i < nodeList.length; i++)
		destnode.removeChild(nodeList.item(i));
	nodeList = srcnode.childNodes;
	for (var i = 0; i < nodeList.length; i++)
		destnode.appendChild(nodeList.item(i));
}

function cellStyle(gridID, row, cols) {
	var oGrid = (typeof gridID == 'string')?document.controls(gridID):gridID;
	cols = cols.split(",");
	for (var i=0; i<cols.length; i++)
		oGrid.cellStyle("background-color", row, oGrid.colRef(cols[i])) = insertRowStyle;
}

function colStyle(gridID, cols) {
	var oGrid = (typeof gridID == 'string')?document.controls(gridID):gridID;
	cols = cols.split(",");
	for (var i=0; i<cols.length; i++)
		oGrid.colStyle(oGrid.colRef(cols[i]), "data", "background-color") = insertRowStyle;
}

function isReadOnly(gridID, cols) {
	var oGrid = (typeof gridID == 'string')?document.controls(gridID):gridID;
	cols = cols.split(",");
	rows = oGrid.rows - 1;
	for (var i=0; i<cols.length; i++) {
		var colRef = oGrid.colRef(cols[i]);
		oGrid.isReadOnly(0, colRef, rows, colRef) = true;
	}
}

function setReqData(node) {
	var reqData = "";
	if (node.hasChildNodes()) {
		var nodeList = node.childNodes;
		for (var i = 0; i < nodeList.length; i++) {
			reqData += setReqData(nodeList.item(i));
		}
	} else {
		reqData = "&" + node.nodeName + "=" + node.nodeValue;
	}
	return reqData;
}

function excelSubmit(submitID, serviceTag) {
	var reqData = setReqData(model.instances(0).selectSingleNode("/root/reqData"));
	window.load(url + "etAction.jsp?ServiceName=" + submitID + "&" + serviceTag + "=1" + reqData, "html");
}

function excelExport() {
	var filename = window.fileDialog("save", ",", false, "", "xls", "Excel File(*.xls)|*.xls");
	if(filename!="") {
		var gridID;
		try {
			var java = iviewer1.window.javaScript;
			gridID = java.excelExport();
			try {
				var oGrid = (typeof gridID == 'string')?document.controls(gridID):gridID;
				oGrid.saveExcel(filename, "sheetname:Transaction;colhiddenextend:true;exportfalserows:0;");
				alert("导出 Excel 文件：" + filename + " 成功!!!");
			} catch(e) {
				alert("导出 Excel 出错，请确认已安装  Microsoft Office!!!");
			}
		} catch(e) {
			alert("脚本执行错误：excelExport()!!");
		}
	}
}

//从远程服务器地址strRemoteURL下载文件到本地strLocalURL
function downURL(strRemoteURL, strLocalURL){
    try{
        var xmlHTTP = new ActiveXObject("Microsoft.XMLHTTP");
        xmlHTTP.open("post", strRemoteURL, false);
        xmlHTTP.send();
        var adodbStream = new ActiveXObject("ADODB.Stream");
        adodbStream.Type = 1;//1=adTypeBinary 
        adodbStream.Open();
        adodbStream.write(xmlHTTP.responseBody);
        adodbStream.SaveToFile(strLocalURL, 2);
        adodbStream.Close();
        adodbStream = null;
        xmlHTTP = null;
    }
    catch (e){
    	alert("数据处理失败，请重新打印");
    	return false;
    }
    alert("下载完成.");
    return true;
}
