/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleStatement;

public abstract class OracleInputStream
extends OracleBufferedStream {
    OracleStatement statement;
    int columnIndex;
    Accessor accessor;
    OracleInputStream nextStream;
    boolean hasBeenOpen;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050624";

    /*
     * Unable to fully structure code
     */
    protected OracleInputStream(OracleStatement var1_1, int var2_2, Accessor var3_3) {
        block4: {
            block3: {
                super(var1_1.connection.getDefaultStreamChunkSize());
                this.hasBeenOpen = false;
                this.closed = true;
                this.statement = var1_1;
                this.columnIndex = var2_2;
                this.accessor = var3_3;
                this.nextStream = null;
                var4_4 = this.statement.streamList;
                if (var4_4 != null && this.columnIndex >= var4_4.columnIndex) break block3;
                this.nextStream = this.statement.streamList;
                this.statement.streamList = this;
                break block4;
            }
            if (this.columnIndex != var4_4.columnIndex) ** GOTO lbl20
            this.nextStream = var4_4.nextStream;
            var4_4.nextStream = null;
            this.statement.streamList = this;
            break block4;
lbl-1000:
            // 1 sources

            {
                var4_4 = var4_4.nextStream;
lbl20:
                // 2 sources

                ** while (var4_4.nextStream != null && this.columnIndex > var4_4.nextStream.columnIndex)
            }
lbl21:
            // 1 sources

            if (var4_4.nextStream != null && this.columnIndex == var4_4.nextStream.columnIndex) {
                this.nextStream = var4_4.nextStream.nextStream;
                var4_4.nextStream.nextStream = null;
                var4_4.nextStream = this;
            } else {
                this.nextStream = var4_4.nextStream;
                var4_4.nextStream = this;
            }
        }
    }

    public void close() throws IOException {
        if (!this.closed && this.hasBeenOpen) {
            while (this.statement.nextStream != this) {
                this.statement.nextStream.close();
                this.statement.nextStream = this.statement.nextStream.nextStream;
            }
            if (!this.isNull()) {
                while (this.needBytes()) {
                    this.pos = this.count;
                }
            }
            this.closed = true;
        }
    }

    public abstract int getBytes() throws IOException;

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isNull() throws IOException {
        boolean bl = false;
        try {
            bl = this.accessor.isNull(0);
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        return bl;
    }

    public boolean needBytes() throws IOException {
        block5: {
            if (this.closed) {
                return false;
            }
            if (this.pos < this.count) break block5;
            try {
                int n = this.getBytes();
                this.pos = 0;
                this.count = n;
                if (this.count == -1) {
                    if (this.nextStream == null) {
                        this.statement.connection.releaseLine();
                    }
                    this.closed = true;
                    this.accessor.fetchNextColumns();
                    return false;
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
        }
        return true;
    }

    public String toString() {
        return "OIS@" + Integer.toHexString(this.hashCode()) + "{" + "statement = " + this.statement + ", accessor = " + this.accessor + ", nextStream = " + this.nextStream + ", columnIndex = " + this.columnIndex + ", hasBeenOpen = " + this.hasBeenOpen + "}";
    }
}

