/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class CountDown
implements Sync {
    protected final int initialCount_;
    protected int count_;

    public CountDown(int count) {
        this.count_ = this.initialCount_ = count;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDown countDown = this;
        synchronized (countDown) {
            try {
                while (this.count_ > 0) {
                    this.wait();
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDown countDown = this;
        synchronized (countDown) {
            try {
                if (this.count_ <= 0) {
                    return true;
                }
                if (msecs <= (long)0) {
                    return false;
                }
                long waitTime = msecs;
                long start = System.currentTimeMillis();
                do {
                    this.wait(waitTime);
                    if (this.count_ > 0) continue;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > (long)0);
                return false;
            }
            catch (Throwable throwable) {
                Object var13_8 = null;
                throw throwable;
            }
        }
    }

    public synchronized void release() {
        if (--this.count_ == 0) {
            this.notifyAll();
        }
    }

    public int initialCount() {
        return this.initialCount_;
    }

    public synchronized int currentCount() {
        return this.count_;
    }
}

