/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedNode;

public class LinkedQueue
implements Channel {
    protected LinkedNode head_;
    protected final Object putLock_ = new Object();
    protected LinkedNode last_ = this.head_ = new LinkedNode(null);
    protected int waitingForTake_ = 0;

    protected void insert(Object x) {
        Object object = this.putLock_;
        synchronized (object) {
            try {
                LinkedNode p = new LinkedNode(x);
                LinkedNode linkedNode = this.last_;
                synchronized (linkedNode) {
                    try {
                        this.last_.next = p;
                        this.last_ = p;
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        throw throwable;
                    }
                }
                if (this.waitingForTake_ > 0) {
                    this.putLock_.notify();
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }

    protected synchronized Object extract() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            try {
                Object x = null;
                LinkedNode first = this.head_.next;
                if (first != null) {
                    x = first.value;
                    first.value = null;
                    this.head_ = first;
                }
                Object object = x;
                Object var6_5 = null;
                return object;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(x);
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(x);
        return true;
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.putLock_;
        synchronized (object) {
            try {
                try {
                    ++this.waitingForTake_;
                    while (true) {
                        if ((x = this.extract()) != null) {
                            --this.waitingForTake_;
                            Object object2 = x;
                            Object var5_5 = null;
                            return object2;
                        }
                        this.putLock_.wait();
                    }
                }
                catch (InterruptedException ex) {
                    --this.waitingForTake_;
                    this.putLock_.notify();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    public Object peek() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            Object var4_7;
            try {
                LinkedNode first = this.head_.next;
                if (first != null) {
                    Object object = first.value;
                    Object var6_4 = null;
                    return object;
                }
                var4_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
            Object var6_5 = null;
            return var4_7;
        }
    }

    public boolean isEmpty() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            try {
                boolean bl = this.head_.next == null;
                Object var4_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.putLock_;
        synchronized (object) {
            try {
                try {
                    long waitTime = msecs;
                    long start = msecs <= (long)0 ? 0L : System.currentTimeMillis();
                    ++this.waitingForTake_;
                    while (true) {
                        if ((x = this.extract()) != null || waitTime <= (long)0) {
                            --this.waitingForTake_;
                            Object object2 = x;
                            Object var11_8 = null;
                            return object2;
                        }
                        this.putLock_.wait(waitTime);
                        waitTime = msecs - (System.currentTimeMillis() - start);
                    }
                }
                catch (InterruptedException ex) {
                    --this.waitingForTake_;
                    this.putLock_.notify();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                throw throwable;
            }
        }
    }
}

