/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.cache;

import com.posdata.glue.security.cache.PosAbstractContent;
import com.posdata.glue.security.cache.PosEventContent;
import com.posdata.glue.security.cache.PosHostContent;
import com.posdata.glue.security.common.config.PosSecurityConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PosFunctionContent
extends PosAbstractContent {
    private static final String HOST_CONTENT_FIELD = "Host";
    private static final String FUNCTION_NAME_CONTENT_FIELD = "FunctionName";
    private static final String CONNECTION_TYPE_CONTENT_FIELD = "ConnectionType";
    private static final String FUNCTION_SERVICE_LANG_TP_CONTENT_FIELD = "functionserviceLangTp";
    private static final String PARAMETERS_CONTENT_FIELD = "Parameters";
    private static final String SEQUENCE_NUMBER_CONTENT_FIELD = "SequenceNumber";
    private static final String INFO_SECURITY_LEVEL_CD_CONTENT_FIELD = "InfoSecurityLevelCd";
    private static final String TOTAL_EVENT_CONTENT_FIELD = "TotalEvent";
    private static final String SERVICE_NAME_CONTENT_FIELD = "ServiceName";
    private static final String APPLICABLE_URLS = "ApplicableUrls";
    private static final String APPLICABLE_EVENT_URL = "ApplicableEventUrl";
    private static final String APPLICABLE_EVENT = "ApplicableEvent";
    private static final String CONTEXT_ROOT = "ContextRoot";
    private static final String LOCAL_HOST = "LOCAL_HOST";
    private PosHostContent posHostContent;
    private PosEventContent posEventContent;

    public Map getFunctionList() {
        return null;
    }

    public PosFunctionContent(String id) {
        super(id);
    }

    public void setHostContent(PosHostContent posHostContent) {
        this.posHostContent = posHostContent;
    }

    public void setHostContent(Map hostMap) {
        if (hostMap == null || hostMap.isEmpty()) {
            return;
        }
        this.setHostContent((PosHostContent)hostMap.get(this.getHost()));
    }

    public String getHost() {
        return this.getAttributeValue(HOST_CONTENT_FIELD);
    }

    public String getFunctionName() {
        return this.getAttributeValue(FUNCTION_NAME_CONTENT_FIELD);
    }

    public String getConnectionType() {
        return this.getAttributeValue(CONNECTION_TYPE_CONTENT_FIELD);
    }

    public String getFunctionServiceLangTp() {
        return this.getAttributeValue(FUNCTION_SERVICE_LANG_TP_CONTENT_FIELD);
    }

    public String getParameters() {
        return this.getAttributeValue(PARAMETERS_CONTENT_FIELD);
    }

    public String getSequenceNumber() {
        return this.getAttributeValue(SEQUENCE_NUMBER_CONTENT_FIELD);
    }

    public String getInfoSecurityLevelCd() {
        return this.getAttributeValue(INFO_SECURITY_LEVEL_CD_CONTENT_FIELD);
    }

    public List getTotalEventList() {
        if (this.posEventContent == null || this.posEventContent.getAttributeValue(TOTAL_EVENT_CONTENT_FIELD) == null) {
            return null;
        }
        return Arrays.asList(this.posEventContent.getAttributeValue(TOTAL_EVENT_CONTENT_FIELD).split(","));
    }

    public String getMainUrl() {
        String hostUrl;
        if (this.getApplicableUrls() == null || this.getApplicableUrls().isEmpty()) {
            return null;
        }
        StringBuffer urlBuffer = new StringBuffer(100);
        if (!PosSecurityConfig.isSingleHost() && this.posHostContent != null && !LOCAL_HOST.equals(hostUrl = this.posHostContent.getUrlForWorksCode(PosSecurityConfig.getPlantFlag())) && hostUrl != null) {
            urlBuffer.append("http://" + hostUrl);
        }
        urlBuffer.append(this.getContextRoot() + (String)this.getApplicableUrls().get(0));
        if (urlBuffer.toString().endsWith("?")) {
            urlBuffer.append("ServiceName=" + this.getServiceName());
        } else {
            urlBuffer.append("?ServiceName=" + this.getServiceName());
        }
        if (this.getParameters() == null) {
            urlBuffer.append("&NS_FKEY=" + this.getId());
        } else {
            urlBuffer.append("&" + this.getParameters() + "&NS_FKEY=" + this.getId());
        }
        return urlBuffer.toString();
    }

    public String getApplicableEventUrl() {
        if (this.posEventContent == null) {
            return null;
        }
        return this.posEventContent.getAttributeValue(APPLICABLE_EVENT_URL);
    }

    public List getApplicableEvents() {
        if (this.posEventContent == null || this.posEventContent.getAttributeValue(APPLICABLE_EVENT) == null) {
            return null;
        }
        return Arrays.asList(this.posEventContent.getAttributeValue(APPLICABLE_EVENT).split(","));
    }

    public String getServiceName() {
        return this.getAttributeValue(SERVICE_NAME_CONTENT_FIELD);
    }

    public List getApplicableUrls() {
        if (this.getAttributeValue(APPLICABLE_URLS) != null) {
            return Arrays.asList(this.getAttributeValue(APPLICABLE_URLS).split(","));
        }
        return null;
    }

    public String getContextRoot() {
        return this.getAttributeValue(CONTEXT_ROOT);
    }

    public void setEventContent(PosEventContent posEventContent) {
        this.posEventContent = posEventContent;
    }
}

