/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.cache.manager;

import com.posdata.glue.PosException;
import com.posdata.glue.cache.PosCacheLoader;
import com.posdata.glue.security.cache.PosAbstractContent;
import com.posdata.glue.security.cache.PosAttributeContent;
import com.posdata.glue.security.cache.PosEventContent;
import com.posdata.glue.security.cache.PosFunctionContent;
import com.posdata.glue.security.cache.PosHostContent;
import com.posdata.glue.security.cache.PosMenuContent;
import com.posdata.glue.security.cache.PosMenuEntryContent;
import com.posdata.glue.security.cache.PosMenuEntryContentFunctionShape;
import com.posdata.glue.security.cache.PosMenuEntryContentMenuShape;
import com.posdata.glue.security.cache.PosMenuEntryContentRespShape;
import com.posdata.glue.security.cache.PosResponsibilityContent;
import com.posdata.glue.security.cache.PosSecurityCacheException;
import com.posdata.glue.security.cache.PosUrlContent;
import com.posdata.glue.security.cache.PosUserContent;
import com.posdata.glue.security.cache.PosUserRespGroupsContent;
import com.posdata.glue.security.cache.PosUserRespsContent;
import com.posdata.glue.security.userdetails.manager.PosUserDetailsServiceConstants;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import com.posdata.glue.util.xml.PosXMLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PosSecureCacheLoader
implements PosCacheLoader,
PosUserDetailsServiceConstants {
    private PosLog logger = PosLogFactory.getLogger(this.getClass());

    public Object loadCacheObject(Object cacheKey, String regionName) throws PosException {
        try {
            if ("USER_INFO".equals(cacheKey)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"makeUserInfo loading.....");
                }
                return this.makeUserInfo();
            }
            if ("USER_RESP_MAPPING_INFO".equals(cacheKey)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"makeUserRespInfo loading.....");
                }
                return this.makeUserRespInfo();
            }
            if ("FUNC_INFO".equals(cacheKey)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"makeFunctionInfo loading.....");
                }
                return this.makeFunctionInfo();
            }
            if ("RESP_INFO".equals(cacheKey) || "RESP_HIERARCHY_INFO".equals(cacheKey)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"makeRespInfo loading.....");
                }
                return this.makeRespInfo();
            }
            return null;
        }
        catch (Exception ex) {
            throw new PosSecurityCacheException("Security Data Loading Faliure", ex);
        }
    }

    public Object editFunctionCacheObject(Object funcJCSInfo, Object hostJCSInfo) {
        return null;
    }

    public Object loadCacheObject(Object cacheKey, String regionName, Object refCacheObject) throws PosException {
        try {
            if ("USER_INFO".equals(cacheKey)) {
                return this.makeUserInfo();
            }
            if ("USER_RESP_MAPPING_INFO".equals(cacheKey)) {
                return this.makeUserRespInfo();
            }
            if ("FUNC_INFO".equals(cacheKey)) {
                return this.makeFunctionInfo();
            }
            if ("RESP_INFO".equals(cacheKey) || "RESP_HIERARCHY_INFO".equals(cacheKey)) {
                return this.makeRespInfo((Map)refCacheObject);
            }
            return null;
        }
        catch (Exception ex) {
            throw new PosSecurityCacheException("Security Data Loading Faliure", ex);
        }
    }

    public Object makeUserInfo() throws Exception {
        String filePath = this.getConfigPath() + "users.xml";
        PosXMLUtil xmlUtil = new PosXMLUtil();
        Map parsedResult = xmlUtil.loadXMLFileName(filePath);
        return this.makeParsedUserResultToJCSFormat(parsedResult);
    }

    private Object makeParsedUserResultToJCSFormat(Map parsedResult) {
        if (parsedResult == null || parsedResult.isEmpty()) {
            return null;
        }
        HashMap userJCSInfo = null;
        if (((Map)parsedResult.get("users")).get("user") instanceof Map) {
            userJCSInfo = new HashMap();
            this.setUserInfoForJCS((Map)((Map)parsedResult.get("users")).get("user"), userJCSInfo);
            return userJCSInfo;
        }
        ArrayList userList = (ArrayList)((Map)parsedResult.get("users")).get("user");
        if (userList == null || userList.isEmpty()) {
            return null;
        }
        userJCSInfo = new HashMap();
        for (int i = 0; i < userList.size(); ++i) {
            this.setUserInfoForJCS((Map)userList.get(i), userJCSInfo);
        }
        return userJCSInfo;
    }

    private void setUserInfoForJCS(Map parsedUserInfoMap, Map userJCSInfo) {
        ArrayList attributeList = (ArrayList)parsedUserInfoMap.get("attribute");
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        PosUserContent posUserContent = new PosUserContent();
        PosAttributeContent posAttributeContent = null;
        ArrayList nameValueList = new ArrayList(10);
        for (int i = 0; i < attributeList.size(); ++i) {
            posAttributeContent = new PosAttributeContent();
            posAttributeContent.setName((String)((Map)attributeList.get(i)).get("name"));
            posAttributeContent.setValue((String)((Map)attributeList.get(i)).get("value"));
            posAttributeContent.setType((String)((Map)attributeList.get(i)).get("type"));
            posUserContent.setAttribute(posAttributeContent.getName(), posAttributeContent);
        }
        userJCSInfo.put((String)parsedUserInfoMap.get("empno"), posUserContent);
    }

    public static void main(String[] args) {
        try {
            PosSecureCacheLoader loader = new PosSecureCacheLoader();
            Map userMap = (Map)loader.makeRespInfo();
            System.out.println(userMap);
            Object a = ((Map)userMap.get("RESP_HIERARCHY_INFO")).get("m00f_rm01");
            System.out.println(a);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getFilePath(String fileName) {
        return this.getConfigPath() + fileName;
    }

    public Object makeRespInfo(Map funcJCSInfo) throws Exception {
        String filePath = this.getConfigPath() + "responsibilities.xml";
        PosXMLUtil xmlUtil = new PosXMLUtil();
        Map parsedResult = xmlUtil.loadXMLFileName(filePath);
        if (funcJCSInfo == null || funcJCSInfo.isEmpty()) {
            funcJCSInfo = (Map)this.makeFunctionInfo();
        }
        return this.makeParsedRespResultToJCSFormat(parsedResult, funcJCSInfo);
    }

    public Object makeRespInfo() throws Exception {
        String filePath = this.getConfigPath() + "responsibilities.xml";
        PosXMLUtil xmlUtil = new PosXMLUtil();
        Map parsedResult = xmlUtil.loadXMLFileName(filePath);
        Map funcJCSInfo = (Map)this.makeFunctionInfo();
        return this.makeParsedRespResultToJCSFormat(parsedResult, funcJCSInfo);
    }

    private Object makeParsedRespResultToJCSFormat(Map parsedResult, Map funcJCSInfo) {
        HashMap menuJCSInfo = new HashMap(50);
        HashMap respJCSInfo = new HashMap(15);
        HashMap respHierarchyJCSInfo = new HashMap(15);
        HashMap<String, Map> totalRespJCSInfo = new HashMap<String, Map>(6);
        Object respObject = ((Map)((Map)parsedResult.get("resp-menus")).get("responsibilities")).get("responsibility");
        if (respObject instanceof Map) {
            this.setRespInfoForJCS((Map)respObject, new Map[]{respJCSInfo, menuJCSInfo, respHierarchyJCSInfo, funcJCSInfo});
        } else if (respObject instanceof ArrayList) {
            ArrayList respObjectList = (ArrayList)respObject;
            for (int i = 0; i < respObjectList.size(); ++i) {
                this.setRespInfoForJCS((Map)respObjectList.get(i), new Map[]{respJCSInfo, menuJCSInfo, respHierarchyJCSInfo, funcJCSInfo});
            }
        } else {
            return null;
        }
        if (((Map)parsedResult.get("resp-menus")).get("menus") == null) {
            totalRespJCSInfo.put("RESP_INFO", respJCSInfo);
            totalRespJCSInfo.put("RESP_HIERARCHY_INFO", respHierarchyJCSInfo);
            totalRespJCSInfo.put("MENU_INFO", menuJCSInfo);
            totalRespJCSInfo.put("FUNC_INFO", funcJCSInfo);
            return totalRespJCSInfo;
        }
        Object menuObject = ((Map)((Map)parsedResult.get("resp-menus")).get("menus")).get("menu");
        if (menuObject instanceof Map) {
            this.setMenuInfoForJCS((Map)menuObject, new Map[]{respJCSInfo, menuJCSInfo, respHierarchyJCSInfo, funcJCSInfo});
        } else if (menuObject instanceof ArrayList) {
            ArrayList menuObjectList = (ArrayList)menuObject;
            for (int i = 0; i < menuObjectList.size(); ++i) {
                this.setMenuInfoForJCS((Map)menuObjectList.get(i), new Map[]{respJCSInfo, menuJCSInfo, respHierarchyJCSInfo, funcJCSInfo});
            }
        }
        totalRespJCSInfo.put("RESP_INFO", respJCSInfo);
        totalRespJCSInfo.put("RESP_HIERARCHY_INFO", respHierarchyJCSInfo);
        totalRespJCSInfo.put("MENU_INFO", menuJCSInfo);
        totalRespJCSInfo.put("FUNC_INFO", funcJCSInfo);
        return totalRespJCSInfo;
    }

    private void setMenuInfoForJCS(Map parsedMenuObject, Map[] refJCSInfo) {
        String menuKey = (String)parsedMenuObject.get("key");
        PosMenuContent posMenuContent = (PosMenuContent)refJCSInfo[1].get(menuKey);
        if (posMenuContent == null) {
            posMenuContent = new PosMenuContent(menuKey);
            refJCSInfo[1].put(menuKey, posMenuContent);
        }
        this.setAttributesInContent(parsedMenuObject.get("attribute"), posMenuContent);
        PosMenuEntryContent posMenuEntryMenuShape = (PosMenuEntryContent)refJCSInfo[2].get(menuKey);
        if (posMenuEntryMenuShape == null) {
            posMenuEntryMenuShape = new PosMenuEntryContentMenuShape();
            refJCSInfo[2].put(menuKey, posMenuEntryMenuShape);
        }
        posMenuEntryMenuShape.setApplicableMenuEntryForType(posMenuContent);
        Object menuEntriesObject = parsedMenuObject.get("entries");
        if (menuEntriesObject == null) {
            return;
        }
        Object menuEntryObject = ((Map)menuEntriesObject).get("entry");
        if (menuEntryObject instanceof Map) {
            this.setMenuEntryInfoForJCS(posMenuEntryMenuShape, (Map)menuEntryObject, refJCSInfo);
        } else if (menuEntryObject instanceof ArrayList) {
            ArrayList menuEntryList = (ArrayList)menuEntryObject;
            for (int i = 0; i < menuEntryList.size(); ++i) {
                this.setMenuEntryInfoForJCS(posMenuEntryMenuShape, (Map)menuEntryList.get(i), refJCSInfo);
            }
        }
    }

    private void setAttributesInContent(Object attributeContents, PosAbstractContent applicableContent) {
        if (attributeContents == null) {
            return;
        }
        PosAttributeContent posAttributeContent = null;
        if (attributeContents instanceof Map) {
            posAttributeContent = new PosAttributeContent();
            posAttributeContent.setName((String)((Map)attributeContents).get("name"));
            posAttributeContent.setValue((String)((Map)attributeContents).get("value"));
            posAttributeContent.setType((String)((Map)attributeContents).get("type"));
            applicableContent.setAttribute(posAttributeContent.getName(), posAttributeContent);
        } else if (attributeContents instanceof ArrayList) {
            ArrayList attributeList = (ArrayList)attributeContents;
            for (int i = 0; i < attributeList.size(); ++i) {
                posAttributeContent = new PosAttributeContent();
                posAttributeContent.setName((String)((Map)attributeList.get(i)).get("name"));
                posAttributeContent.setValue((String)((Map)attributeList.get(i)).get("value"));
                posAttributeContent.setType((String)((Map)attributeList.get(i)).get("type"));
                applicableContent.setAttribute(posAttributeContent.getName(), posAttributeContent);
            }
        } else {
            return;
        }
    }

    private void setAttributesInMenuEntryContent(String subEntryKey, Object attributeContents, PosMenuEntryContent parentMenuEntry) {
        if (attributeContents == null) {
            return;
        }
        PosAttributeContent posAttributeContent = null;
        if (attributeContents instanceof Map) {
            posAttributeContent = new PosAttributeContent();
            posAttributeContent.setName((String)((Map)attributeContents).get("name"));
            posAttributeContent.setValue((String)((Map)attributeContents).get("value"));
            posAttributeContent.setType((String)((Map)attributeContents).get("type"));
            parentMenuEntry.addSubEntryInfo(subEntryKey, posAttributeContent);
        } else if (attributeContents instanceof ArrayList) {
            ArrayList attributeList = (ArrayList)attributeContents;
            for (int i = 0; i < attributeList.size(); ++i) {
                posAttributeContent = new PosAttributeContent();
                posAttributeContent.setName((String)((Map)attributeList.get(i)).get("name"));
                posAttributeContent.setValue((String)((Map)attributeList.get(i)).get("value"));
                posAttributeContent.setType((String)((Map)attributeList.get(i)).get("type"));
                parentMenuEntry.addSubEntryInfo(subEntryKey, posAttributeContent);
            }
        } else {
            return;
        }
    }

    private void setRespInfoForJCS(Map parsedRespObject, Map[] refJCSInfo) {
        PosResponsibilityContent posResponsibilityContent = new PosResponsibilityContent((String)parsedRespObject.get("key"));
        refJCSInfo[0].put(parsedRespObject.get("key"), posResponsibilityContent);
        this.setAttributesInContent(parsedRespObject.get("attribute"), posResponsibilityContent);
        PosMenuEntryContentRespShape posMenuEntryContentRespShape = new PosMenuEntryContentRespShape();
        posMenuEntryContentRespShape.setApplicableMenuEntryForType(posResponsibilityContent);
        refJCSInfo[2].put(parsedRespObject.get("key"), posMenuEntryContentRespShape);
        Object menuEntriesObject = parsedRespObject.get("entries");
        if (menuEntriesObject == null) {
            return;
        }
        Object menuEntryObject = ((Map)menuEntriesObject).get("entry");
        if (menuEntryObject instanceof Map) {
            this.setMenuEntryInfoForJCS(posMenuEntryContentRespShape, (Map)menuEntryObject, refJCSInfo);
        } else if (menuEntryObject instanceof ArrayList) {
            ArrayList menuEntryList = (ArrayList)menuEntryObject;
            for (int i = 0; i < menuEntryList.size(); ++i) {
                this.setMenuEntryInfoForJCS(posMenuEntryContentRespShape, (Map)menuEntryList.get(i), refJCSInfo);
            }
        }
    }

    private void setMenuEntryInfoForJCS(PosMenuEntryContent parentMenuEntry, Map menuEntryObject, Map[] refJCSInfo) {
        String entryType = (String)menuEntryObject.get("type");
        String subEntryKey = (String)menuEntryObject.get("key");
        PosMenuEntryContent posMenuEntryContent = null;
        PosAbstractContent posApplicableContent = null;
        if ("Menu".equals(entryType)) {
            posMenuEntryContent = new PosMenuEntryContentMenuShape();
            posApplicableContent = (PosAbstractContent)refJCSInfo[1].get(subEntryKey);
            if (posApplicableContent == null) {
                posApplicableContent = new PosMenuContent(subEntryKey);
                refJCSInfo[1].put(subEntryKey, posApplicableContent);
            }
        } else if ("Function".equals(entryType)) {
            posMenuEntryContent = new PosMenuEntryContentFunctionShape();
            posApplicableContent = (PosAbstractContent)refJCSInfo[3].get(subEntryKey);
            if (posApplicableContent == null) {
                posApplicableContent = new PosFunctionContent(subEntryKey);
                refJCSInfo[3].put(subEntryKey, posApplicableContent);
            }
        } else {
            return;
        }
        posMenuEntryContent.setEntryType(entryType);
        posMenuEntryContent.setApplicableMenuEntryForType(posApplicableContent);
        try {
            refJCSInfo[2].put(subEntryKey, posMenuEntryContent);
            parentMenuEntry.addMenuEntry(posMenuEntryContent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.setAttributesInMenuEntryContent(subEntryKey, menuEntryObject.get("attribute"), parentMenuEntry);
    }

    public Object makeUserRespInfo() throws Exception {
        String filePath = this.getConfigPath() + "user-resp-mapping.xml";
        PosXMLUtil xmlUtil = new PosXMLUtil();
        Map parsedResult = xmlUtil.loadXMLFileName(filePath);
        return this.makeParsedUserRespResultToJCSFormat(parsedResult);
    }

    private Object makeParsedUserRespResultToJCSFormat(Map parsedResult) {
        Object userRespObject = ((Map)parsedResult.get("user-resp-mappings")).get("user-resp-mapping");
        if (userRespObject == null) {
            return null;
        }
        PosUserRespGroupsContent userRespJCSInfo = new PosUserRespGroupsContent();
        PosUserRespsContent posUserRespsContent = null;
        if (userRespObject instanceof Map) {
            posUserRespsContent = new PosUserRespsContent();
            this.setAttributesInContent(((Map)userRespObject).get("attribute"), posUserRespsContent);
            userRespJCSInfo.addUserRespsContent(posUserRespsContent);
        } else if (userRespObject instanceof ArrayList) {
            ArrayList userRespList = (ArrayList)userRespObject;
            for (int i = 0; i < userRespList.size(); ++i) {
                posUserRespsContent = new PosUserRespsContent();
                this.setAttributesInContent(((Map)userRespList.get(i)).get("attribute"), posUserRespsContent);
                userRespJCSInfo.addUserRespsContent(posUserRespsContent);
            }
        }
        return userRespJCSInfo;
    }

    private Object makeHostInfo() throws Exception {
        String filePath = this.getConfigPath() + "functions.xml";
        PosXMLUtil xmlUtil = new PosXMLUtil();
        Map parsedResult = xmlUtil.loadXMLFileName(filePath);
        return this.makeHostInfo(parsedResult);
    }

    private Object makeHostInfo(Map parsedResult) {
        return this.makeParsedHostResultToJCSFormat(((Map)((Map)parsedResult.get("hosts-functions")).get("hosts")).get("host"));
    }

    private Object makeParsedHostResultToJCSFormat(Object hostObject) {
        HashMap hostJCSInfo = null;
        if (hostObject instanceof Map) {
            hostJCSInfo = new HashMap(100);
            this.setHostInfoForJCS((Map)hostObject, hostJCSInfo);
            return hostJCSInfo;
        }
        ArrayList hostList = (ArrayList)hostObject;
        hostJCSInfo = new HashMap(100);
        for (int i = 0; i < hostList.size(); ++i) {
            this.setHostInfoForJCS((Map)hostList.get(i), hostJCSInfo);
        }
        return hostJCSInfo;
    }

    private void setHostInfoForJCS(Map hostMap, Map hostJCSInfo) {
        Map attributeMap = (Map)hostMap.get("attribute");
        if (attributeMap == null || attributeMap.isEmpty()) {
            return;
        }
        PosHostContent posHostContent = new PosHostContent((String)hostMap.get("name"));
        this.setAttributesInContent(attributeMap, posHostContent);
        posHostContent.setUrlContent(this.getUrlContentFromHostInfo((Map)hostMap.get("url")));
        hostJCSInfo.put((String)hostMap.get("name"), posHostContent);
    }

    private PosUrlContent getUrlContentFromHostInfo(Map urlMap) {
        if (urlMap == null || urlMap.isEmpty()) {
            return null;
        }
        PosUrlContent posUrlContent = new PosUrlContent();
        this.setAttributesInContent(urlMap.get("attribute"), posUrlContent);
        return posUrlContent;
    }

    public Object makeFunctionInfo() throws Exception {
        String filePath = this.getConfigPath() + "functions.xml";
        PosXMLUtil xmlUtil = new PosXMLUtil();
        Map parsedResult = xmlUtil.loadXMLFileName(filePath);
        Map hostJCSInfo = (Map)this.makeHostInfo(parsedResult);
        return this.makeParsedFunctionResultToJCSFormat(parsedResult, hostJCSInfo);
    }

    private Object makeParsedFunctionResultToJCSFormat(Map parsedResult, Map hostJCSInfo) {
        if (parsedResult == null || parsedResult.isEmpty()) {
            return null;
        }
        HashMap functionJCSInfo = null;
        if (((Map)((Map)parsedResult.get("hosts-functions")).get("functions")).get("function") instanceof Map) {
            functionJCSInfo = new HashMap(100);
            this.setFunctionInfoForJCS((Map)((Map)((Map)parsedResult.get("hosts-functions")).get("functions")).get("function"), functionJCSInfo, hostJCSInfo);
            return functionJCSInfo;
        }
        ArrayList funcList = (ArrayList)((Map)((Map)parsedResult.get("hosts-functions")).get("functions")).get("function");
        if (funcList == null || funcList.isEmpty()) {
            return null;
        }
        functionJCSInfo = new HashMap(100);
        for (int i = 0; i < funcList.size(); ++i) {
            this.setFunctionInfoForJCS((Map)funcList.get(i), functionJCSInfo, hostJCSInfo);
        }
        return functionJCSInfo;
    }

    private void setFunctionInfoForJCS(Map funcMap, Map functionJCSInfo, Map hostJCSInfo) {
        if (funcMap == null || funcMap.isEmpty()) {
            return;
        }
        ArrayList attributeList = (ArrayList)funcMap.get("attribute");
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        PosFunctionContent posFuncContent = new PosFunctionContent((String)funcMap.get("key"));
        this.setAttributesInContent(funcMap.get("attribute"), posFuncContent);
        posFuncContent.setHostContent(hostJCSInfo);
        functionJCSInfo.put((String)funcMap.get("key"), posFuncContent);
        if (funcMap.get("event") == null) {
            return;
        }
        PosEventContent posEventContent = new PosEventContent();
        this.setAttributesInContent(((Map)funcMap.get("event")).get("attribute"), posEventContent);
        posFuncContent.setEventContent(posEventContent);
    }

    private Object makeRespHierarchyInfo() {
        return null;
    }

    private String getConfigPath() {
        return System.getProperty("CONFIG_PATH");
    }
}

