/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.userdetails.manager;

import com.posdata.glue.security.PosAuthenticationConfigurationNotValidException;
import com.posdata.glue.security.PosAuthenticationUserExpiredException;
import com.posdata.glue.security.PosAuthenticationUserNotFoundException;
import com.posdata.glue.security.PosUserImpl;
import com.posdata.glue.security.cache.PosMenuEntryContent;
import com.posdata.glue.security.cache.PosResponsibilityContent;
import com.posdata.glue.security.cache.PosUserContent;
import com.posdata.glue.security.cache.PosUserRespGroupsContent;
import com.posdata.glue.security.cache.PosUserRespsContent;
import com.posdata.glue.security.context.PosSecurityContextHolder;
import com.posdata.glue.security.userdetails.manager.PosUserDetailsService;
import com.posdata.glue.security.userdetails.manager.PosUserDetailsServiceConstants;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PosUserDetailsServiceImpl
implements PosUserDetailsService,
PosUserDetailsServiceConstants {
    private PosLog logger = PosLogFactory.getLogger(this.getClass());

    public PosUserImpl getDefaultUserDetails() {
        PosUserImpl user = new PosUserImpl();
        user.setUserEmpNo("PD088888");
        user.setUserName("\ud64d\uae38\ub3d9");
        return user;
    }

    public PosUserImpl getUserDetails(String userEmpNo, String plantFlag) {
        return this.makeUserObjectInfo(userEmpNo, plantFlag);
    }

    private PosUserImpl makeUserObjectInfo(String userEmpNo, String plantFlag) {
        PosUserImpl user = new PosUserImpl();
        user.setUserEmpNo(userEmpNo);
        user.setPlantFlag(plantFlag);
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)"makeUserObjectInfo : setting user's Basic Information");
        }
        this.setUserBasicInfo(user);
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)"makeUserObjectInfo : setting user's detail information");
        }
        this.setUserDetailsInfo(user);
        return user;
    }

    private void setUserBasicInfo(PosUserImpl user) {
        if (PosSecurityContextHolder.getPosSecureCaheUtil().getUserInfoContent(user.getUserEmpNo()) == null) {
            if (this.logger.isFatalEnabled()) {
                this.logger.logFatal((Object)"user Information not found in JCS");
            }
            throw new PosAuthenticationUserNotFoundException("user(" + user.getUserEmpNo() + ") is not valid user");
        }
        PosUserContent userInfoContent = PosSecurityContextHolder.getPosSecureCaheUtil().getUserInfoContent(user.getUserEmpNo());
        if (userInfoContent == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"Security Configuration is not valid : user Infomation not found in JCS,  PosUserContent is null");
            }
            throw new PosAuthenticationConfigurationNotValidException("Security Configuration is not valid : user Infomation not found in JCS");
        }
        if (!userInfoContent.isValidObject()) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"PosUserContent isValidObject : false ");
            }
            throw new PosAuthenticationUserExpiredException("user[" + user.getUserEmpNo() + "] is Expired");
        }
        user.setUserName(userInfoContent.getUserName());
        user.setHrOrganizationCode(userInfoContent.getHrOrganizationCode());
        user.setHrOrganizationName(userInfoContent.getHrOrganizationName());
        user.setForemanCode(userInfoContent.getForemanCode());
        user.setForemanName(userInfoContent.getForemanName());
        user.setSupervisionCode(userInfoContent.getSupervisionCode());
        user.setSupervisionName(userInfoContent.getSupervisionName());
        user.setGroupManagerCode(userInfoContent.getGroupManagerCode());
        user.setGroupManagerName(userInfoContent.getGroupManagerName());
        user.setCompetencyGradeCode(userInfoContent.getCompetencyGradeCode());
        user.setCompetencyName(userInfoContent.getCompetencyName());
        user.setEmploymentCategory(userInfoContent.getEmploymentCategory());
        user.setShiftUnit(userInfoContent.getShiftUnit());
        user.setOfficeNumber(userInfoContent.getOfficeNumber());
        user.setMobilePhone(userInfoContent.getMobilePhone());
        user.setEmailAddress(userInfoContent.getEmailAddress());
        user.setInfoSecurityLevelCd(userInfoContent.getInfoSecurityLevelCd());
        user.setWorkLocation(userInfoContent.getWorkLocation());
        user.setWorkLocationName(userInfoContent.getWorkLocationName());
    }

    private void setUserDetailsInfo(PosUserImpl user) {
        if (PosSecurityContextHolder.getPosSecureCaheUtil().getUserRespInfoContent() == null) {
            return;
        }
        ArrayList userRespList = this.getUserRespMappingInfo(user);
        if (userRespList == null || userRespList.isEmpty()) {
            return;
        }
        HashMap userFunctionMap = new HashMap(10);
        HashMap userRespMap = new HashMap(10);
        HashMap respFunctionMap = new HashMap(10);
        for (int i = 0; i < userRespList.size(); ++i) {
            this.setRespTotalInfo((PosUserRespsContent)userRespList.get(i), userRespMap, userFunctionMap, respFunctionMap);
        }
        user.setUserFunctions(userFunctionMap);
        user.setUserRespMap(userRespMap);
        user.setRespFunctionMap(respFunctionMap);
    }

    private void setRespTotalInfo(PosUserRespsContent userRespContent, Map userRespMap, Map userFunctionMap, Map respFunctionMap) {
        if (userRespContent == null || !userRespContent.isValidObject() || userRespMap == null || userFunctionMap == null || respFunctionMap == null) {
            return;
        }
        PosResponsibilityContent respInfoContent = PosSecurityContextHolder.getPosSecureCaheUtil().getRespInfoContent(userRespContent.getResponsibilityKey());
        if (respInfoContent == null || !respInfoContent.isValidObject()) {
            return;
        }
        userRespMap.put(userRespContent.getResponsibilityKey(), respInfoContent.getResponsibilityName());
        this.setFunctionForUserNResp(userRespContent.getResponsibilityKey(), userFunctionMap, respFunctionMap);
    }

    private void setFunctionForUserNResp(String respKey, Map userFunctionMap, Map respFunctionMap) {
        block5: {
            PosMenuEntryContent posMenuEntry = PosSecurityContextHolder.getPosSecureCaheUtil().getRespHierarchyInfoContent(respKey);
            if (posMenuEntry == null) {
                return;
            }
            try {
                respFunctionMap = posMenuEntry.getFunctionList();
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"PosMenuEntry.getFunctionList() : success");
                }
            }
            catch (Exception ex) {
                if (!this.logger.isErrorEnabled()) break block5;
                this.logger.logError((Object)"posMenuEntry.getFunctionList : ", (Throwable)ex);
            }
        }
        if (respFunctionMap == null || respFunctionMap.isEmpty()) {
            return;
        }
        userFunctionMap.putAll(respFunctionMap);
        respFunctionMap.put(respKey, Arrays.asList(respFunctionMap.keySet().toArray()));
    }

    private ArrayList getUserRespMappingInfo(PosUserImpl user) {
        PosUserRespGroupsContent userRespContent = PosSecurityContextHolder.getPosSecureCaheUtil().getUserRespInfoContent();
        if (userRespContent == null) {
            return null;
        }
        return userRespContent.getUserRespsList(user.getPlantFlag(), user.getUserEmpNo());
    }
}

