/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.biz.control;

import com.posdata.glue.PosException;
import com.posdata.glue.biz.control.PosService;
import com.posdata.glue.cache.PosCacheManager;
import com.posdata.glue.context.PosContext;
import com.posdata.glue.util.PosFileResourceUtil;
import com.posdata.glue.util.PosGlueUtil;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import com.posdata.glue.util.xml.PosXMLUtil;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PosServiceLoader {
    private String a = "service";
    private boolean b = false;
    private Map c;
    protected PosLog log = PosLogFactory.getLogger(this.getClass());

    private Map loadServiceFilePaths() {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        try {
            URL uRL = PosFileResourceUtil.getResource(this.a);
            String string = uRL.getPath();
            string = URLDecoder.decode(string, "UTF-8");
            this.log.logInfo("Service file root path: " + string);
            List list = PosGlueUtil.getListOfFiles(new File(string));
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                File file = (File)list.get(n2);
                hashMap.put(file.getName(), file);
                ++n2;
            }
            this.log.logInfo("Service files path: " + ((Object)hashMap).toString());
        }
        catch (Exception exception) {
            this.log.logWarn("Fail to collect service file path: " + exception.getMessage());
        }
        return hashMap;
    }

    public PosService findService(String string) {
        PosCacheManager posCacheManager = (PosCacheManager)PosContext.getBeanFactory().getBeanObject("cacheManager");
        PosService posService = (PosService)posCacheManager.getCacheObject(string);
        if (posService == null) {
            posService = this.loadService(string);
            posCacheManager.putCacheObject(posService.getServicName(), posService);
        }
        return posService;
    }

    protected synchronized PosService loadService(String string) {
        PosService posService = null;
        try {
            Object object;
            PosXMLUtil posXMLUtil = new PosXMLUtil();
            Map map = null;
            if (this.b) {
                object = (File)this.c.get(String.valueOf(string) + ".xml");
                map = posXMLUtil.loadXMLFile((File)object);
            } else {
                map = posXMLUtil.loadXMLFromClasspath("service" + File.separator + string + ".xml");
            }
            posService = new PosService(map);
            object = posService.getServicName();
            if (!((String)object).equals(string)) {
                throw new PosException("ServiceName in XML File [" + (String)object + "] and Service Name[" + string + "] is different ");
            }
        }
        catch (Exception exception) {
            throw new PosException(exception.getMessage(), exception);
        }
        return posService;
    }

    public boolean isScanSubDir() {
        return this.b;
    }

    public void setScanSubDir(boolean bl) {
        if (bl) {
            this.c = this.loadServiceFilePaths();
        }
        this.b = bl;
    }

    public String getRootPath() {
        return this.a;
    }

    public void setRootPath(String string) {
        this.a = string;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"nonuitest-service", "ZDJ007R1-service"};
        String[] stringArray3 = new String[]{"2EmpService", "11EmpService", "3EmpService"};
        PosServiceLoader posServiceLoader = new PosServiceLoader();
        posServiceLoader.setRootPath("service");
        posServiceLoader.setScanSubDir(true);
        int n = stringArray3.length;
        int n2 = 0;
        while (n2 < n) {
            PosService posService = posServiceLoader.loadService(stringArray3[n2]);
            posServiceLoader.log.logDebug(posService.getServicName());
            ++n2;
        }
    }
}

