/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.dao.manager;

import com.posdata.glue.cache.PosCacheManager;
import com.posdata.glue.context.PosContext;
import com.posdata.glue.dao.PosStatementCreatorUtils;
import com.posdata.glue.dao.vo.PosColumnDef;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

public class PosColumnManager {
    protected static String REGION_NAME = "_column-region";
    private PosCacheManager a;
    private PosColumnDef[] b = new PosColumnDef[1];
    protected PosLog log = PosLogFactory.getLogger(this.getClass());

    public PosColumnManager() {
        this.b[0] = new PosColumnDef("default", 0, 0);
        try {
            this.a = (PosCacheManager)PosContext.getBeanFactory().getBeanObject("cacheManager");
        }
        catch (Exception exception) {
            this.log.logWarn("Plz check a cache manager bean ID in applicationContext.xml: " + exception.getMessage(), exception);
        }
    }

    public PosColumnDef[] getColumnDefinition(DataSource dataSource, String string, Object[] objectArray) {
        return this.a == null ? this.b : this.searchColumnDefinition(dataSource, string, objectArray);
    }

    protected PosColumnDef[] searchColumnDefinition(DataSource dataSource, String string, Object[] objectArray) {
        PosColumnDef[] posColumnDefArray = this.a.getCacheObject(string, REGION_NAME);
        if (posColumnDefArray == null) {
            posColumnDefArray = this.createColumnDefinition(dataSource, string, objectArray);
            this.a.putCacheObject(string, posColumnDefArray, REGION_NAME);
        }
        return posColumnDefArray;
    }

    protected PosColumnDef[] createColumnDefinition(DataSource dataSource, String string, Object[] objectArray) {
        PosColumnDef[] posColumnDefArray;
        block9: {
            posColumnDefArray = null;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            PosArgPreparedStatementSetter posArgPreparedStatementSetter = null;
            try {
                try {
                    connection = DataSourceUtils.getConnection((DataSource)dataSource);
                    preparedStatement = connection.prepareStatement(string);
                    if (objectArray != null && objectArray.length > 0) {
                        posArgPreparedStatementSetter = new PosArgPreparedStatementSetter(objectArray);
                        posArgPreparedStatementSetter.setValues(preparedStatement);
                    }
                    resultSet = preparedStatement.executeQuery();
                    posColumnDefArray = this.createColumnDefinition(resultSet);
                }
                catch (Exception exception) {
                    this.log.logWarn("Cannot create Column Definition: " + exception.getMessage(), exception);
                    posColumnDefArray = this.b;
                    if (posArgPreparedStatementSetter != null) {
                        posArgPreparedStatementSetter.cleanupParameters();
                    }
                    JdbcUtils.closeResultSet((ResultSet)resultSet);
                    JdbcUtils.closeStatement((Statement)preparedStatement);
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (posArgPreparedStatementSetter != null) {
                    posArgPreparedStatementSetter.cleanupParameters();
                }
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement((Statement)preparedStatement);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
                throw throwable;
            }
            if (posArgPreparedStatementSetter != null) {
                posArgPreparedStatementSetter.cleanupParameters();
            }
            JdbcUtils.closeResultSet((ResultSet)resultSet);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
        return posColumnDefArray;
    }

    protected PosColumnDef[] createColumnDefinition(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        PosColumnDef[] posColumnDefArray = new PosColumnDef[n];
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            String string = resultSetMetaData.getColumnName(n3);
            int n4 = resultSetMetaData.getColumnType(n3);
            int n5 = resultSetMetaData.getColumnDisplaySize(n3);
            posColumnDefArray[n2] = new PosColumnDef(string, n4, n5);
            ++n2;
            ++n3;
        }
        return posColumnDefArray;
    }

    private static class PosArgPreparedStatementSetter
    implements PreparedStatementSetter,
    ParameterDisposer {
        private final Object[] a;

        public PosArgPreparedStatementSetter(Object[] objectArray) {
            this.a = objectArray;
        }

        public void setValues(PreparedStatement preparedStatement) throws SQLException {
            if (this.a != null) {
                int n = 0;
                while (n < this.a.length) {
                    PosStatementCreatorUtils.setParameterValue(preparedStatement, n + 1, Integer.MIN_VALUE, null, this.a[n]);
                    ++n;
                }
            }
        }

        public void cleanupParameters() {
            PosStatementCreatorUtils.cleanupParameters((Object[])this.a);
        }
    }
}

