/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.dao.manager;

import com.posdata.glue.cache.PosCacheLoader;
import com.posdata.glue.cache.PosCacheManager;
import com.posdata.glue.dao.manager.PosQueryDefinition;
import com.posdata.glue.dao.manager.PosQueryManager;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.util.Iterator;
import java.util.Map;

public class PosQueryManagerImpl
implements PosQueryManager {
    protected static final String REGION = "_sql-region";
    protected static final String KEY = "queryDef";
    protected PosCacheManager cacheManager;
    protected PosCacheLoader queryLoader;
    protected Object syncLock = new Object();
    protected boolean isLoaded = false;
    protected PosLog log = PosLogFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PosQueryManagerImpl(PosCacheManager posCacheManager, PosCacheLoader posCacheLoader) {
        this.cacheManager = posCacheManager;
        this.queryLoader = posCacheLoader;
        Object object = this.syncLock;
        synchronized (object) {
            block9: {
                if (!this.isLoaded) {
                    try {
                        try {
                            this.loadAllQueryDefinitions();
                        }
                        catch (Throwable throwable) {
                            this.log.logFatal("Fail to load query definitions: " + throwable.getMessage(), throwable);
                            this.isLoaded = true;
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.isLoaded = true;
                        throw throwable;
                    }
                    this.isLoaded = true;
                }
            }
        }
    }

    public void setCacheManager(PosCacheManager posCacheManager) {
        this.cacheManager = posCacheManager;
    }

    public void setCacheLoader(PosCacheLoader posCacheLoader) {
        this.queryLoader = posCacheLoader;
    }

    public PosQueryDefinition getQueryDefinition(String string) {
        Object object = this.cacheManager.getCacheObject(string, REGION);
        return (PosQueryDefinition)object;
    }

    protected void loadAllQueryDefinitions() {
        Map map = (Map)this.queryLoader.loadCacheObject(KEY, REGION);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object object = this.cacheManager.getCacheObject(k, REGION);
            if (object != null) {
                this.log.logFatal("The Key [" + k + "] is duplicated!");
                continue;
            }
            this.cacheManager.putCacheObject(k, map.get(k), REGION);
        }
    }
}

