/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.msg.util;

import com.posdata.glue.PosException;
import com.posdata.glue.component.PosMessageCreatorException;
import com.posdata.glue.component.PosMessageParserException;
import com.posdata.glue.context.PosContext;
import com.posdata.glue.msg.PosMESMessageImpl;
import com.posdata.glue.msg.PosMessage;
import com.posdata.glue.msg.PosMessageAttributeDefinition;
import com.posdata.glue.util.PosGlueUtil;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PosMessageUtil {
    private static PosLog b;
    static Class a;

    static {
        Class<?> clazz = a;
        if (clazz == null) {
            try {
                clazz = a = Class.forName("com.posdata.glue.msg.util.PosMessageUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        b = PosLogFactory.getLogger(clazz);
    }

    public static String convertMsgToString(String string, int n) {
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        return string;
    }

    public static char[] getCharacters(char c, int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = c;
            ++n2;
        }
        return cArray;
    }

    public static String cutString(String string, int n) {
        return string.substring(0, n);
    }

    public static String cutByteString(String string, int n) {
        byte[] byArray = string.getBytes();
        String string2 = new String(byArray, 0, n);
        return string2;
    }

    public static int getIntFromString(String string) {
        if (string != null && !string.equals("")) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    public static String rightTrim(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = string.length();
        while (n > 0 && cArray[n - 1] <= ' ') {
            --n;
        }
        return string.substring(0, n);
    }

    public static String substringByte(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        if (byArray == null || n3 == 0) {
            return "";
        }
        if (n >= 0 && n <= n2 && n2 <= n3) {
            String string = "";
            string = new String(byArray, n, n2 - n);
            if (string.length() == 0 && n2 != n) {
                string = PosMessageUtil.substringByte(byArray, n, n2 - 1);
            }
            return string;
        }
        return "";
    }

    public static String substringByte(String string, int n, int n2) {
        byte[] byArray = string.getBytes();
        return PosMessageUtil.substringByte(byArray, n, n2);
    }

    public static String convertDateToString(Timestamp timestamp, int n) {
        SimpleDateFormat simpleDateFormat = null;
        switch (n) {
            case 14: {
                simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                break;
            }
            case 12: {
                simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                break;
            }
            case 10: {
                simpleDateFormat = new SimpleDateFormat("yyyyMMddHH");
                break;
            }
            case 8: {
                simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                break;
            }
            case 6: {
                simpleDateFormat = new SimpleDateFormat("yyyyMM");
                break;
            }
            case 4: {
                simpleDateFormat = new SimpleDateFormat("yyyy");
                break;
            }
            default: {
                return PosMessageUtil.convertMsgToString("", n);
            }
        }
        if (b.isDebugEnabled()) {
            b.logDebug("date.toString()=" + timestamp.toString());
        }
        return simpleDateFormat.format(timestamp);
    }

    public static String getStringFromNumber(BigDecimal bigDecimal, int n, int n2) {
        Object object;
        if (b.isDebugEnabled()) {
            b.logDebug("Original Number  :: " + bigDecimal.toString());
            object = bigDecimal.setScale(n2, 1);
            b.logDebug("Truncat Number  :: " + object);
        }
        object = "";
        try {
            int n3;
            if (bigDecimal != null) {
                if (n2 > 0) {
                    bigDecimal = bigDecimal.setScale(n2, 1).movePointRight(n2);
                    if (b.isDebugEnabled()) {
                        b.logDebug("Tru&Shi Number  :: " + bigDecimal);
                    }
                }
                object = bigDecimal.toString();
            }
            if ((n3 = ((String)object).length()) > n) {
                object = ((String)object).substring(0, n);
            } else if (n3 < n) {
                object = bigDecimal.longValue() >= 0L ? String.valueOf(new String(PosMessageUtil.getCharacters('0', n - n3))) + (String)object : String.valueOf(new String(PosMessageUtil.getCharacters('-', 1))) + new String(PosMessageUtil.getCharacters('0', n - n3)) + ((String)object).substring(1);
            }
            if (b.isDebugEnabled()) {
                b.logDebug("getStringFromNumber() value=" + (String)object);
            }
        }
        catch (Exception exception) {
            throw new PosMessageCreatorException("Number message creation error", exception);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date convertStringToDate(String string) throws PosException {
        Timestamp timestamp = null;
        try {
            SimpleDateFormat simpleDateFormat = null;
            switch (string.length()) {
                case 14: {
                    simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    break;
                }
                case 12: {
                    simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                    break;
                }
                case 10: {
                    simpleDateFormat = new SimpleDateFormat("yyyyMMddHH");
                    break;
                }
                case 8: {
                    simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                    break;
                }
                case 6: {
                    simpleDateFormat = new SimpleDateFormat("yyyyMM");
                    break;
                }
                case 4: {
                    simpleDateFormat = new SimpleDateFormat("yyyy");
                    break;
                }
                case 0: {
                    return null;
                }
                default: {
                    throw new PosMessageParserException(String.valueOf(string) + " is unknown size format");
                }
            }
            simpleDateFormat.setLenient(false);
            return new Timestamp(simpleDateFormat.parse(string).getTime());
        }
        catch (Exception exception) {
            throw new PosMessageParserException("Error occurrence while convertStringToDate() method accomplishing!!" + exception.getMessage(), exception);
        }
    }

    public static Object getSource(Object object, String string) {
        if (object != null && object instanceof List) {
            List list = (List)object;
            int n = 0;
            while (n < list.size()) {
                if (Integer.parseInt(string) == n) {
                    return list.get(n);
                }
                ++n;
            }
        } else if (object != null && object instanceof Map) {
            Map map = (Map)object;
            return map.get(string);
        }
        return null;
    }

    public static boolean isList(Object object) {
        return object != null && object instanceof List;
    }

    public static String getToString(String string, String string2, int n) {
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string2) + string;
            ++n2;
        }
        return string;
    }

    public static String getMsgString(PosMessageAttributeDefinition posMessageAttributeDefinition, PosMessage posMessage, int n) {
        String string = "";
        String string2 = posMessageAttributeDefinition.getId();
        int n2 = posMessageAttributeDefinition.getLength();
        String string3 = null;
        if (posMessageAttributeDefinition.getType().equals("GE")) {
            String string4 = String.valueOf(string2) + String.valueOf(n);
            if (posMessage.get(string4) == null) {
                if (posMessage.get(string2) != null) {
                    string3 = (String)((ArrayList)posMessage.get(string2)).get(n);
                }
            } else if (posMessage.get(string4) != null) {
                string3 = (String)posMessage.get(string4);
            }
        } else if (posMessage.get(string2) != null) {
            string3 = (String)posMessage.get(string2);
        }
        string = string3 == null ? PosMessageUtil.convertMsgToString("", n2) : (n2 > string3.length() ? PosMessageUtil.convertMsgToString(string3, n2 - string3.length()) : (n2 < string3.length() ? PosMessageUtil.cutString(string3, n2) : string3));
        return string;
    }

    public static String getByteMsgString(PosMessageAttributeDefinition posMessageAttributeDefinition, PosMessage posMessage, int n) {
        int n2;
        Object object;
        String string = "";
        String string2 = posMessageAttributeDefinition.getId();
        int n3 = posMessageAttributeDefinition.getLength();
        String string3 = null;
        if (posMessageAttributeDefinition.getType().equals("GE")) {
            object = String.valueOf(string2) + String.valueOf(n);
            if (posMessage.get((String)object) == null) {
                if (posMessage.get(string2) != null) {
                    string3 = (String)((ArrayList)posMessage.get(string2)).get(n);
                }
            } else if (posMessage.get((String)object) != null) {
                string3 = (String)posMessage.get((String)object);
            }
        } else if (posMessage.get(string2) != null) {
            string3 = (String)posMessage.get(string2);
        }
        string = string3 == null ? PosMessageUtil.convertMsgToString("", n3) : (n3 > (n2 = ((byte[])(object = string3.getBytes())).length) ? PosMessageUtil.convertMsgToString(string3, n3 - n2) : (n3 < n2 ? PosMessageUtil.cutByteString(string3, n3) : string3));
        return string;
    }

    public static String getMsgNumber(PosMessageAttributeDefinition posMessageAttributeDefinition, PosMessage posMessage, int n) {
        String string = "";
        String string2 = posMessageAttributeDefinition.getId();
        int n2 = posMessageAttributeDefinition.getLength();
        BigDecimal bigDecimal = null;
        try {
            if (posMessageAttributeDefinition.getType().equals("GE")) {
                String string3 = String.valueOf(string2) + String.valueOf(n);
                if (posMessage.get(string3) == null) {
                    if (posMessage.get(string2) != null && ((ArrayList)posMessage.get(string2)).get(n) != null) {
                        bigDecimal = (BigDecimal)((ArrayList)posMessage.get(string2)).get(n);
                    }
                } else if (posMessage.get(string3) != null) {
                    bigDecimal = (BigDecimal)posMessage.get(string3);
                }
            } else if (posMessage.get(string2) != null) {
                bigDecimal = (BigDecimal)posMessage.get(string2);
            }
        }
        catch (Exception exception) {
            throw new PosMessageCreatorException("It is Wrong Number : Message Attribute-" + string2 + ", Message Atttribute Value=" + posMessage.get(string2), exception);
        }
        if (bigDecimal == null) {
            string = PosMessageUtil.convertMsgToString("", n2);
        } else {
            try {
                string = PosMessageUtil.getStringFromNumber(bigDecimal, n2, posMessageAttributeDefinition.getPrecision());
            }
            catch (PosMessageCreatorException posMessageCreatorException) {
                throw new PosMessageCreatorException("Number message creation error : Message Attribute-" + string2 + ", Message Atttribute Value=" + posMessage.get(string2), posMessageCreatorException);
            }
            catch (Exception exception) {
                throw new PosMessageCreatorException("Number message creation error : Message Attribute-" + string2 + ", Message Atttribute Value=" + posMessage.get(string2), exception);
            }
        }
        return string;
    }

    public static String getMsgDate(PosMessageAttributeDefinition posMessageAttributeDefinition, PosMessage posMessage, int n) {
        String string = "";
        String string2 = posMessageAttributeDefinition.getId();
        int n2 = posMessageAttributeDefinition.getLength();
        Timestamp timestamp = null;
        try {
            if (posMessageAttributeDefinition.getType().equals("GE")) {
                String string3 = String.valueOf(string2) + String.valueOf(n);
                if (posMessage.get(string3) == null) {
                    if (posMessage.get(string2) != null && ((ArrayList)posMessage.get(string2)).get(n) != null) {
                        timestamp = (Timestamp)((ArrayList)posMessage.get(string2)).get(n);
                    }
                } else if (posMessage.get(string3) != null) {
                    timestamp = (Timestamp)posMessage.get(string3);
                }
            } else if (posMessage.get(string2) != null) {
                timestamp = (Timestamp)posMessage.get(string2);
            }
        }
        catch (Exception exception) {
            throw new PosMessageCreatorException("It is Wrong Date : Message Attribute-" + string2 + ", Message Atttribute Value=" + posMessage.get(string2), exception);
        }
        string = timestamp == null ? PosMessageUtil.convertMsgToString("", n2) : PosMessageUtil.convertDateToString(timestamp, n2);
        return string;
    }

    public static PosMessage readFile(String string) throws PosMessageParserException {
        PosMESMessageImpl posMESMessageImpl = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string2;
                File file = new File(string);
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                ArrayList<String> arrayList = new ArrayList<String>();
                while ((string2 = bufferedReader.readLine()) != null && string2.trim().length() != 0) {
                    arrayList.add(string2);
                }
                posMESMessageImpl = new PosMESMessageImpl();
                posMESMessageImpl.setTC((String)arrayList.get(0));
            }
            catch (Exception exception) {
                throw new PosException("File Message is not read. - " + exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            PosGlueUtil.closeReader(bufferedReader);
            PosGlueUtil.closeReader(inputStreamReader);
            PosGlueUtil.closeInputStream(fileInputStream);
            throw throwable;
        }
        PosGlueUtil.closeReader(bufferedReader);
        PosGlueUtil.closeReader(inputStreamReader);
        PosGlueUtil.closeInputStream(fileInputStream);
        return posMESMessageImpl;
    }

    public static PosContext readFile(PosContext posContext) throws PosMessageParserException {
        PosMessage[] posMessageArray = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string;
                File file = new File(posContext.getMessagesFileName());
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                ArrayList<String> arrayList = new ArrayList<String>();
                while ((string = bufferedReader.readLine()) != null && string.trim().length() != 0) {
                    arrayList.add(string);
                }
                posMessageArray = new PosMessage[arrayList.size()];
                int n = 0;
                while (n < arrayList.size()) {
                    posMessageArray[n] = new PosMESMessageImpl();
                    posMessageArray[n].setTC((String)arrayList.get(n));
                    if (b.isDebugEnabled()) {
                        b.logDebug("File Message read - " + arrayList.get(n));
                    }
                    ++n;
                }
                posContext.setMessages(posMessageArray);
            }
            catch (Exception exception) {
                throw new PosException("File Message is not read. - " + exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            PosGlueUtil.closeReader(bufferedReader);
            PosGlueUtil.closeReader(inputStreamReader);
            PosGlueUtil.closeInputStream(fileInputStream);
            throw throwable;
        }
        PosGlueUtil.closeReader(bufferedReader);
        PosGlueUtil.closeReader(inputStreamReader);
        PosGlueUtil.closeInputStream(fileInputStream);
        return posContext;
    }

    public static PosContext createFile(PosContext posContext) throws PosMessageCreatorException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                File file = null;
                PosMessage[] posMessageArray = posContext.getMessages();
                String string = String.valueOf(PosContext.getConfigPath()) + File.separator + PosContext.getGlueProperty("chainCode") + "FileMsg" + File.separator;
                File file2 = new File(string);
                if (!file2.isDirectory()) {
                    file2.mkdirs();
                }
                String string2 = String.valueOf(string) + posMessageArray[0].getTCID() + ".txt";
                file = new File(string2);
                fileOutputStream = new FileOutputStream(file);
                int n = 0;
                while (n < posMessageArray.length) {
                    fileOutputStream.write(posMessageArray[n].getTC().getBytes());
                    fileOutputStream.write("\n".getBytes());
                    ++n;
                }
                fileOutputStream.close();
                posContext.setMessagesFileName(string2);
            }
            catch (Exception exception) {
                throw new PosMessageCreatorException("Creating File is error!!" + exception.getMessage(), exception);
            }
        }
        catch (Throwable throwable) {
            PosGlueUtil.closeOutputStream(fileOutputStream);
            throw throwable;
        }
        PosGlueUtil.closeOutputStream(fileOutputStream);
        return posContext;
    }
}

