/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.scheduling.server;

import com.posdata.glue.scheduling.remote.PosJobDefinition;
import com.posdata.glue.scheduling.remote.PosJobEventReceiver;
import com.posdata.glue.scheduling.server.PosHttpRequestMessage;
import com.posdata.glue.scheduling.server.PosHttpResponseMessage;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.SessionLog;

public class PosGlueServerHandler
extends IoHandlerAdapter {
    public static final int DEFAULT_IDLE_TIME = 60;
    protected static final String PARAM_HEADER = "@jobParam-";
    protected PosLog log = PosLogFactory.getLogger(((Object)((Object)this)).getClass());
    private PosJobEventReceiver a;

    public PosGlueServerHandler() {
    }

    public PosGlueServerHandler(PosJobEventReceiver posJobEventReceiver) {
        this.a = posJobEventReceiver;
    }

    public void sessionOpened(IoSession ioSession) {
        ioSession.setIdleTime(IdleStatus.BOTH_IDLE, 60);
    }

    protected void loggingRequestMessage(IoSession ioSession, Object object) {
        String string;
        PosHttpRequestMessage posHttpRequestMessage;
        Set set = ioSession.getAttributeKeys();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            posHttpRequestMessage = iterator.next();
            string = posHttpRequestMessage != null ? ((Object)posHttpRequestMessage).toString() : null;
            this.log.logInfo(new StringBuffer(200).append("session attr: key[").append(string).append("], value[").append(ioSession.getAttribute(string)).append("]"));
        }
        posHttpRequestMessage = (PosHttpRequestMessage)object;
        iterator = posHttpRequestMessage.getHeaders().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!string.startsWith("@")) continue;
            string = string.substring(1);
            this.log.logDebug(new StringBuffer(200).append("request param: key[").append(string).append("], value[").append(posHttpRequestMessage.getParameter(string)).append("]"));
        }
    }

    protected String executeJob(PosJobDefinition posJobDefinition) {
        return this.a.receiveJobEvent(posJobDefinition);
    }

    protected PosJobDefinition createJobDefinition(PosHttpRequestMessage posHttpRequestMessage) {
        String string;
        String string2 = posHttpRequestMessage.getParameter("request_id");
        String string3 = posHttpRequestMessage.getParameter("job_name");
        PosJobDefinition posJobDefinition = new PosJobDefinition(string2, string3);
        posJobDefinition.setClientIp(posHttpRequestMessage.getParameter("client_ip"));
        Map map = posHttpRequestMessage.getHeaders();
        Iterator iterator = map.keySet().iterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!string.startsWith(PARAM_HEADER)) continue;
            Object object = map.get(string);
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                object = stringArray.length == 0 ? "" : stringArray[0];
            }
            try {
                string = string.replaceAll(PARAM_HEADER, "");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.log.logWarn("Cannot convert key [" + string + "]");
                this.log.logWarn(stringIndexOutOfBoundsException.getMessage());
            }
            hashMap.put(string, object);
        }
        string = (String)hashMap.get("_user_id_");
        if (string == null || "".equals(string)) {
            hashMap.put("_user_id_", "Anonymous");
        }
        posJobDefinition.setParameters(hashMap);
        this.log.logInfo("JobDefinition Parameters :" + hashMap);
        return posJobDefinition;
    }

    public void messageReceived(IoSession ioSession, Object object) {
        if (this.log.isDebugEnabled()) {
            this.loggingRequestMessage(ioSession, object);
        }
        PosHttpResponseMessage posHttpResponseMessage = new PosHttpResponseMessage();
        posHttpResponseMessage.setContentType("text/plain");
        try {
            PosJobDefinition posJobDefinition = this.createJobDefinition((PosHttpRequestMessage)object);
            this.executeJob(posJobDefinition);
            posHttpResponseMessage.setResponseCode(700);
            posHttpResponseMessage.appendBody("SUCCESS");
        }
        catch (Exception exception) {
            this.log.logError("Fail to execute Job :" + exception.getMessage(), exception);
            posHttpResponseMessage.setResponseCode(800);
            posHttpResponseMessage.appendBody("FAILURE");
        }
        if (posHttpResponseMessage != null) {
            ioSession.write((Object)posHttpResponseMessage).join();
        }
    }

    public void setJobEvent(PosJobEventReceiver posJobEventReceiver) {
        this.a = posJobEventReceiver;
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
        SessionLog.info((IoSession)ioSession, (String)"Disconnecting the idle.");
        ioSession.close();
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        SessionLog.info((IoSession)ioSession, (String)("exception caught -> " + throwable.getMessage()));
        ioSession.close();
    }
}

