/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.scheduling.store;

import com.posdata.glue.bean.PosBeanFactory;
import com.posdata.glue.context.PosContext;
import com.posdata.glue.scheduling.PosJobDetail;
import com.posdata.glue.scheduling.store.PosJobWrapper;
import com.posdata.glue.scheduling.store.PosTriggerComparator;
import com.posdata.glue.scheduling.store.PosTriggerWrapper;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;

public class PosMemoryJobStore
implements JobStore {
    protected HashMap jobsByFQN = new HashMap(1000);
    protected HashMap triggersByFQN = new HashMap(1000);
    protected HashMap jobsByGroup = new HashMap(25);
    protected HashMap triggersByGroup = new HashMap(25);
    protected TreeSet timeTriggers = new TreeSet(new PosTriggerComparator());
    protected HashMap calendarsByName = new HashMap(25);
    protected ArrayList triggers = new ArrayList(1000);
    protected Object jobLock = new Object();
    protected Object triggerLock = new Object();
    protected HashSet pausedTriggerGroups = new HashSet();
    protected HashSet blockedJobs = new HashSet();
    protected long misfireThreshold = 5000L;
    protected SchedulerSignaler signaler;
    protected PosLog log = PosLogFactory.getLogger(this.getClass());
    protected PosBeanFactory beanFactory = PosContext.getBeanFactory();
    private static long b = System.currentTimeMillis();
    static Class a;

    protected Log getLog() {
        Class<?> clazz = a;
        if (clazz == null) {
            try {
                clazz = a = Class.forName("com.posdata.glue.scheduling.store.PosMemoryJobStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return LogFactory.getLog((Class)clazz);
    }

    public void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) {
        this.signaler = schedulerSignaler;
        this.getLog().info((Object)"PosMemoryJobStore initialized.");
    }

    public void schedulerStarted() throws SchedulerException {
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
        }
        this.misfireThreshold = l;
    }

    public void shutdown() {
    }

    public boolean supportsPersistence() {
        return false;
    }

    public void storeJobAndTrigger(SchedulingContext schedulingContext, JobDetail jobDetail, Trigger trigger) throws JobPersistenceException {
        this.storeJob(schedulingContext, jobDetail, false);
        this.storeTrigger(schedulingContext, trigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJob(SchedulingContext schedulingContext, JobDetail jobDetail, boolean bl) throws ObjectAlreadyExistsException {
        PosJobWrapper posJobWrapper = new PosJobWrapper(jobDetail);
        boolean bl2 = false;
        if (this.jobsByFQN.get(posJobWrapper.key) != null) {
            if (!bl) {
                throw new ObjectAlreadyExistsException(jobDetail);
            }
            bl2 = true;
        }
        Object object = this.jobLock;
        synchronized (object) {
            if (!bl2) {
                HashMap<String, PosJobWrapper> hashMap = (HashMap<String, PosJobWrapper>)this.jobsByGroup.get(jobDetail.getGroup());
                if (hashMap == null) {
                    hashMap = new HashMap<String, PosJobWrapper>(100);
                    this.jobsByGroup.put(jobDetail.getGroup(), hashMap);
                }
                hashMap.put(jobDetail.getName(), posJobWrapper);
                this.jobsByFQN.put(posJobWrapper.key, posJobWrapper);
            } else {
                PosJobWrapper posJobWrapper2 = (PosJobWrapper)this.jobsByFQN.get(posJobWrapper.key);
                posJobWrapper2.jobDetail = jobDetail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(SchedulingContext schedulingContext, String string, String string2) {
        Object object;
        String string3 = PosJobWrapper.getJobNameKey(string, string2);
        boolean bl = false;
        Trigger[] triggerArray = this.getTriggersForJob(schedulingContext, string, string2);
        int n = 0;
        while (n < triggerArray.length) {
            object = triggerArray[n];
            this.removeTrigger(schedulingContext, object.getName(), object.getGroup());
            bl = true;
            ++n;
        }
        Object object2 = this.jobLock;
        synchronized (object2) {
            bl = this.jobsByFQN.remove(string3) != null | bl;
            if (bl && (object = (HashMap)this.jobsByGroup.get(string2)) != null) {
                ((HashMap)object).remove(string);
                if (((HashMap)object).size() == 0) {
                    this.jobsByGroup.remove(string2);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTrigger(SchedulingContext schedulingContext, Trigger trigger, boolean bl) throws JobPersistenceException {
        PosTriggerWrapper posTriggerWrapper = new PosTriggerWrapper(trigger);
        if (this.triggersByFQN.get(posTriggerWrapper.key) != null) {
            if (!bl) {
                throw new ObjectAlreadyExistsException(trigger);
            }
            this.removeTrigger(schedulingContext, trigger.getName(), trigger.getGroup());
        }
        if (this.retrieveJob(schedulingContext, trigger.getJobName(), trigger.getJobGroup()) == null) {
            throw new JobPersistenceException("The job (" + trigger.getFullJobName() + ") referenced by the trigger does not exist.");
        }
        Object object = this.triggerLock;
        synchronized (object) {
            this.triggers.add(posTriggerWrapper);
            HashMap<String, PosTriggerWrapper> hashMap = (HashMap<String, PosTriggerWrapper>)this.triggersByGroup.get(trigger.getGroup());
            if (hashMap == null) {
                hashMap = new HashMap<String, PosTriggerWrapper>(100);
                this.triggersByGroup.put(trigger.getGroup(), hashMap);
            }
            hashMap.put(trigger.getName(), posTriggerWrapper);
            this.triggersByFQN.put(posTriggerWrapper.key, posTriggerWrapper);
            HashSet hashSet = this.pausedTriggerGroups;
            synchronized (hashSet) {
                if (this.pausedTriggerGroups.contains(trigger.getGroup())) {
                    posTriggerWrapper.state = 4;
                    if (this.blockedJobs.contains(posTriggerWrapper.jobKey)) {
                        posTriggerWrapper.state = 6;
                    }
                } else if (this.blockedJobs.contains(posTriggerWrapper.jobKey)) {
                    posTriggerWrapper.state = 5;
                } else {
                    this.timeTriggers.add(posTriggerWrapper);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTrigger(SchedulingContext schedulingContext, String string, String string2) {
        String string3 = PosTriggerWrapper.a(string, string2);
        boolean bl = false;
        Object object = this.triggerLock;
        synchronized (object) {
            boolean bl2 = bl = this.triggersByFQN.remove(string3) != null;
            if (bl) {
                PosTriggerWrapper posTriggerWrapper = null;
                HashMap hashMap = (HashMap)this.triggersByGroup.get(string2);
                if (hashMap != null) {
                    hashMap.remove(string);
                    if (hashMap.size() == 0) {
                        this.triggersByGroup.remove(string2);
                    }
                }
                Iterator iterator = this.triggers.iterator();
                while (iterator.hasNext()) {
                    posTriggerWrapper = (PosTriggerWrapper)iterator.next();
                    if (!string3.equals(posTriggerWrapper.key)) continue;
                    iterator.remove();
                    break;
                }
                this.timeTriggers.remove(posTriggerWrapper);
                PosJobWrapper posJobWrapper = (PosJobWrapper)this.jobsByFQN.get(PosJobWrapper.getJobNameKey(posTriggerWrapper.trigger.getJobName(), posTriggerWrapper.trigger.getJobGroup()));
                Trigger[] triggerArray = this.getTriggersForJob(schedulingContext, posTriggerWrapper.trigger.getJobName(), posTriggerWrapper.trigger.getJobGroup());
                if (!(triggerArray != null && triggerArray.length != 0 || posJobWrapper.jobDetail.isDurable())) {
                    this.removeJob(schedulingContext, posTriggerWrapper.trigger.getJobName(), posTriggerWrapper.trigger.getJobGroup());
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceTrigger(SchedulingContext schedulingContext, String string, String string2, Trigger trigger) throws JobPersistenceException {
        String string3 = PosTriggerWrapper.a(string, string2);
        boolean bl = false;
        Object object = this.triggerLock;
        synchronized (object) {
            PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.remove(string3);
            boolean bl2 = bl = posTriggerWrapper != null;
            if (bl) {
                if (!posTriggerWrapper.getTrigger().getJobName().equals(trigger.getJobName()) || !posTriggerWrapper.getTrigger().getJobGroup().equals(trigger.getJobGroup())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
                }
                posTriggerWrapper = null;
                HashMap hashMap = (HashMap)this.triggersByGroup.get(string2);
                if (hashMap != null) {
                    hashMap.remove(string);
                    if (hashMap.size() == 0) {
                        this.triggersByGroup.remove(string2);
                    }
                }
                Iterator iterator = this.triggers.iterator();
                while (iterator.hasNext()) {
                    posTriggerWrapper = (PosTriggerWrapper)iterator.next();
                    if (!string3.equals(posTriggerWrapper.key)) continue;
                    iterator.remove();
                    break;
                }
                this.timeTriggers.remove(posTriggerWrapper);
                try {
                    this.storeTrigger(schedulingContext, trigger, false);
                }
                catch (JobPersistenceException jobPersistenceException) {
                    this.storeTrigger(schedulingContext, posTriggerWrapper.getTrigger(), false);
                    throw jobPersistenceException;
                }
            }
        }
        return bl;
    }

    public JobDetail retrieveJob(SchedulingContext schedulingContext, String string, String string2) {
        PosJobWrapper posJobWrapper = (PosJobWrapper)this.jobsByFQN.get(PosJobWrapper.getJobNameKey(string, string2));
        if (posJobWrapper != null) {
            return posJobWrapper.jobDetail;
        }
        return null;
    }

    public Trigger retrieveTrigger(SchedulingContext schedulingContext, String string, String string2) {
        PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.get(PosTriggerWrapper.a(string, string2));
        if (posTriggerWrapper != null) {
            return posTriggerWrapper.getTrigger();
        }
        return null;
    }

    public int getTriggerState(SchedulingContext schedulingContext, String string, String string2) throws JobPersistenceException {
        PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.get(PosTriggerWrapper.a(string, string2));
        if (posTriggerWrapper == null) {
            return -1;
        }
        if (posTriggerWrapper.state == 3) {
            return 2;
        }
        if (posTriggerWrapper.state == 4) {
            return 1;
        }
        if (posTriggerWrapper.state == 6) {
            return 1;
        }
        if (posTriggerWrapper.state == 5) {
            return 4;
        }
        if (posTriggerWrapper.state == 7) {
            return 3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCalendar(SchedulingContext schedulingContext, String string, Calendar calendar, boolean bl, boolean bl2) throws ObjectAlreadyExistsException {
        Object v = this.calendarsByName.get(string);
        if (v != null && !bl) {
            throw new ObjectAlreadyExistsException("Calendar with name '" + string + "' already exists.");
        }
        if (v != null) {
            this.calendarsByName.remove(string);
        }
        this.calendarsByName.put(string, calendar);
        if (v != null && bl2) {
            Object object = this.triggerLock;
            synchronized (object) {
                Iterator iterator = this.getTriggerWrappersForCalendar(string).iterator();
                while (iterator.hasNext()) {
                    PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)iterator.next();
                    Trigger trigger = posTriggerWrapper.getTrigger();
                    boolean bl3 = this.timeTriggers.remove(posTriggerWrapper);
                    trigger.updateWithNewCalendar(calendar, this.getMisfireThreshold());
                    if (!bl3) continue;
                    this.timeTriggers.add(posTriggerWrapper);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCalendar(SchedulingContext schedulingContext, String string) throws JobPersistenceException {
        int n = 0;
        Object object = this.triggerLock;
        synchronized (object) {
            Iterator iterator = this.triggers.iterator();
            while (iterator.hasNext()) {
                Trigger trigger = ((PosTriggerWrapper)iterator.next()).trigger;
                if (trigger.getCalendarName() == null || !trigger.getCalendarName().equals(string)) continue;
                ++n;
            }
        }
        if (n > 0) {
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        return this.calendarsByName.remove(string) != null;
    }

    public Calendar retrieveCalendar(SchedulingContext schedulingContext, String string) {
        return (Calendar)this.calendarsByName.get(string);
    }

    public int getNumberOfJobs(SchedulingContext schedulingContext) {
        return this.jobsByFQN.size();
    }

    public int getNumberOfTriggers(SchedulingContext schedulingContext) {
        return this.triggers.size();
    }

    public int getNumberOfCalendars(SchedulingContext schedulingContext) {
        return this.calendarsByName.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobNames(SchedulingContext schedulingContext, String string) {
        String[] stringArray = null;
        HashMap hashMap = (HashMap)this.jobsByGroup.get(string);
        if (hashMap != null) {
            Object object = this.jobLock;
            synchronized (object) {
                stringArray = new String[hashMap.size()];
                int n = 0;
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    PosJobWrapper posJobWrapper = (PosJobWrapper)hashMap.get(string2);
                    if (posJobWrapper == null) continue;
                    stringArray[n++] = posJobWrapper.jobDetail.getName();
                }
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getCalendarNames(SchedulingContext schedulingContext) {
        Set set = this.calendarsByName.keySet();
        return set.toArray(new String[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerNames(SchedulingContext schedulingContext, String string) {
        String[] stringArray = null;
        HashMap hashMap = (HashMap)this.triggersByGroup.get(string);
        if (hashMap != null) {
            Object object = this.triggerLock;
            synchronized (object) {
                stringArray = new String[hashMap.size()];
                int n = 0;
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)hashMap.get(string2);
                    if (posTriggerWrapper == null) continue;
                    stringArray[n++] = posTriggerWrapper.trigger.getName();
                }
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobGroupNames(SchedulingContext schedulingContext) {
        String[] stringArray = null;
        Object object = this.jobLock;
        synchronized (object) {
            stringArray = new String[this.jobsByGroup.size()];
            int n = 0;
            Iterator iterator = this.jobsByGroup.keySet().iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerGroupNames(SchedulingContext schedulingContext) {
        String[] stringArray = null;
        Object object = this.triggerLock;
        synchronized (object) {
            stringArray = new String[this.triggersByGroup.size()];
            int n = 0;
            Iterator iterator = this.triggersByGroup.keySet().iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger[] getTriggersForJob(SchedulingContext schedulingContext, String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string3 = PosJobWrapper.getJobNameKey(string, string2);
        Object object = this.triggerLock;
        synchronized (object) {
            int n = 0;
            while (n < this.triggers.size()) {
                PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggers.get(n);
                if (posTriggerWrapper.jobKey.equals(string3)) {
                    arrayList.add(posTriggerWrapper.trigger.clone());
                }
                ++n;
            }
        }
        return arrayList.toArray(new Trigger[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getTriggerWrappersForJob(String string, String string2) {
        ArrayList<PosTriggerWrapper> arrayList = new ArrayList<PosTriggerWrapper>();
        String string3 = PosJobWrapper.getJobNameKey(string, string2);
        Object object = this.triggerLock;
        synchronized (object) {
            int n = 0;
            while (n < this.triggers.size()) {
                PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggers.get(n);
                if (posTriggerWrapper.jobKey.equals(string3)) {
                    arrayList.add(posTriggerWrapper);
                }
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getTriggerWrappersForCalendar(String string) {
        ArrayList<PosTriggerWrapper> arrayList = new ArrayList<PosTriggerWrapper>();
        Object object = this.triggerLock;
        synchronized (object) {
            int n = 0;
            while (n < this.triggers.size()) {
                PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggers.get(n);
                String string2 = posTriggerWrapper.getTrigger().getCalendarName();
                if (string2 != null && string2.equals(string)) {
                    arrayList.add(posTriggerWrapper);
                }
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTrigger(SchedulingContext schedulingContext, String string, String string2) {
        PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.get(PosTriggerWrapper.a(string, string2));
        if (posTriggerWrapper == null || posTriggerWrapper.trigger == null) {
            return;
        }
        if (posTriggerWrapper.state == 3) {
            return;
        }
        Object object = this.triggerLock;
        synchronized (object) {
            posTriggerWrapper.state = posTriggerWrapper.state == 5 ? 6 : 4;
            this.timeTriggers.remove(posTriggerWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTriggerGroup(SchedulingContext schedulingContext, String string) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            if (this.pausedTriggerGroups.contains(string)) {
                return;
            }
            this.pausedTriggerGroups.add(string);
            String[] stringArray = this.getTriggerNames(schedulingContext, string);
            int n = 0;
            while (n < stringArray.length) {
                this.pauseTrigger(schedulingContext, stringArray[n], string);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJob(SchedulingContext schedulingContext, String string, String string2) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            Trigger[] triggerArray = this.getTriggersForJob(schedulingContext, string, string2);
            int n = 0;
            while (n < triggerArray.length) {
                this.pauseTrigger(schedulingContext, triggerArray[n].getName(), triggerArray[n].getGroup());
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJobGroup(SchedulingContext schedulingContext, String string) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] stringArray = this.getJobNames(schedulingContext, string);
            int n = 0;
            while (n < stringArray.length) {
                Trigger[] triggerArray = this.getTriggersForJob(schedulingContext, stringArray[n], string);
                int n2 = 0;
                while (n2 < triggerArray.length) {
                    this.pauseTrigger(schedulingContext, triggerArray[n2].getName(), triggerArray[n2].getGroup());
                    ++n2;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrigger(SchedulingContext schedulingContext, String string, String string2) {
        PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.get(PosTriggerWrapper.a(string, string2));
        Trigger trigger = posTriggerWrapper.getTrigger();
        if (posTriggerWrapper == null || posTriggerWrapper.trigger == null) {
            return;
        }
        if (posTriggerWrapper.state != 4 && posTriggerWrapper.state != 6) {
            return;
        }
        Object object = this.triggerLock;
        synchronized (object) {
            posTriggerWrapper.state = this.blockedJobs.contains(PosJobWrapper.getJobNameKey(trigger.getJobName(), trigger.getJobGroup())) ? 5 : 0;
            this.applyMisfire(posTriggerWrapper);
            if (posTriggerWrapper.state == 0) {
                this.timeTriggers.add(posTriggerWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTriggerGroup(SchedulingContext schedulingContext, String string) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] stringArray = this.getTriggerNames(schedulingContext, string);
            int n = 0;
            while (n < stringArray.length) {
                this.resumeTrigger(schedulingContext, stringArray[n], string);
                ++n;
            }
            this.pausedTriggerGroups.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJob(SchedulingContext schedulingContext, String string, String string2) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            Trigger[] triggerArray = this.getTriggersForJob(schedulingContext, string, string2);
            int n = 0;
            while (n < triggerArray.length) {
                this.resumeTrigger(schedulingContext, triggerArray[n].getName(), triggerArray[n].getGroup());
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJobGroup(SchedulingContext schedulingContext, String string) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] stringArray = this.getJobNames(schedulingContext, string);
            int n = 0;
            while (n < stringArray.length) {
                Trigger[] triggerArray = this.getTriggersForJob(schedulingContext, stringArray[n], string);
                int n2 = 0;
                while (n2 < triggerArray.length) {
                    this.resumeTrigger(schedulingContext, triggerArray[n2].getName(), triggerArray[n2].getGroup());
                    ++n2;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAll(SchedulingContext schedulingContext) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] stringArray = this.getTriggerGroupNames(schedulingContext);
            int n = 0;
            while (n < stringArray.length) {
                this.pauseTriggerGroup(schedulingContext, stringArray[n]);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll(SchedulingContext schedulingContext) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] stringArray = this.getTriggerGroupNames(schedulingContext);
            int n = 0;
            while (n < stringArray.length) {
                this.resumeTriggerGroup(schedulingContext, stringArray[n]);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyMisfire(PosTriggerWrapper posTriggerWrapper) {
        Date date;
        long l = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            l -= this.getMisfireThreshold();
        }
        if ((date = posTriggerWrapper.trigger.getNextFireTime()).getTime() > l) {
            return false;
        }
        Calendar calendar = null;
        if (posTriggerWrapper.trigger.getCalendarName() != null) {
            calendar = this.retrieveCalendar(null, posTriggerWrapper.trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired(posTriggerWrapper.trigger);
        posTriggerWrapper.trigger.updateAfterMisfire(calendar);
        if (posTriggerWrapper.trigger.getNextFireTime() == null) {
            posTriggerWrapper.state = 3;
            Object object = this.triggerLock;
            synchronized (object) {
                this.timeTriggers.remove(posTriggerWrapper);
            }
        } else if (date.equals(posTriggerWrapper.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    protected synchronized String getFiredTriggerRecordId() {
        return String.valueOf(b++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Trigger acquireNextTrigger(SchedulingContext schedulingContext, long l) {
        PosTriggerWrapper posTriggerWrapper = null;
        Object object = this.triggerLock;
        synchronized (object) {
            while (true) {
                if (posTriggerWrapper != null) {
                    return null;
                }
                try {
                    posTriggerWrapper = (PosTriggerWrapper)this.timeTriggers.first();
                }
                catch (NoSuchElementException noSuchElementException) {
                    return null;
                }
                if (posTriggerWrapper == null) {
                    return null;
                }
                if (posTriggerWrapper.trigger.getNextFireTime() == null) {
                    this.timeTriggers.remove(posTriggerWrapper);
                    posTriggerWrapper = null;
                    continue;
                }
                this.timeTriggers.remove(posTriggerWrapper);
                if (!this.applyMisfire(posTriggerWrapper)) break;
                if (posTriggerWrapper.trigger.getNextFireTime() != null) {
                    this.timeTriggers.add(posTriggerWrapper);
                }
                posTriggerWrapper = null;
            }
            if (posTriggerWrapper.trigger.getNextFireTime().getTime() > l) {
                this.timeTriggers.add(posTriggerWrapper);
                return null;
            }
            posTriggerWrapper.state = 1;
            posTriggerWrapper.trigger.setFireInstanceId(this.getFiredTriggerRecordId());
            return (Trigger)posTriggerWrapper.trigger.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAcquiredTrigger(SchedulingContext schedulingContext, Trigger trigger) {
        Object object = this.triggerLock;
        synchronized (object) {
            PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.get(PosTriggerWrapper.a(trigger));
            if (posTriggerWrapper != null && posTriggerWrapper.state == 1) {
                posTriggerWrapper.state = 0;
                this.timeTriggers.add(posTriggerWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriggerFiredBundle triggerFired(SchedulingContext schedulingContext, Trigger trigger) {
        Object object = this.triggerLock;
        synchronized (object) {
            PosTriggerWrapper posTriggerWrapper;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.get(PosTriggerWrapper.a(trigger));
                                if (this.log.isDebugEnabled()) {
                                    this.log.logDebug(trigger.getJobName());
                                    this.log.logDebug("(FireS)TriigersByFQN:" + this.triggersByFQN);
                                    this.log.logDebug("(FireS)TimeTriggers:" + this.timeTriggers);
                                    this.log.logDebug("(FireS)BlockedJobs:" + this.blockedJobs);
                                }
                                if (posTriggerWrapper != null && posTriggerWrapper.trigger != null) break block22;
                                return null;
                            }
                            if (posTriggerWrapper.state != 3) break block23;
                            return null;
                        }
                        if (posTriggerWrapper.state != 4) break block24;
                        return null;
                    }
                    if (posTriggerWrapper.state != 5) break block25;
                    return null;
                }
                if (posTriggerWrapper.state != 6) break block26;
                return null;
            }
            Calendar calendar = null;
            if (posTriggerWrapper.trigger.getCalendarName() != null) {
                calendar = this.retrieveCalendar(schedulingContext, posTriggerWrapper.trigger.getCalendarName());
            }
            Date date = trigger.getPreviousFireTime();
            posTriggerWrapper.trigger.triggered(calendar);
            trigger.triggered(calendar);
            posTriggerWrapper.state = 0;
            TriggerFiredBundle triggerFiredBundle = new TriggerFiredBundle(this.retrieveJob(schedulingContext, trigger.getJobName(), trigger.getJobGroup()), trigger, calendar, false, new Date(), trigger.getPreviousFireTime(), date, trigger.getNextFireTime());
            JobDetail jobDetail = triggerFiredBundle.getJobDetail();
            if (jobDetail.isStateful()) {
                ArrayList arrayList = null;
                arrayList = jobDetail instanceof PosJobDetail && ((PosJobDetail)jobDetail).isStatefulJobGroups() ? this.getTriggerWrappersForJobGroup((PosJobDetail)jobDetail) : this.getTriggerWrappersForJob(jobDetail.getName(), jobDetail.getGroup());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    PosTriggerWrapper posTriggerWrapper2 = (PosTriggerWrapper)iterator.next();
                    if (posTriggerWrapper2.state == 0) {
                        posTriggerWrapper2.state = 5;
                    }
                    if (posTriggerWrapper2.state == 4) {
                        posTriggerWrapper2.state = 6;
                    }
                    this.timeTriggers.remove(posTriggerWrapper2);
                }
                if (jobDetail instanceof PosJobDetail && ((PosJobDetail)jobDetail).isStatefulJobGroups()) {
                    this.addBlockedJobs((PosJobDetail)jobDetail);
                } else {
                    this.blockedJobs.add(PosJobWrapper.getJobNameKey(jobDetail));
                }
            } else if (posTriggerWrapper.trigger.getNextFireTime() != null) {
                Object object2 = this.triggerLock;
                synchronized (object2) {
                    this.timeTriggers.add(posTriggerWrapper);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.logDebug("(FireE)TriigersByFQN:" + this.triggersByFQN);
                this.log.logDebug("(FireE)TimeTriggers:" + this.timeTriggers);
                this.log.logDebug("(FireE)BlockedJobs:" + this.blockedJobs);
            }
            return triggerFiredBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggeredJobComplete(SchedulingContext schedulingContext, Trigger trigger, JobDetail jobDetail, int n) {
        Object object = this.triggerLock;
        synchronized (object) {
            if (this.log.isDebugEnabled()) {
                this.log.logDebug(jobDetail.getName());
                this.log.logDebug("(CompS)TriigersByFQN:" + this.triggersByFQN);
                this.log.logDebug("(CompS)TimeTriggers:" + this.timeTriggers);
                this.log.logDebug("(CompS)BlockedJobs:" + this.blockedJobs);
            }
            String string = PosJobWrapper.getJobNameKey(jobDetail.getName(), jobDetail.getGroup());
            PosJobWrapper posJobWrapper = (PosJobWrapper)this.jobsByFQN.get(string);
            PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.get(PosTriggerWrapper.a(trigger));
            if (posJobWrapper != null) {
                JobDetail jobDetail2 = posJobWrapper.jobDetail;
                if (jobDetail.isStateful()) {
                    JobDataMap jobDataMap = jobDetail.getJobDataMap();
                    if (jobDataMap != null) {
                        jobDataMap.clearDirtyFlag();
                    }
                    jobDetail2.setJobDataMap(jobDataMap);
                    this.blockedJobs.remove(PosJobWrapper.getJobNameKey(jobDetail2));
                    ArrayList arrayList = null;
                    if (jobDetail2 instanceof PosJobDetail && ((PosJobDetail)jobDetail2).isStatefulJobGroups()) {
                        arrayList = this.getTriggerWrappersForJobGroup((PosJobDetail)jobDetail2);
                        this.removeBlockedJobs((PosJobDetail)jobDetail2);
                    } else {
                        arrayList = this.getTriggerWrappersForJob(jobDetail2.getName(), jobDetail2.getGroup());
                        this.blockedJobs.remove(PosJobWrapper.getJobNameKey(jobDetail2));
                    }
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        PosTriggerWrapper posTriggerWrapper2 = (PosTriggerWrapper)iterator.next();
                        if (posTriggerWrapper2.state == 5) {
                            posTriggerWrapper2.state = 0;
                            this.timeTriggers.add(posTriggerWrapper2);
                        }
                        if (posTriggerWrapper2.state != 6) continue;
                        posTriggerWrapper2.state = 4;
                    }
                }
            } else {
                this.blockedJobs.remove(PosJobWrapper.getJobNameKey(jobDetail));
            }
            if (posTriggerWrapper != null) {
                if (n == 3) {
                    if (trigger.getNextFireTime() == null) {
                        if (posTriggerWrapper.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(schedulingContext, trigger.getName(), trigger.getGroup());
                        }
                    } else {
                        this.removeTrigger(schedulingContext, trigger.getName(), trigger.getGroup());
                    }
                } else if (n == 2) {
                    posTriggerWrapper.state = 3;
                    this.timeTriggers.remove(posTriggerWrapper);
                } else if (n == 5) {
                    this.getLog().info((Object)("Trigger " + trigger.getFullName() + " set to ERROR state."));
                    posTriggerWrapper.state = 7;
                } else if (n == 6) {
                    this.getLog().info((Object)("All triggers of Job " + trigger.getFullJobName() + " set to ERROR state."));
                    this.setAllTriggersOfJobToState(trigger.getJobName(), trigger.getJobGroup(), 7);
                } else if (n == 4) {
                    this.setAllTriggersOfJobToState(trigger.getJobName(), trigger.getJobGroup(), 3);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.logDebug("(CompE)TriigersByFQN:" + this.triggersByFQN);
                this.log.logDebug("(CompE)TimeTriggers:" + this.timeTriggers);
                this.log.logDebug("(CompE)BlockedJobs:" + this.blockedJobs);
            }
        }
    }

    protected void setAllTriggersOfJobToState(String string, String string2, int n) {
        ArrayList arrayList = this.getTriggerWrappersForJob(string, string2);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PosTriggerWrapper posTriggerWrapper = (PosTriggerWrapper)iterator.next();
            posTriggerWrapper.state = n;
            if (n == 0) continue;
            this.timeTriggers.remove(posTriggerWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String peekTriggers() {
        Iterator<Object> iterator;
        StringBuffer stringBuffer = new StringBuffer();
        PosTriggerWrapper posTriggerWrapper = null;
        Object object = this.triggerLock;
        synchronized (object) {
            iterator = this.triggersByFQN.keySet().iterator();
            while (iterator.hasNext()) {
                posTriggerWrapper = (PosTriggerWrapper)this.triggersByFQN.get(iterator.next());
                stringBuffer.append(posTriggerWrapper.trigger.getName());
                stringBuffer.append("/");
            }
        }
        stringBuffer.append(" | ");
        object = this.triggerLock;
        synchronized (object) {
            iterator = this.timeTriggers.iterator();
            while (iterator.hasNext()) {
                posTriggerWrapper = (PosTriggerWrapper)iterator.next();
                stringBuffer.append(posTriggerWrapper.trigger.getName());
                stringBuffer.append("->");
            }
        }
        return stringBuffer.toString();
    }

    public Set getPausedTriggerGroups(SchedulingContext schedulingContext) throws JobPersistenceException {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.pausedTriggerGroups);
        return hashSet;
    }

    protected ArrayList getTriggerWrappersForJobGroup(PosJobDetail posJobDetail) {
        ArrayList arrayList = new ArrayList();
        if (!posJobDetail.isStatefulJobGroups()) {
            return arrayList;
        }
        Set set = posJobDetail.getStatefulJobs();
        String string = posJobDetail.getName();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.equals(string2)) {
                arrayList.addAll(this.getTriggerWrappersForJob(string, posJobDetail.getGroup()));
                continue;
            }
            arrayList.addAll(this.getTriggerWrappersForJob(string2, posJobDetail.getGroup()));
        }
        return arrayList;
    }

    protected void addBlockedJobs(PosJobDetail posJobDetail) {
        Set set = posJobDetail.getStatefulJobs();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PosJobDetail posJobDetail2 = (PosJobDetail)((Object)this.beanFactory.getBeanObject(string));
            this.blockedJobs.add(PosJobWrapper.getJobNameKey((JobDetail)posJobDetail2));
        }
    }

    protected void removeBlockedJobs(PosJobDetail posJobDetail) {
        Set set = posJobDetail.getStatefulJobs();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PosJobDetail posJobDetail2 = (PosJobDetail)((Object)this.beanFactory.getBeanObject(string));
            this.blockedJobs.remove(PosJobWrapper.getJobNameKey((JobDetail)posJobDetail2));
        }
    }
}

