/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.util.mail;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class PosMailSender {
    private static final String a = "UTF-8";
    private static final String b = "glue.mail.debug";
    private static final String c = "mail.smtp.host";
    private static final String d = "mailrelay.posco.co.kr";
    private MimeMessage e;
    private Multipart f;
    private boolean g;

    public PosMailSender() {
        this.setVariables(this.getProperties());
    }

    public PosMailSender(boolean bl) {
        this();
        this.g = bl;
    }

    public PosMailSender(String string) {
        Properties properties = this.getProperties();
        properties.put(c, string);
        this.setVariables(properties);
    }

    public PosMailSender(String string, boolean bl) {
        this(string);
        this.g = bl;
    }

    private Properties getProperties() {
        Properties properties = System.getProperties();
        String string = (String)properties.get(c);
        if (string == null || string.equals("")) {
            properties.put(c, "UnknownHost");
        } else {
            properties.put(c, string);
        }
        return properties;
    }

    private void setVariables(Properties properties) {
        Session session = Session.getDefaultInstance((Properties)properties, null);
        session.setDebug(Boolean.getBoolean(b));
        this.e = new MimeMessage(session);
        this.f = new MimeMultipart();
    }

    public void setHtmlType(boolean bl) {
        this.g = bl;
    }

    public boolean isHtmlType() {
        return this.g;
    }

    public void send() throws Exception {
        this.e.setContent(this.f);
        Transport.send((Message)this.e);
    }

    public void send(String string, String string2, String string3, String string4) throws Exception {
        this.setCommonInfo(string, null, string2, null, string3, string4);
        this.send();
    }

    public void send(String string, String string2, String string3, String string4, String string5) throws Exception {
        this.setCommonInfo(string, null, string2, null, string3, string4);
        this.setFile(string5);
        this.send();
    }

    public void send(String string, String string2, String string3, String string4, List list) throws Exception {
        this.setCommonInfo(string, null, string2, null, string3, string4);
        this.setFiles(list);
        this.send();
    }

    public void send(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        this.setCommonInfo(string, null, string2, string3, string4, string5);
        this.setFile(string6);
        this.send();
    }

    public void send(String string, List list, String string2, String string3) throws Exception {
        this.setCommonInfo(string, null, list, this.getDefaultAlias(list), string2, string3);
        this.send();
    }

    public void send(String string, List list, String string2, String string3, String string4) throws Exception {
        this.setCommonInfo(string, null, list, this.getDefaultAlias(list), string2, string3);
        this.setFile(string4);
        this.send();
    }

    public void send(String string, List list, String string2, String string3, List list2) throws Exception {
        this.setCommonInfo(string, null, list, this.getDefaultAlias(list), string2, string3);
        this.setFiles(list2);
        this.send();
    }

    public void send(String string, List list, List list2, String string2, String string3, String string4) throws Exception {
        this.setCommonInfo(string, null, list, list2, string2, string3);
        this.setFile(string4);
        this.send();
    }

    public void send(String string, Map map, String string2, String string3) throws Exception {
        this.setCommonInfo(string, null, map, string2, string3);
        this.send();
    }

    public void send(String string, String string2, Map map, String string3, String string4) throws Exception {
        this.setCommonInfo(string, string2, map, string3, string4);
        this.send();
    }

    public void send(String string, Map map, String string2, String string3, String string4) throws Exception {
        this.setCommonInfo(string, null, map, string2, string3);
        this.setFile(string4);
        this.send();
    }

    public void send(String string, String string2, Map map, String string3, String string4, String string5) throws Exception {
        this.setCommonInfo(string, string2, map, string3, string4);
        this.setFile(string5);
        this.send();
    }

    public void send(String string, Map map, String string2, String string3, List list) throws Exception {
        this.setCommonInfo(string, null, map, string2, string3);
        this.setFiles(list);
        this.send();
    }

    public void send(String string, String string2, Map map, String string3, String string4, List list) throws Exception {
        this.setCommonInfo(string, string2, map, string3, string4);
        this.setFiles(list);
        this.send();
    }

    public void setFrom(String string) throws Exception {
        this.setFrom(string, null);
    }

    public void setFrom(String string, String string2) throws Exception {
        InternetAddress internetAddress = new InternetAddress(string, string2, a);
        this.e.setFrom((Address)internetAddress);
    }

    public void setRecipient(String string) throws Exception {
        this.setRecipient(string, null);
    }

    public void setRecipient(String string, String string2) throws Exception {
        InternetAddress[] internetAddressArray = new InternetAddress[]{new InternetAddress(string, string2, a)};
        this.e.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
    }

    public void setRecipients(Map map) throws Exception {
        this.addRecipients(map, Message.RecipientType.TO);
    }

    public void setRecipients(List list, List list2) throws Exception {
        if (list.size() == 0 || list.size() != list2.size()) {
            throw new Exception("Incorrect recipient information. Plz check address and name");
        }
        InternetAddress[] internetAddressArray = new InternetAddress[list.size()];
        int n = 0;
        while (n < list.size()) {
            internetAddressArray[n] = new InternetAddress((String)list.get(n), (String)list2.get(n), a);
            ++n;
        }
        this.e.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
    }

    public void setSubject(String string) throws Exception {
        if (string != null) {
            this.e.setSubject(string, a);
        }
    }

    public void setContent(String string) throws Exception {
        if (this.g) {
            this.setHtmlContent(string);
        } else {
            this.setTextContent(string);
        }
    }

    public void setTextContent(String string) throws Exception {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(string, a);
        mimeBodyPart.setHeader("Content-Type", "text/plain;charset=UTF-8");
        mimeBodyPart.setHeader("Content-Transfer-Encoding", "8bit");
        this.f.addBodyPart((BodyPart)mimeBodyPart);
    }

    public void setHtmlContent(String string) throws Exception {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(string, a);
        mimeBodyPart.setHeader("Content-Type", "text/html;charset=UTF-8");
        mimeBodyPart.setHeader("Content-Transfer-Encoding", "8bit");
        this.f.addBodyPart((BodyPart)mimeBodyPart);
    }

    public void setFiles(List list) throws Exception {
        if (list != null || list.size() == 0) {
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                this.setFile((String)list.get(n));
                ++n;
            }
        }
    }

    public void setFile(String string) throws Exception {
        if (string != null) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            FileDataSource fileDataSource = new FileDataSource(string);
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
            mimeBodyPart.setFileName(MimeUtility.encodeText((String)fileDataSource.getName(), (String)a, (String)"B"));
            this.f.addBodyPart((BodyPart)mimeBodyPart);
        }
    }

    private void setCommonInfo(String string, String string2, Map map, String string3, String string4) throws Exception {
        this.setFrom(string, string2);
        this.setRecipients(map);
        this.setSubject(string3);
        this.setContent(string4);
    }

    private void setCommonInfo(String string, String string2, Object object, Object object2, String string3, String string4) throws Exception {
        this.setFrom(string, string2);
        if (object instanceof String) {
            if (object2 != null) {
                this.setRecipient((String)object, (String)object2);
            } else {
                this.setRecipient((String)object, null);
            }
        } else if (object instanceof List && object2 instanceof List) {
            this.setRecipients((List)object, (List)object2);
        } else {
            throw new Exception("Incorrect recipient information.");
        }
        this.setSubject(string3);
        this.setContent(string4);
    }

    private List getDefaultAlias(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            arrayList.add(((String)list.get(n)).split("@")[0]);
            ++n;
        }
        return arrayList;
    }

    public void setCC(List list) throws Exception {
        this.addRecipients(list, Message.RecipientType.CC);
    }

    private void addRecipients(List list, Message.RecipientType recipientType) throws Exception {
        if (list == null || list.size() == 0) {
            return;
        }
        int n = list.size();
        List list2 = this.getDefaultAlias(list);
        InternetAddress[] internetAddressArray = new InternetAddress[n];
        int n2 = 0;
        while (n2 < n) {
            internetAddressArray[n2] = new InternetAddress((String)list.get(n2), (String)list2.get(n2), a);
            ++n2;
        }
        this.e.addRecipients(recipientType, (Address[])internetAddressArray);
    }

    public void setCC(Map map) throws Exception {
        this.addRecipients(map, Message.RecipientType.CC);
    }

    private void addRecipients(Map map, Message.RecipientType recipientType) throws Exception {
        if (map == null || map.size() == 0) {
            return;
        }
        int n = map.size();
        int n2 = 0;
        Iterator iterator = map.keySet().iterator();
        String string = null;
        String string2 = null;
        InternetAddress[] internetAddressArray = new InternetAddress[n];
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = (String)map.get(string);
            internetAddressArray[n2++] = new InternetAddress(string, string2, a);
        }
        this.e.addRecipients(recipientType, (Address[])internetAddressArray);
    }

    public void setBCC(List list) throws Exception {
        this.addRecipients(list, Message.RecipientType.BCC);
    }

    public void setBCC(Map map) throws Exception {
        this.addRecipients(map, Message.RecipientType.BCC);
    }
}

