/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.disk.LRUMapJCS;
import org.apache.jcs.auxiliary.disk.PurgatoryElement;
import org.apache.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.CacheInfo;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public abstract class AbstractDiskCache
implements AuxiliaryCache,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$AbstractDiskCache == null ? (class$org$apache$jcs$auxiliary$disk$AbstractDiskCache = AbstractDiskCache.class$("org.apache.jcs.auxiliary.disk.AbstractDiskCache")) : class$org$apache$jcs$auxiliary$disk$AbstractDiskCache));
    private IDiskCacheAttributes dcattr = null;
    protected Map purgatory = new HashMap();
    protected ICacheEventQueue cacheEventQueue;
    protected boolean alive = false;
    protected String cacheName;
    protected int purgHits = 0;
    private WriterPreferenceReadWriteLock removeAllLock = new WriterPreferenceReadWriteLock();
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$AbstractDiskCache;

    public AbstractDiskCache(IDiskCacheAttributes attr) {
        this.dcattr = attr;
        this.cacheName = attr.getCacheName();
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.cacheEventQueue = fact.createCacheEventQueue(new MyCacheListener(), CacheInfo.listenerId, this.cacheName, this.dcattr.getEventQueuePoolName(), this.dcattr.getEventQueueTypeFactoryCode());
        this.initPurgatory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initPurgatory() {
        try {
            try {
                this.removeAllLock.writeLock().acquire();
                if (this.purgatory != null) {
                    Map map = this.purgatory;
                    synchronized (map) {
                        this.purgatory = this.dcattr.getMaxPurgatorySize() >= 0 ? new LRUMapJCS(this.dcattr.getMaxPurgatorySize()) : new HashMap();
                    }
                }
                if (this.dcattr.getMaxPurgatorySize() >= 0) {
                    this.purgatory = new LRUMapJCS(this.dcattr.getMaxPurgatorySize());
                }
                this.purgatory = new HashMap();
            }
            catch (InterruptedException e) {
                log.error((Object)"problem encountered resseting purgatory.", (Throwable)e);
                Object var4_4 = null;
                this.removeAllLock.writeLock().release();
                return;
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.removeAllLock.writeLock().release();
            throw throwable;
        }
        this.removeAllLock.writeLock().release();
    }

    public final void update(ICacheElement cacheElement) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Putting element in purgatory, cacheName: " + this.cacheName + ", key: " + cacheElement.getKey()));
        }
        try {
            PurgatoryElement pe = new PurgatoryElement(cacheElement);
            pe.setSpoolable(true);
            Map map = this.purgatory;
            synchronized (map) {
                this.purgatory.put(pe.getKey(), pe);
            }
            this.cacheEventQueue.addPutEvent(pe);
        }
        catch (IOException ex) {
            log.error((Object)"Problem adding put event to queue.", (Throwable)ex);
            this.cacheEventQueue.destroy();
        }
    }

    public final ICacheElement get(Serializable key) {
        if (!this.alive) {
            return null;
        }
        PurgatoryElement pe = null;
        Map map = this.purgatory;
        synchronized (map) {
            pe = (PurgatoryElement)this.purgatory.get(key);
        }
        if (pe != null) {
            ++this.purgHits;
            if (log.isDebugEnabled() && this.purgHits % 100 == 0) {
                log.debug((Object)("Purgatory hits = " + this.purgHits));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found element in purgatory, cacheName: " + this.cacheName + ", key: " + key));
            }
            return pe.cacheElement;
        }
        try {
            return this.doGet(key);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.cacheEventQueue.destroy();
            return null;
        }
    }

    public abstract Set getGroupKeys(String var1);

    public final boolean remove(Serializable key) {
        PurgatoryElement pe = null;
        Map map = this.purgatory;
        synchronized (map) {
            pe = (PurgatoryElement)this.purgatory.get(key);
        }
        if (pe != null) {
            ICacheElement iCacheElement = pe.getCacheElement();
            synchronized (iCacheElement) {
                Map map2 = this.purgatory;
                synchronized (map2) {
                    this.purgatory.remove(key);
                }
                pe.setSpoolable(false);
                this.doRemove(key);
            }
        }
        this.doRemove(key);
        return false;
    }

    public final void removeAll() {
        if (this.dcattr.isAllowRemoveAll()) {
            this.initPurgatory();
            this.doRemoveAll();
        } else if (log.isInfoEnabled()) {
            log.info((Object)"RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    public final void dispose() {
        Runnable disR = new Runnable(){

            public void run() {
                boolean keepGoing = true;
                long total = 0L;
                long interval = 100L;
                while (keepGoing) {
                    keepGoing = !AbstractDiskCache.this.cacheEventQueue.isEmpty();
                    try {
                        Thread.sleep(interval);
                        total += interval;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                log.info((Object)("No longer waiting for event queue to finish: " + AbstractDiskCache.this.cacheEventQueue.getStatistics()));
            }
        };
        Thread t = new Thread(disR);
        t.start();
        try {
            t.join(this.dcattr.getShutdownSpoolTimeLimit() * 1000);
        }
        catch (InterruptedException ex) {
            log.error((Object)ex);
        }
        log.info((Object)"In dispose, destroying event queue.");
        this.cacheEventQueue.destroy();
        this.doDispose();
        this.alive = false;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Disk Cache");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Purgatory Hits");
        se.setData("" + this.purgHits);
        elems.add(se);
        se = new StatElement();
        se.setName("Purgatory Size");
        se.setData("" + this.purgatory.size());
        elems.add(se);
        IStats eqStats = this.cacheEventQueue.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public int getStatus() {
        return this.alive ? 1 : 2;
    }

    public abstract int getSize();

    public int getCacheType() {
        return 2;
    }

    protected abstract ICacheElement doGet(Serializable var1);

    protected abstract void doUpdate(ICacheElement var1);

    protected abstract boolean doRemove(Serializable var1);

    protected abstract void doRemoveAll();

    protected abstract void doDispose();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyCacheListener
    implements ICacheListener {
        private long listenerId = 0L;

        private MyCacheListener() {
        }

        public long getListenerId() throws IOException {
            return this.listenerId;
        }

        public void setListenerId(long id) throws IOException {
            this.listenerId = id;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handlePut(ICacheElement element) throws IOException {
            if (!AbstractDiskCache.this.alive) {
                Map map = AbstractDiskCache.this.purgatory;
                synchronized (map) {
                    AbstractDiskCache.this.purgatory.remove(element.getKey());
                    return;
                }
            }
            if (!(element instanceof PurgatoryElement)) {
                AbstractDiskCache.this.doUpdate(element);
                return;
            }
            PurgatoryElement pe = (PurgatoryElement)element;
            ICacheElement iCacheElement = pe.getCacheElement();
            synchronized (iCacheElement) {
                Map map;
                try {
                    block15: {
                        try {
                            AbstractDiskCache.this.removeAllLock.readLock().acquire();
                            map = AbstractDiskCache.this.purgatory;
                            synchronized (map) {
                                if (!AbstractDiskCache.this.purgatory.containsKey(pe.getKey())) {
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 7, 8, 12] lbl20 : MonitorExitStatement: MONITOREXIT : var4_5
                                    Object var7_7 = null;
                                    AbstractDiskCache.this.removeAllLock.readLock().release();
                                    return;
                                }
                                element = pe.getCacheElement();
                                if (!pe.isSpoolable()) break block15;
                            }
                            AbstractDiskCache.this.doUpdate(element);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e);
                            Object var7_9 = null;
                            AbstractDiskCache.this.removeAllLock.readLock().release();
                        }
                    }
                    Object var7_8 = null;
                    AbstractDiskCache.this.removeAllLock.readLock().release();
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    AbstractDiskCache.this.removeAllLock.readLock().release();
                    throw throwable;
                }
                map = AbstractDiskCache.this.purgatory;
                synchronized (map) {
                    AbstractDiskCache.this.purgatory.remove(element.getKey());
                    return;
                }
            }
        }

        public void handleRemove(String cacheName, Serializable key) throws IOException {
            if (AbstractDiskCache.this.alive && AbstractDiskCache.this.doRemove(key)) {
                log.debug((Object)("Element removed, key: " + key));
            }
        }

        public void handleRemoveAll(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doRemoveAll();
            }
        }

        public void handleDispose(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doDispose();
            }
        }
    }
}

