/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.jcs.auxiliary.remote.RemoteCacheMonitor;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.behavior.ICache;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheElementSerialized;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.behavior.IZombie;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.serialization.SerializationConversionUtil;
import org.apache.jcs.utils.serialization.StandardSerializer;
import org.apache.jcs.utils.threadpool.ThreadPool;
import org.apache.jcs.utils.threadpool.ThreadPoolManager;

public class RemoteCache
implements ICache {
    private static final long serialVersionUID = -5329231850422826460L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCache == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCache = RemoteCache.class$("org.apache.jcs.auxiliary.remote.RemoteCache")) : class$org$apache$jcs$auxiliary$remote$RemoteCache));
    final String cacheName;
    private IRemoteCacheAttributes irca;
    private IRemoteCacheService remote;
    private IRemoteCacheListener listener;
    IElementAttributes attr = null;
    private ThreadPool pool = null;
    private boolean usePoolForGet = false;
    private IElementSerializer elementSerializer = new StandardSerializer();
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCache;

    public RemoteCache(IRemoteCacheAttributes cattr, IRemoteCacheService remote, IRemoteCacheListener listener) {
        this.irca = cattr;
        this.cacheName = cattr.getCacheName();
        this.remote = remote;
        this.listener = listener;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Construct> cacheName=" + cattr.getCacheName()));
            log.debug((Object)("irca = " + this.irca));
            log.debug((Object)("remote = " + remote));
            log.debug((Object)("listener = " + listener));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("GetTimeoutMillis() = " + this.irca.getGetTimeoutMillis()));
        }
        if (this.irca.getGetTimeoutMillis() > 0) {
            this.pool = ThreadPoolManager.getInstance().getPool(this.irca.getThreadPoolName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Thread Pool = " + this.pool));
            }
            if (this.pool != null) {
                this.usePoolForGet = true;
                this.pool.getPool().setThreadFactory((ThreadFactory)new MyThreadFactory());
            }
        }
        try {
            if (this.irca.getRmiSocketFactoryTimeoutMillis() > 0) {
                RMISocketFactory.setSocketFactory(new RMISocketFactory(){

                    public Socket createSocket(String host, int port) throws IOException {
                        Socket socket = new Socket(host, port);
                        socket.setSoTimeout(RemoteCache.this.irca.getRmiSocketFactoryTimeoutMillis());
                        socket.setSoLinger(false, 0);
                        return socket;
                    }

                    public ServerSocket createServerSocket(int port) throws IOException {
                        return new ServerSocket(port);
                    }
                });
            }
        }
        catch (Exception e) {
            log.info((Object)e.getMessage());
        }
    }

    public void setElementAttributes(IElementAttributes attr) {
        this.attr = attr;
    }

    public IElementAttributes getElementAttributes() {
        return this.attr;
    }

    public void update(ICacheElement ce) throws IOException {
        if (!this.irca.getGetOnly()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sending item to remote server");
                }
                ICacheElementSerialized serialized = SerializationConversionUtil.getSerializedCacheElement(ce, this.elementSerializer);
                this.remote.update(serialized, this.getListenerId());
            }
            catch (NullPointerException npe) {
                log.error((Object)("npe for ce = " + ce + "ce.attr = " + ce.getElementAttributes()), (Throwable)npe);
                return;
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to put " + ce.getKey() + " to " + ce.getCacheName());
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"get only mode, not sending to remote server");
        }
    }

    public ICacheElement get(Serializable key) throws IOException {
        ICacheElement retVal = null;
        try {
            retVal = this.usePoolForGet ? this.getUsingPool(this.sanitized(key)) : this.remote.get(this.cacheName, this.sanitized(key), this.getListenerId());
            if (retVal != null && retVal instanceof ICacheElementSerialized && this.irca.getRemoteType() != 1) {
                retVal = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)retVal, this.elementSerializer);
            }
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to get " + key + " from " + this.cacheName);
        }
        return retVal;
    }

    public ICacheElement getUsingPool(final Serializable key) throws IOException {
        int timeout = this.irca.getGetTimeoutMillis();
        try {
            FutureResult future = new FutureResult();
            Runnable command = future.setter(new Callable(){

                public Object call() throws IOException {
                    return RemoteCache.this.remote.get(RemoteCache.this.cacheName, key, RemoteCache.this.getListenerId());
                }
            });
            this.pool.execute(command);
            ICacheElement ice = (ICacheElement)future.timedGet((long)timeout);
            if (log.isDebugEnabled()) {
                if (ice == null) {
                    log.debug((Object)"nothing found in remote cache");
                } else {
                    log.debug((Object)"found item in remote cache");
                }
            }
            return ice;
        }
        catch (TimeoutException te) {
            log.warn((Object)("TimeoutException, Get Request timed out after " + timeout));
            throw new IOException("Get Request timed out after " + timeout);
        }
        catch (InterruptedException ex) {
            log.warn((Object)("InterruptedException, Get Request timed out after " + timeout));
            throw new IOException("Get Request timed out after " + timeout);
        }
        catch (InvocationTargetException ex) {
            log.error((Object)"InvocationTargetException, Assuming an IO exception thrown in the background.", (Throwable)ex);
            throw new IOException("Get Request timed out after " + timeout);
        }
    }

    public Set getGroupKeys(String groupName) throws RemoteException {
        return this.remote.getGroupKeys(this.cacheName, groupName);
    }

    private Serializable sanitized(Serializable s) throws IOException {
        return s;
    }

    public boolean remove(Serializable key) throws IOException {
        if (!this.irca.getGetOnly()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove> key=" + key));
            }
            try {
                this.remote.remove(this.cacheName, this.sanitized(key), this.getListenerId());
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove " + key + " from " + this.cacheName);
            }
        }
        return false;
    }

    public void removeAll() throws IOException {
        if (!this.irca.getGetOnly()) {
            try {
                this.remote.removeAll(this.cacheName, this.getListenerId());
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove all from " + this.cacheName);
            }
        }
    }

    public void dispose() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Disposing of remote cache");
        }
        try {
            this.remote.dispose(this.cacheName);
        }
        catch (Exception ex) {
            log.error((Object)"couldn't dispose", (Throwable)ex);
            this.handleException(ex, "Failed to dispose " + this.cacheName);
        }
    }

    public int getStatus() {
        return this.remote instanceof IZombie ? 3 : 1;
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait");
        ArrayList<StatElement> elems = new ArrayList<StatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Remote Host:Port");
        se.setData(this.irca.getRemoteHost() + ":" + this.irca.getRemotePort());
        elems.add(se);
        se = new StatElement();
        se.setName("Remote Type");
        se.setData(this.irca.getRemoteTypeName() + "");
        elems.add(se);
        if (this.irca.getRemoteType() == 1) {
            // empty if block
        }
        se = new StatElement();
        se.setName("UsePoolForGet");
        se.setData("" + this.usePoolForGet);
        elems.add(se);
        if (this.pool != null) {
            se = new StatElement();
            se.setName("Pool Size");
            se.setData("" + this.pool.getPool().getPoolSize());
            elems.add(se);
            se = new StatElement();
            se.setName("Maximum Pool Size");
            se.setData("" + this.pool.getPool().getMaximumPoolSize());
            elems.add(se);
        }
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public int getSize() {
        return 0;
    }

    public int getCacheType() {
        return 4;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void fixCache(IRemoteCacheService remote) {
        this.remote = remote;
    }

    private void handleException(Exception ex, String msg) throws IOException {
        log.error((Object)("Disabling remote cache due to error " + msg));
        log.error((Object)ex);
        this.remote = new ZombieRemoteCacheService();
        RemoteCacheMonitor.getInstance().notifyError();
        RemoteCacheNoWaitFacade rcnwf = (RemoteCacheNoWaitFacade)RemoteCacheFactory.getFacades().get(this.irca.getCacheName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initiating failover, rcnf = " + rcnwf));
        }
        if (rcnwf != null && rcnwf.rca.getRemoteType() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found facade, calling failover");
            }
            rcnwf.failover(0);
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.irca;
    }

    public void setListenerId(long id) {
        try {
            this.listener.setListenerId(id);
            if (log.isDebugEnabled()) {
                log.debug((Object)("set listenerId = " + id));
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem setting listenerId", (Throwable)e);
        }
    }

    public long getListenerId() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("get listenerId = " + this.listener.getListenerId()));
            }
            return this.listener.getListenerId();
        }
        catch (Exception e) {
            log.error((Object)"Problem setting listenerId", (Throwable)e);
            return -1L;
        }
    }

    protected IRemoteCacheListener getListener() {
        return this.listener;
    }

    public void setElementSerializer(IElementSerializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    public IElementSerializer getElementSerializer() {
        return this.elementSerializer;
    }

    public String toString() {
        return "RemoteCache: " + this.cacheName + " attributes = " + this.irca;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            t.setDaemon(true);
            return t;
        }
    }
}

