/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheFailoverRunner;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class RemoteCacheNoWaitFacade
implements AuxiliaryCache {
    private static final long serialVersionUID = -4529970797620747110L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWaitFacade == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWaitFacade = RemoteCacheNoWaitFacade.class$("org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWaitFacade));
    public RemoteCacheNoWait[] noWaits;
    private String cacheName;
    protected RemoteCacheAttributes rca;
    private ICompositeCacheManager cacheMgr;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWaitFacade;

    public RemoteCacheAttributes getRemoteCacheAttributes() {
        return this.rca;
    }

    public void setRemoteCacheAttributes(RemoteCacheAttributes rca) {
        this.rca = rca;
    }

    public RemoteCacheNoWaitFacade(RemoteCacheNoWait[] noWaits, RemoteCacheAttributes rca, ICompositeCacheManager cacheMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CONSTRUCTING NO WAIT FACADE");
        }
        this.noWaits = noWaits;
        this.rca = rca;
        this.cacheName = rca.getCacheName();
        this.cacheMgr = cacheMgr;
    }

    public void update(ICacheElement ce) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating through cache facade, noWaits.length = " + this.noWaits.length));
        }
        int i = 0;
        try {
            while (i < this.noWaits.length) {
                this.noWaits[i].update(ce);
                ++i;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
            this.failover(i);
        }
    }

    public ICacheElement get(Serializable key) {
        int i = 0;
        if (i < this.noWaits.length) {
            try {
                ICacheElement obj = this.noWaits[i].get(key);
                if (obj != null) {
                    return obj;
                }
            }
            catch (Exception ex) {
                log.debug((Object)"Failed to get.");
            }
            return null;
        }
        return null;
    }

    public Set getGroupKeys(String group) throws IOException {
        HashSet allKeys = new HashSet();
        int i = 0;
        while (i < this.noWaits.length) {
            RemoteCacheNoWait aux = this.noWaits[i];
            if (aux != null) {
                allKeys.addAll(aux.getGroupKeys(group));
            }
            ++i;
        }
        return allKeys;
    }

    public boolean remove(Serializable key) {
        try {
            int i = 0;
            while (i < this.noWaits.length) {
                this.noWaits[i].remove(key);
                ++i;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return false;
    }

    public void removeAll() {
        try {
            int i = 0;
            while (i < this.noWaits.length) {
                this.noWaits[i].removeAll();
                ++i;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public void dispose() {
        try {
            int i = 0;
            while (i < this.noWaits.length) {
                this.noWaits[i].dispose();
                ++i;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public int getSize() {
        return 0;
    }

    public int getCacheType() {
        return 4;
    }

    public String getCacheName() {
        return this.rca.getCacheName();
    }

    public int getStatus() {
        return 0;
    }

    public String toString() {
        return "RemoteCacheNoWaitFacade: " + this.cacheName + ", rca = " + this.rca;
    }

    protected void failover(int i) {
        if (log.isDebugEnabled()) {
            log.info((Object)("in failover for " + i));
        }
        if (this.rca.getRemoteType() == 0) {
            if (this.noWaits[i].getStatus() == 3) {
                RemoteCacheFailoverRunner runner = new RemoteCacheFailoverRunner(this, this.cacheMgr);
                if (runner != null) {
                    runner.notifyError();
                    Thread t = new Thread(runner);
                    t.setDaemon(true);
                    t.start();
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"The noWait is not in error");
            }
        }
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait Facade");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        if (this.noWaits != null) {
            se = new StatElement();
            se.setName("Number of No Waits");
            se.setData("" + this.noWaits.length);
            elems.add(se);
            int i = 0;
            while (i < this.noWaits.length) {
                IStats sStats = this.noWaits[i].getStatistics();
                IStatElement[] sSEs = sStats.getStatElements();
                List<IStatElement> sL = Arrays.asList(sSEs);
                elems.addAll(sL);
                ++i;
            }
        }
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

