/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import oracle.i18n.net.MimeUtility;

public class URLEncoder {
    private static BitSet dontNeedEncoding = new BitSet(256);
    private static BitSet dontNeedEncodingURL;
    private static final int caseDiff = 32;
    private static final int maxBytesPerChar = 10;

    private URLEncoder() {
    }

    public static String encode(String string) {
        return URLEncoder.encode(string, true);
    }

    public static String encode(String string, boolean bl) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, bl, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.getMessage());
        }
        return string2;
    }

    public static String encode(String string, boolean bl, String string2) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[10];
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            int n3 = cArray[n];
            if (dontNeedEncoding.get(n3) || !bl && dontNeedEncodingURL.get(n3)) {
                if (n3 == 32) {
                    n3 = 43;
                }
                stringBuffer.append((char)n3);
            } else {
                byte[] byArray2;
                if (URLEncoder.isHiSurrogate((char)n3) && n + 1 < n2) {
                    byArray2 = MimeUtility.getBytes(new String(new char[]{(char)n3, cArray[n + 1]}), string2);
                    ++n;
                } else {
                    byArray2 = MimeUtility.getBytes(new String(new char[]{(char)n3}), string2);
                }
                int n4 = 0;
                while (n4 < byArray2.length) {
                    stringBuffer.append('%');
                    char c = Character.forDigit(byArray2[n4] >> 4 & 0xF, 16);
                    if (Character.isLetter(c)) {
                        c = (char)(c - 32);
                    }
                    stringBuffer.append(c);
                    c = Character.forDigit(byArray2[n4] & 0xF, 16);
                    if (Character.isLetter(c)) {
                        c = (char)(c - 32);
                    }
                    stringBuffer.append(c);
                    ++n4;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static boolean isHiSurrogate(char c) {
        return (char)(c & 0xFC00) == '\ud800';
    }

    static {
        int n = 97;
        while (n <= 122) {
            dontNeedEncoding.set(n);
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            dontNeedEncoding.set(n2);
            ++n2;
        }
        int n3 = 48;
        while (n3 <= 57) {
            dontNeedEncoding.set(n3);
            ++n3;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncodingURL = new BitSet(256);
        dontNeedEncodingURL.set(59);
        dontNeedEncodingURL.set(47);
        dontNeedEncodingURL.set(63);
        dontNeedEncodingURL.set(64);
        dontNeedEncodingURL.set(38);
        dontNeedEncodingURL.set(61);
        dontNeedEncodingURL.set(43);
        dontNeedEncodingURL.set(36);
        dontNeedEncodingURL.set(44);
        dontNeedEncodingURL.set(58);
    }
}

