/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import oracle.i18n.text.OraNormalizer;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.HashTree;
import oracle.i18n.util.UnicodeCatTable;

public class OraUnicodeProperty
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    public static final short LU = 1;
    public static final short LL = 2;
    public static final short LT = 3;
    public static final short MN = 4;
    public static final short MC = 5;
    public static final short ME = 6;
    public static final short ND = 7;
    public static final short NL = 8;
    public static final short NO = 9;
    public static final short ZS = 10;
    public static final short ZL = 11;
    public static final short ZP = 12;
    public static final short CC = 13;
    public static final short CF = 14;
    public static final short CS = 15;
    public static final short CO = 16;
    public static final short CN = 17;
    public static final short LM = 18;
    public static final short LO = 19;
    public static final short PC = 20;
    public static final short PD = 21;
    public static final short PS = 22;
    public static final short PE = 23;
    public static final short PI = 24;
    public static final short PF = 25;
    public static final short PO = 26;
    public static final short SM = 27;
    public static final short SC = 28;
    public static final short SK = 29;
    public static final short SO = 30;
    public static final short ALPHA = 1;
    public static final short LETTER = 2;
    public static final short LOWER = 3;
    public static final short UPPER = 4;
    public static final short TITLE = 5;
    public static final short ALPHANUMERIC = 6;
    public static final short DIGIT = 7;
    public static final short HEX_DIGIT = 8;
    public static final short CTRL = 9;
    public static final short PUNCTUATION = 10;
    public static final short BLANK = 11;
    public static final short SPACE = 12;
    public static final short BASE = 13;
    public static final short GRAPH = 14;
    public static final short PRINTABLE = 15;
    private static final int GENERAL_MASK = 255;
    private static final int BIDICATEGORY_MASK = 32512;
    private static final int COMPATIBILITY_MASK = 32768;
    private static OraUnicodeProperty upCache = null;
    private static final String FILENAME = "/oracle/i18n/data/unicodeproperty.glb";
    protected UnicodeCatTable classTable = null;
    protected UnicodeCatTable combineTable = null;
    protected UnicodeCatTable propTable = null;
    protected UnicodeCatTable bidiTable = null;
    protected HashTree compTable = null;

    protected OraUnicodeProperty() {
    }

    public static synchronized OraUnicodeProperty getInstance() {
        if (upCache == null) {
            ConverterArchive converterArchive = new ConverterArchive();
            upCache = (OraUnicodeProperty)converterArchive.readObj(FILENAME);
        }
        return upCache;
    }

    public int getCombiningClass(int n) {
        return this.combineTable.getProperties(n);
    }

    public int getUnicodeProperty(int n) {
        return this.propTable.getProperties(n);
    }

    public short getGeneral(int n) {
        return (short)(this.propTable.getProperties(n) & 0xFF);
    }

    public boolean isCompatibility(int n) {
        if (n >= 63744 && n <= 64045) {
            return true;
        }
        return (this.propTable.getProperties(n) & 0x8000) == 32768;
    }

    public short getClassification(int n) {
        return (short)this.classTable.getProperties(n);
    }

    public short getBidicategory(int n) {
        return 0;
    }

    public void canonicalSort(char[] cArray) {
        int n = cArray.length;
        int[] nArray = new int[32];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if (cArray[n3] >> 10 == 54) {
                n2 = (cArray[n3] << 16) + cArray[n3 + 1];
                nArray[n3 + 1] = n4 = this.getCombiningClass(n2);
            } else {
                n2 = 0;
                n4 = this.getCombiningClass(cArray[n3]);
            }
            nArray[n3] = n4;
            if (n4 != 0 && n3 != 0) {
                int n5 = n3 - 1;
                while (n5 >= 0 && nArray[n5] != 0 && n4 < nArray[n5]) {
                    char c;
                    if (n2 == 0) {
                        nArray[n5 + 1] = nArray[n5];
                        nArray[n5] = n4;
                        c = cArray[n5 + 1];
                        cArray[n5 + 1] = cArray[n5];
                        cArray[n5] = c;
                    } else {
                        nArray[n5 + 2] = nArray[n5];
                        nArray[n5 + 1] = nArray[n5] = n4;
                        c = cArray[n5 + 2];
                        cArray[n5 + 2] = cArray[n5];
                        cArray[n5] = cArray[n5 + 1];
                        cArray[n5 + 1] = c;
                    }
                    --n5;
                }
                if (n2 != 0) {
                    ++n3;
                    n2 = 0;
                }
            }
            ++n3;
        }
    }

    public String compose(String string) {
        int n = string.length();
        String string2 = new String();
        String string3 = new String();
        char[] cArray = null;
        int n2 = 0;
        while (n2 < n) {
            byte by = (byte)(string.charAt(n2) >>> 8);
            if (by == 17 || by >= 172 && by < 219) {
                if (string3.length() != 0) {
                    cArray = this.compTable.getData(string3.toCharArray());
                    string2 = string2 + new String(cArray);
                    string3 = new String();
                }
                while (by == 17 || by >= 172 && by < 219) {
                    string3 = string3 + string.charAt(n2++);
                    if (n2 >= n) break;
                    by = (byte)(string.charAt(n2) >>> 8);
                }
                string2 = string2 + OraNormalizer.composeHangul(string3);
                string3 = new String();
            }
            if (n2 < n) {
                string3 = string3 + string.charAt(n2);
            }
            ++n2;
        }
        if (string3.length() != 0) {
            cArray = this.compTable.getData(string3.toCharArray());
            string2 = string2 + new String(cArray);
        }
        return string2;
    }
}

