/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.Vector;
import oracle.i18n.text.OraLinguistic;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.builder.UnicodeMapChar;
import oracle.sql.converter.CharacterConverters;

public class OraLinguisticSetter
extends OraLinguistic {
    static final int FIRST_LEVEL_LENGTH = 256;
    static final int SECOND_LEVEL_LENGTH = 65536;
    static final short BASE_PRIMARY_PART = 31;
    static final short BASE_SECONDARY_PART = 1;
    static final short BASE_TERTIARY_PART = 31;
    static final int TWOBYTESHIFT = 16;
    static final int ONEBYTESHIFT = 8;
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();

    public void setVersion(String string) {
        this.VERSION = string;
    }

    public void setSortName(String string) {
        this.SORTNAME = string;
    }

    public void setSortId(String string) {
        this.SORTID = string == null ? -1 : Integer.parseInt(string);
    }

    public void setBaseSortName(String string) {
        this.BASESORTNAME = string;
    }

    public void setBaseSortId(String string) {
        this.BASESORTID = string == null ? 0 : Integer.parseInt(string);
    }

    public void setReverseSec(String string) {
        if (string != null && string.compareTo("TRUE") == 0) {
            this.Reverse_secondary = true;
        }
    }

    public void setCanonicalEq(String string) {
        if (string != null && string.compareTo("TRUE") == 0) {
            this.Canonical_equivalence = true;
        }
    }

    public void setSwapWithNext(String string) {
        if (string != null && string.compareTo("TRUE") == 0) {
            this.Swap_with_next = true;
        }
    }

    public void setHangulJamo(String string) {
        if (string != null && string.compareTo("TRUE") == 0) {
            this.Hangul_jamo_composition = true;
        }
    }

    public void setMonolingual(boolean bl) {
        this.monolingual = bl;
    }

    public void setCollationLevel1(int[] nArray) {
        this.collationLevel1 = new int[256];
        System.arraycopy(nArray, 0, this.collationLevel1, 0, 256);
    }

    public void setCollationLevel2(int n, int n2) {
        this.collationLevel2[n] = n2;
    }

    public void setCollationLevel2(int n, int[] nArray) {
        this.collationLevel2 = new int[n];
        System.arraycopy(nArray, 0, this.collationLevel2, 0, n);
    }

    public void setContractTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.contractCollKey = new int[n];
        this.contractNumOfFE = new byte[n];
        this.contractConChar = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = (int[])vector.elementAt(n2);
            this.contractCollKey[n2] = nArray[1];
            this.contractNumOfFE[n2] = (byte)nArray[2];
            this.contractConChar[n2] = new char[nArray.length - 3];
            int n3 = 3;
            while (n3 < nArray.length) {
                this.contractConChar[n2][n3 - 3] = (char)nArray[n3];
                ++n3;
            }
            ++n2;
        }
    }

    public void setExpandingTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.expandExpCharKey = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            Vector vector2 = (Vector)vector.elementAt(n2);
            this.expandExpCharKey[n2] = new int[vector2.size()];
            int n3 = 0;
            while (n3 < vector2.size()) {
                this.expandExpCharKey[n2][n3] = (Integer)vector2.elementAt(n3);
                ++n3;
            }
            ++n2;
        }
    }

    public void setContextSensitiveTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.contextPrevCpt = new int[n];
        this.contextCollKey = new int[n];
        this.contextSenChar = new char[n];
        this.contextNumOfFE = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = (int[])vector.elementAt(n2);
            this.contextNumOfFE[n2] = (byte)nArray[1];
            this.contextCollKey[n2] = nArray[2];
            this.contextPrevCpt[n2] = nArray[3] << 16 + nArray[4];
            this.contextSenChar[n2] = (char)nArray[0];
            ++n2;
        }
    }

    public void setSurrogateTable(Vector[] vectorArray) {
        if (vectorArray == null) {
            return;
        }
        int n = 0;
        while (n < 16) {
            if (vectorArray[n] != null) {
                if (this.surrogateTable == null) {
                    this.surrogateTable = new int[16][];
                }
                this.surrogateTable[n] = new int[vectorArray[n].size()];
                int n2 = 0;
                while (n2 < vectorArray[n].size()) {
                    this.surrogateTable[n][n2] = (Integer)vectorArray[n].elementAt(n2);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void setBaseLetterTable(UnicodeMapChar unicodeMapChar) {
        this.baseLetterTable = unicodeMapChar;
    }

    public void statistic() {
        System.out.println(" this is the statistic");
        System.out.println(" The first level length is " + this.collationLevel1.length);
        System.out.println(" The secondary level length is " + this.collationLevel2.length);
        if (this.contractCollKey != null) {
            System.out.println(" The contract table entry#  is " + this.contractCollKey.length);
            System.out.println(" More length " + this.contractNumOfFE.length + " " + this.contractConChar.length);
        }
        if (this.expandExpCharKey != null) {
            System.out.println(" The expanding table entry# is " + this.expandExpCharKey.length);
        }
        if (this.contextPrevCpt != null) {
            System.out.println(" The context sensitive table is " + this.contextPrevCpt.length);
            System.out.println(this.contextCollKey.length + " " + this.contextSenChar.length + " " + this.contextNumOfFE.length);
        }
        if (this.surrogateTable == null) {
            return;
        }
        int n = 0;
        while (n < 16) {
            if (this.surrogateTable[n] == null) {
                System.out.println("table " + n + " is empty");
            } else {
                System.out.println("table " + n + " length is " + this.surrogateTable[n].length);
            }
            ++n;
        }
    }

    public static OraLinguistic buildFromCharSet(CharacterConverters characterConverters, int n) {
        int n2;
        OraLinguisticSetter oraLinguisticSetter = new OraLinguisticSetter();
        oraLinguisticSetter.setSortName("BINARY");
        oraLinguisticSetter.setSortId(Integer.toString(n + 8192));
        int n3 = 31;
        int n4 = 2;
        Vector vector = new Vector();
        characterConverters.extractCodepoints(vector);
        Vector[] vectorArray = new Vector[16];
        int[] nArray = new int[65536];
        int n5 = 0;
        int[][] nArrayArray = null;
        int n6 = 0;
        while (n6 < vector.size()) {
            int n7 = ((int[])vector.elementAt(n6))[1];
            n5 = OraLinguisticSetter.combineKey(n3, 1, 31);
            n3 += n4;
            if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                n2 = n7 >>> 16;
                int n8 = n7 & 0xFFFF;
                if (n2 >= 55296 && n2 <= 56319 && n8 >= 56320 && n8 <= 57343) {
                    if (nArrayArray == null) {
                        nArrayArray = new int[1024][];
                    }
                    OraLinguisticSetter.processSurrogate(nArrayArray, n2, n8, n5);
                }
            } else {
                nArray[n7] = n5;
            }
            ++n6;
        }
        if (nArrayArray != null) {
            OraLinguisticSetter.compressSurrogateTables(nArrayArray, nArray, vectorArray);
        }
        if (vectorArray != null) {
            oraLinguisticSetter.setSurrogateTable(vectorArray);
        }
        int[] nArray2 = new int[256];
        n2 = OraLinguisticSetter.compressIntArray(nArray, nArray2);
        oraLinguisticSetter.setCollationLevel1(nArray2);
        oraLinguisticSetter.setCollationLevel2(n2, nArray);
        return oraLinguisticSetter;
    }

    static void processSurrogate(int[][] object, int n, int n2, int n3) {
        int n4 = n - 55296;
        int n5 = n2 - 56320;
        if (object == null) {
            object = new int[1024][];
        }
        if (object[n4] == null) {
            object[n4] = new int[1024];
        }
        object[n4][n5] = n3;
    }

    static void compressSurrogateTables(int[][] nArray, int[] nArray2, Vector[] vectorArray) {
        if (nArray == null) {
            return;
        }
        int n = 0;
        int n2 = 55296;
        while (n2 < 56319) {
            int n3 = n2 - 55296;
            int n4 = n3 >> 6;
            int[] nArray3 = nArray[n3];
            if (nArray3 != null) {
                int n5;
                if (vectorArray[n4] == null) {
                    vectorArray[n4] = new Vector();
                    n = 0;
                }
                nArray2[n2] = n5 = -3866624 + n;
                int n6 = 0;
                while (n6 < 1024) {
                    vectorArray[n4].addElement(new Integer(nArray[n3][n6]));
                    ++n6;
                }
                n += 1024;
            }
            ++n2;
        }
    }

    static int compressIntArray(int[] nArray, int[] nArray2) {
        nArray2[0] = 0;
        int n = 256;
        int n2 = 1;
        while (n2 < 256) {
            int n3;
            int n4 = 0;
            while (n4 < n) {
                n3 = 0;
                while (n3 < (256 < n - n4 ? 256 : n - n4)) {
                    int n5 = nArray[n4 + n3];
                    int n6 = n2 << 8;
                    int n7 = nArray[n6 | n3];
                    if (n5 != n7) break;
                    ++n3;
                }
                if (n3 == (256 < n - n4 ? 256 : n - n4)) break;
                ++n4;
            }
            nArray2[n2] = n4;
            n3 = (n2 << 8) + (n - n4);
            while (n3 < n2 + 1 << 8) {
                nArray[n++] = nArray[n3];
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    private static int combineKey(int n, int n2, int n3) {
        if (((long)n & 0xFFFFFFFFL) >= 0xFFF00000L) {
            return n;
        }
        return (n << 16) + (n2 << 8) + n3;
    }

    public void setLatinOneTable() {
        this.LatinOneTable = new int[257][2];
        if (this.collationLevel2[0] == 0) {
            this.LatinOneTable[0][0] = 1;
            this.LatinOneTable[0][1] = 0;
        }
        int n = 1;
        while (n <= 255) {
            int n2 = this.collationLevel2[n];
            if (this.isExpanding(n2)) {
                int n3 = this.getIndex(n2);
                int[] nArray = this.getExpandExpCharKey(n3);
                if (nArray.length > 2) {
                    this.LatinOneTable = null;
                    return;
                }
                this.LatinOneTable[n][0] = nArray[0];
                this.LatinOneTable[n][1] = nArray.length > 1 ? nArray[1] : 0;
            } else if (this.isZero(n2)) {
                this.LatinOneTable[n][0] = -65536;
                this.LatinOneTable[n][1] = n << 16;
            } else {
                this.LatinOneTable[n][0] = n2;
                this.LatinOneTable[n][1] = 0;
            }
            ++n;
        }
    }
}

