/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.hibernate.HibernateAccessor;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateInterceptor
extends HibernateAccessor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Session session = this.getSession();
        boolean existingTransaction = SessionFactoryUtils.isSessionTransactional(session, this.getSessionFactory());
        if (existingTransaction) {
            this.logger.debug((Object)"Found thread-bound Session for HibernateInterceptor");
        } else {
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(session, existingTransaction);
            Object object = retVal;
            return object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after HibernateInterceptor");
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
            } else {
                TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            }
        }
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
    }
}

