/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.dao;

import com.posdata.glue.PosException;
import com.posdata.glue.dao.PosBadSqlGrammarException;
import com.posdata.glue.dao.PosDaoException;
import com.posdata.glue.dao.PosDataIntegrityViolationException;
import com.posdata.glue.dao.PosGenericDao;
import com.posdata.glue.dao.PosJdbcTemplate;
import com.posdata.glue.dao.PosQueryStringHelper;
import com.posdata.glue.dao.PosUncategorizedSQLException;
import com.posdata.glue.dao.manager.PosColumnManager;
import com.posdata.glue.dao.manager.PosQueryDefinition;
import com.posdata.glue.dao.manager.PosQueryManager;
import com.posdata.glue.dao.sequence.PosSequence;
import com.posdata.glue.dao.sequence.PosSequenceFactory;
import com.posdata.glue.dao.vo.PosAuditAttributes;
import com.posdata.glue.dao.vo.PosColumnDef;
import com.posdata.glue.dao.vo.PosPageSet;
import com.posdata.glue.dao.vo.PosParameter;
import com.posdata.glue.dao.vo.PosRowImpl;
import com.posdata.glue.dao.vo.PosRowSet;
import com.posdata.glue.dao.vo.PosRowSetImpl;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.object.SqlUpdate;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.SimpleNativeJdbcExtractor;

public class PosJdbcDao
extends JdbcDaoSupport
implements PosGenericDao {
    protected final PosLog logger = PosLogFactory.getLogger(this.getClass());
    private PosQueryManager a;
    private boolean b = false;
    protected PosColumnManager columnMgr;
    protected PosSequence sequence;
    protected static String jdbcDriverName;
    protected boolean isColumnDefInfoCached;
    protected LobHandler lobhandler;

    public PosRowSet find(String string) {
        return this.find(string, null);
    }

    public PosRowSet find(String string, PosParameter posParameter) {
        return this.find(string, null, posParameter);
    }

    public PosRowSet find(String string, String string2, PosParameter posParameter) {
        return this.find(string, string2, null, posParameter);
    }

    public PosRowSet find(String string, String string2, String string3, PosParameter posParameter) {
        PosQueryDefinition posQueryDefinition = this.getQueryDefinition(string);
        String string4 = PosQueryStringHelper.createQueryStmtWhereOrderByClause(posQueryDefinition.getQueryStatement(), string2, string3);
        return this.findByQueryStatementInternal(string, string4, posParameter);
    }

    public PosRowSet findByQueryStatement(String string) {
        return this.findByQueryStatementInternal(null, string, null);
    }

    public PosRowSet findByQueryStatement(String string, PosParameter posParameter) {
        return this.findByQueryStatementInternal(null, string, posParameter);
    }

    public PosRowSet findByQueryStatement(String string, String string2, PosParameter posParameter) {
        return this.findByQueryStatement(string, string2, null, posParameter);
    }

    public PosRowSet findByQueryStatement(String string, String string2, String string3, PosParameter posParameter) {
        return this.findByQueryStatementInternal(null, PosQueryStringHelper.createQueryStmtWhereOrderByClause(string, string2, string3), posParameter);
    }

    protected PosRowSet findByQueryStatementInternal(String string, String string2, PosParameter posParameter) {
        List list = null;
        try {
            list = posParameter != null ? this.getJdbcTemplate().queryForList(string2, posParameter.whereClauseParamsToArray()) : this.getJdbcTemplate().queryForList(string2);
        }
        catch (DataAccessException dataAccessException) {
            PosDaoException posDaoException = this.handleDataAccessException(dataAccessException);
            if (posDaoException.getSql() == null) {
                posDaoException.setSql(string2);
            }
            throw posDaoException;
        }
        PosPageSet posPageSet = this.createRowSet(list);
        if (this.isColumnDefInfoCached) {
            PosColumnDef[] posColumnDefArray = posParameter != null ? this.columnMgr.getColumnDefinition(this.getDataSource(), string2, posParameter.whereClauseParamsToArray()) : this.columnMgr.getColumnDefinition(this.getDataSource(), string2, null);
            posPageSet.setColumnDefs(posColumnDefArray);
        }
        if (string != null) {
            posPageSet.setQueryKey(string);
        }
        return posPageSet;
    }

    protected PosPageSet createRowSet(List list) {
        int n = list.size();
        ArrayList<PosRowImpl> arrayList = new ArrayList<PosRowImpl>(n);
        int n2 = 0;
        while (n2 < n) {
            PosRowImpl posRowImpl = new PosRowImpl((Map)list.get(n2));
            arrayList.add(posRowImpl);
            ++n2;
        }
        return new PosRowSetImpl(arrayList);
    }

    public int update(String string, PosParameter posParameter) {
        PosQueryDefinition posQueryDefinition = this.getQueryDefinition(string);
        return this.executeDML(posQueryDefinition.getQueryStatement(), posParameter, 2);
    }

    public int updateByQueryStatement(String string, PosParameter posParameter) {
        return this.executeDML(string, posParameter, 2);
    }

    public int insert(String string, PosParameter posParameter) {
        PosQueryDefinition posQueryDefinition = this.getQueryDefinition(string);
        return this.executeDML(posQueryDefinition.getQueryStatement(), posParameter, 3);
    }

    public int insertByQueryStatement(String string, PosParameter posParameter) {
        return this.executeDML(string, posParameter, 3);
    }

    public int delete(String string, PosParameter posParameter) {
        PosQueryDefinition posQueryDefinition = this.getQueryDefinition(string);
        return this.executeDML(posQueryDefinition.getQueryStatement(), posParameter, 4);
    }

    public int deleteByQueryStatement(String string, PosParameter posParameter) {
        return this.executeDML(string, posParameter, 4);
    }

    protected int executeDML(String string, PosParameter posParameter, int n) throws PosDaoException {
        int n2 = 0;
        Object[] objectArray = null;
        if (posParameter != null) {
            objectArray = this.toObjectArray(posParameter, n);
        }
        try {
            if (objectArray != null && this.isBoundAttributeForLob(objectArray)) {
                this.executeDMLforLob(string, objectArray);
            } else {
                n2 = objectArray != null ? this.getJdbcTemplate().update(string, objectArray) : this.getJdbcTemplate().update(string);
            }
        }
        catch (DataAccessException dataAccessException) {
            PosDaoException posDaoException = this.handleDataAccessException(dataAccessException);
            if (posDaoException.getSql() == null) {
                posDaoException.setSql(string);
            }
            throw posDaoException;
        }
        return n2;
    }

    private Object[] toObjectArray(PosParameter posParameter, int n) {
        Object[] objectArray = null;
        if (n == 3) {
            if (this.b) {
                LinkedList linkedList = new LinkedList(posParameter.getValueParameters());
                linkedList.addAll(this.createAuditAttributeValues(posParameter, 3));
                objectArray = linkedList.toArray();
            } else {
                objectArray = posParameter.valueParamsToArray();
            }
        } else if (n == 2) {
            LinkedList linkedList = new LinkedList(posParameter.getValueParameters());
            if (this.b) {
                linkedList.addAll(this.createAuditAttributeValues(posParameter, 2));
            }
            linkedList.addAll(posParameter.getWhereClauseParamters());
            objectArray = linkedList.toArray();
        } else if (n == 4) {
            objectArray = posParameter.whereClauseParamsToArray();
        }
        return objectArray;
    }

    public PosQueryManager getQueryManager() {
        return this.a;
    }

    public void setQueryManager(PosQueryManager posQueryManager) {
        this.a = posQueryManager;
    }

    protected PosDaoException handleDataAccessException(DataAccessException dataAccessException) {
        PosDaoException posDaoException = null;
        if (dataAccessException instanceof BadSqlGrammarException) {
            BadSqlGrammarException badSqlGrammarException = (BadSqlGrammarException)dataAccessException;
            posDaoException = new PosBadSqlGrammarException(badSqlGrammarException.getMessage(), (Throwable)badSqlGrammarException);
            posDaoException.setErrorCode(badSqlGrammarException.getSQLException().getErrorCode());
            posDaoException.setSql(badSqlGrammarException.getSql());
        } else if (dataAccessException instanceof DataIntegrityViolationException) {
            DataIntegrityViolationException dataIntegrityViolationException = (DataIntegrityViolationException)dataAccessException;
            posDaoException = new PosDataIntegrityViolationException(dataIntegrityViolationException.getMessage(), dataIntegrityViolationException.getCause());
        } else if (dataAccessException instanceof UncategorizedSQLException) {
            UncategorizedSQLException uncategorizedSQLException = (UncategorizedSQLException)dataAccessException;
            posDaoException = new PosUncategorizedSQLException(uncategorizedSQLException.getMessage(), uncategorizedSQLException.getCause());
            posDaoException.setErrorCode(uncategorizedSQLException.getSQLException().getErrorCode());
            posDaoException.setSql(uncategorizedSQLException.getSql());
        } else {
            posDaoException = new PosDaoException(dataAccessException.getMessage(), dataAccessException.getCause());
        }
        return posDaoException;
    }

    protected PosQueryDefinition getQueryDefinition(String string) throws PosDaoException {
        PosQueryDefinition posQueryDefinition = this.a.getQueryDefinition(string);
        if (posQueryDefinition == null) {
            throw new PosDaoException("Incorrect query id [" + string + "]");
        }
        return posQueryDefinition;
    }

    protected PosRowSet findForNavigationPageInternal(String string, PosParameter posParameter, int n, int n2) {
        PosJdbcTemplate posJdbcTemplate = (PosJdbcTemplate)this.getJdbcTemplate();
        posJdbcTemplate.setFetchSize(100);
        Object[] objectArray = posParameter != null ? posParameter.whereClauseParamsToArray() : null;
        List list = posJdbcTemplate.query(string, objectArray, n, n2);
        String string2 = PosQueryStringHelper.getCountQuery(string);
        int n3 = posJdbcTemplate.queryForInt(string2, objectArray);
        PosPageSet posPageSet = this.createRowSet(list);
        if (this.isColumnDefInfoCached) {
            PosColumnDef[] posColumnDefArray = posParameter != null ? this.columnMgr.getColumnDefinition(this.getDataSource(), string, posParameter.whereClauseParamsToArray()) : this.columnMgr.getColumnDefinition(this.getDataSource(), string, null);
            posPageSet.setColumnDefs(posColumnDefArray);
        }
        posPageSet.setTotalRowCount(n3);
        posPageSet.setCurrentPage(n2);
        posPageSet.setPageSize(n);
        return posPageSet;
    }

    protected JdbcTemplate createJdbcTemplate(DataSource dataSource) {
        PosJdbcTemplate posJdbcTemplate = new PosJdbcTemplate(dataSource);
        this.setJdbcTemplate(posJdbcTemplate);
        this.registerJdbcDriverInformation();
        this.registerSequenceIncrementer();
        this.registerLobHandler();
        return posJdbcTemplate;
    }

    public int update(String string) {
        return this.update(string, null);
    }

    public int updateByQueryStatement(String string) {
        return this.updateByQueryStatement(string, null);
    }

    public int insert(String string) {
        return this.insert(string, null);
    }

    public int insertByQueryStatement(String string) {
        return this.insertByQueryStatement(string, null);
    }

    public int delete(String string) {
        return this.delete(string, null);
    }

    public int deleteByQueryStatement(String string) {
        return this.deleteByQueryStatement(string, null);
    }

    public void setAuditAttributeOption(boolean bl) {
        this.b = bl;
    }

    protected List createAuditAttributeValues(PosParameter posParameter) {
        PosAuditAttributes posAuditAttributes = posParameter.getAuditAttributes();
        if (posAuditAttributes == null) {
            throw new PosDaoException("PosParameter\ub97c \uc0dd\uc131\ud560 \ub54c PosAuditAttribute\ub97c \ub123\uc5b4\uc8fc\uc138\uc694. new PosParamter(context.getAuditAttribute());");
        }
        ArrayList<Object> arrayList = posAuditAttributes.getInsertAuditValue();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            arrayList.add(posAuditAttributes.getObjectType());
            arrayList.add(posAuditAttributes.getObjectId());
            arrayList.add(posAuditAttributes.getProgramId());
            arrayList.add(new Timestamp(System.currentTimeMillis()));
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List createAuditAttributeValues(PosParameter posParameter, int n) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        List list = null;
        PosAuditAttributes posAuditAttributes = posParameter.getAuditAttributes();
        if (posAuditAttributes == null) throw new PosDaoException("Yout have to insert PosAuditAttributs at PosParameter(new PosParamter(context.getAuditAttribute());");
        if (n == 2) {
            list = posAuditAttributes.getUpdateAuditValue();
            if (list != null) return list;
            return this.createAuditAttributeValues(posParameter);
        }
        if (n != 3) throw new PosDaoException("Unsupport DML TYPE: " + n);
        list = posAuditAttributes.getInsertAuditValue();
        if (list != null) return list;
        list = this.createAuditAttributeValues(posParameter);
        list.addAll(list);
        return list;
    }

    private void registerJdbcDriverInformation() {
        try {
            if (this.getDataSource() instanceof SingleConnectionDataSource) {
                jdbcDriverName = "Dummy Single Connection Driver for Master Data Module";
                this.debug("Loaded JDBC Driver: " + jdbcDriverName);
                this.debug("real dbms information will be specified atfer this processing phase...");
            } else {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                jdbcDriverName = databaseMetaData.getDriverName();
                this.debug("Loaded JDBC Driver: " + jdbcDriverName);
                this.debug("Loaded JDBC Driver Version: " + databaseMetaData.getDriverVersion());
                this.debug("DBMS Name: " + databaseMetaData.getDatabaseProductName());
                this.debug("DBMS Version: " + databaseMetaData.getDatabaseProductVersion());
                this.debug("DBMS URL: " + databaseMetaData.getURL());
                this.debug("Batch Update: " + databaseMetaData.supportsBatchUpdates());
            }
        }
        catch (Exception exception) {
            this.logger.logWarn("No Suitable Driver: " + exception.getMessage());
            jdbcDriverName = "No Suitable Driver";
        }
        PosQueryStringHelper.setJdbcDriverName(jdbcDriverName);
    }

    protected void debug(Object object) {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug(object);
        }
    }

    public Connection getDBConnection() {
        return this.getConnection();
    }

    public CallableStatement getCallableStatement(String string) {
        CallableStatement callableStatement = null;
        PosQueryDefinition posQueryDefinition = this.getQueryDefinition(string);
        String string2 = posQueryDefinition.getQueryStatement();
        try {
            callableStatement = this.getConnection().prepareCall(string2);
            int n = posQueryDefinition.getFetchSize();
            if (n > 0) {
                callableStatement.setFetchSize(n);
            }
        }
        catch (Exception exception) {
            throw new PosException("Can not create CallableStatement!! SQL [" + string2 + "]", exception);
        }
        return callableStatement;
    }

    private void registerSequenceIncrementer() {
        try {
            this.sequence = PosSequenceFactory.createSequence(this.getDataSource(), jdbcDriverName);
            this.logger.logInfo("Sequence Increamenter is constructed successfully... : " + this.sequence);
        }
        catch (Exception exception) {
            this.logger.logWarn("Fail to instantiate PosSequence: Driver[" + jdbcDriverName + "] - " + exception.getMessage());
        }
    }

    public PosSequence getSequence() {
        if (this.sequence == null) {
            throw new PosException("Cannot get sequence: sequence object is null");
        }
        return this.sequence;
    }

    public void setColumnDefCache(boolean bl) {
        this.isColumnDefInfoCached = true;
        this.columnMgr = new PosColumnManager();
    }

    public boolean isColumnDefInfoCached() {
        return this.isColumnDefInfoCached;
    }

    private void registerLobHandler() {
        if (PosQueryStringHelper.isOracleDriver()) {
            OracleLobHandler oracleLobHandler = new OracleLobHandler();
            oracleLobHandler.setNativeJdbcExtractor((NativeJdbcExtractor)new SimpleNativeJdbcExtractor());
            this.lobhandler = oracleLobHandler;
            this.logger.logInfo("Oracle Lob Handler is registered");
        } else {
            this.lobhandler = new DefaultLobHandler();
            this.logger.logInfo("Default Lob Handler is registered");
        }
    }

    protected boolean isBoundAttributeForLob(Object[] objectArray) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] instanceof File || objectArray[n2] instanceof byte[] || objectArray[n2] instanceof InputStream) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected int executeDMLforLob(String string, Object[] objectArray) {
        if (objectArray == null) {
            throw new PosException("Value of parameter is null. In doing DML for lob type, it must have a parameter value");
        }
        SqlUpdate sqlUpdate = new SqlUpdate(this.getDataSource(), string);
        int n = 0;
        while (n < objectArray.length) {
            int n2 = 12;
            if (objectArray[n] instanceof File || objectArray[n] instanceof byte[] || objectArray[n] instanceof InputStream) {
                Object object;
                n2 = 2004;
                objectArray[n] = object = this.createSqlLobValue(objectArray[n]);
            } else if (objectArray[n] instanceof Date) {
                n2 = 93;
            }
            sqlUpdate.declareParameter(new SqlParameter(n2));
            ++n;
        }
        sqlUpdate.compile();
        return sqlUpdate.update(objectArray);
    }

    private Object createSqlLobValue(Object object) {
        SqlLobValue sqlLobValue = null;
        try {
            if (object instanceof File) {
                File file = (File)object;
                FileInputStream fileInputStream = new FileInputStream(file);
                sqlLobValue = new SqlLobValue((InputStream)fileInputStream, (int)file.length(), this.lobhandler);
            } else if (object instanceof byte[]) {
                sqlLobValue = new SqlLobValue((byte[])object, this.lobhandler);
            } else if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                sqlLobValue = new SqlLobValue(inputStream, inputStream.available(), this.lobhandler);
            }
        }
        catch (IOException iOException) {
            throw new PosException("Fail to process lob type attribute :" + iOException.getMessage());
        }
        return sqlLobValue;
    }

    public PosRowSet findForNavigationPage(String string, int n, int n2) {
        return this.findForNavigationPage(string, null, null, null, n, n2);
    }

    public PosRowSet findForNavigationPage(String string, PosParameter posParameter, int n, int n2) {
        return this.findForNavigationPage(string, null, null, posParameter, n, n2);
    }

    public PosRowSet findForNavigationPage(String string, String string2, PosParameter posParameter, int n, int n2) {
        return this.findForNavigationPage(string, string2, null, posParameter, n, n2);
    }

    public PosRowSet findForNavigationPage(String string, String string2, String string3, PosParameter posParameter, int n, int n2) {
        PosQueryDefinition posQueryDefinition = this.getQueryDefinition(string);
        String string4 = PosQueryStringHelper.createQueryStmtWhereOrderByClause(posQueryDefinition.getQueryStatement(), string2, string3);
        return this.findForNavigationPageInternal(string4, posParameter, n, n2);
    }

    public PosRowSet findForNavigationPageByQuery(String string, int n, int n2) {
        return this.findForNavigationPageByQuery(string, null, null, null, n, n2);
    }

    public PosRowSet findForNavigationPageByQuery(String string, PosParameter posParameter, int n, int n2) {
        return this.findForNavigationPageByQuery(string, null, null, posParameter, n, n2);
    }

    public PosRowSet findForNavigationPageByQuery(String string, String string2, PosParameter posParameter, int n, int n2) {
        return this.findForNavigationPageByQuery(string, string2, null, posParameter, n, n2);
    }

    public PosRowSet findForNavigationPageByQuery(String string, String string2, String string3, PosParameter posParameter, int n, int n2) {
        String string4 = PosQueryStringHelper.createQueryStmtWhereOrderByClause(string, string2, string3);
        return this.findForNavigationPageInternal(string4, posParameter, n, n2);
    }

    public int[] batchUpdate(String string, PosParameter[] posParameterArray) {
        if (posParameterArray == null || posParameterArray.length == 0) {
            throw new IllegalArgumentException("Check ur PosParameter values");
        }
        int n = posParameterArray.length;
        PosQueryDefinition posQueryDefinition = this.getQueryDefinition(string);
        String string2 = posQueryDefinition.getQueryStatement();
        int n2 = this.getDmlType(string2);
        int[] nArray = this.getJdbcTemplate().batchUpdate(string2, new BatchPreparedStatementSetter(this, posParameterArray, n2, n){
            final PosJdbcDao a;
            private final PosParameter[] b;
            private final int c;
            private final int d;
            {
                this.a = posJdbcDao;
                this.b = posParameterArray;
                this.c = n;
                this.d = n2;
            }

            public void setValues(PreparedStatement preparedStatement, int n) throws SQLException {
                Object[] objectArray = PosJdbcDao.a(this.a, this.b[n], this.c);
                if (objectArray == null || objectArray.length == 0) {
                    throw new PosDaoException("Invalid Parameters");
                }
                int n2 = 0;
                while (n2 < objectArray.length) {
                    preparedStatement.setObject(n2 + 1, objectArray[n2]);
                    ++n2;
                }
            }

            public int getBatchSize() {
                return this.d;
            }
        });
        return nArray;
    }

    private int getDmlType(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Query is invalid : [" + string + "]");
        }
        String string2 = string.trim();
        string2 = string2.substring(0, 10);
        string2 = string2.toLowerCase();
        int n = -1;
        if (string2.startsWith("update")) {
            n = 2;
        } else if (string2.startsWith("insert")) {
            n = 3;
        } else if (string2.startsWith("delete")) {
            n = 4;
        } else {
            throw new PosDaoException("Invalid Query Statement [" + string + "]");
        }
        return n;
    }

    public boolean isAuditAttributeApplied() {
        return this.b;
    }

    static Object[] a(PosJdbcDao posJdbcDao, PosParameter posParameter, int n) {
        return posJdbcDao.toObjectArray(posParameter, n);
    }
}

