/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.scheduling.server;

import com.posdata.glue.context.PosContext;
import com.posdata.glue.scheduling.PosJobScheduler;
import com.posdata.glue.scheduling.remote.PosDefaultJobEventProcessor;
import com.posdata.glue.scheduling.server.PosGlueServerHandler;
import com.posdata.glue.scheduling.server.PosHttpServerProtocolCodecFactory;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class PosGlueSchedulerHttpServer {
    private static int b = 8805;
    public static final String VERSION_STRING = "GlueScheduler HttpServer 1.0";
    protected static final PosLog log;
    private PosJobScheduler c;
    private int d;
    static Class a;

    static {
        Class<?> clazz = a;
        if (clazz == null) {
            try {
                clazz = a = Class.forName("com.posdata.glue.scheduling.server.PosGlueSchedulerHttpServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = PosLogFactory.getLogger(clazz);
    }

    public PosGlueSchedulerHttpServer() {
        String string = System.getProperty("glue.scheduler.server.port");
        try {
            if (string != null && string.length() > 0) {
                this.d = Integer.valueOf(string);
            }
        }
        catch (Exception exception) {
            log.logError("Fail to configure server port:" + string);
            log.logError("so, default server port is configured :" + b);
            this.d = b;
        }
    }

    public static void main(String[] stringArray) {
        try {
            PosGlueSchedulerHttpServer posGlueSchedulerHttpServer = new PosGlueSchedulerHttpServer();
            posGlueSchedulerHttpServer.runGlueScheduler();
            posGlueSchedulerHttpServer.runGlueHttpServer(posGlueSchedulerHttpServer.d);
        }
        catch (Throwable throwable) {
            log.logFatal("Fail to execute GlueSchedulerHttpServer:" + throwable.getMessage(), throwable);
            System.exit(-1);
        }
    }

    protected void runGlueScheduler() {
        this.c = (PosJobScheduler)((Object)PosContext.getBeanFactory().getBeanObject("scheduler"));
    }

    private void runGlueHttpServer(int n) throws IOException {
        SocketAcceptor socketAcceptor = new SocketAcceptor();
        SocketAcceptorConfig socketAcceptorConfig = new SocketAcceptorConfig();
        socketAcceptorConfig.setReuseAddress(true);
        socketAcceptorConfig.getFilterChain().addLast("protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new PosHttpServerProtocolCodecFactory()));
        socketAcceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        socketAcceptor.bind((SocketAddress)new InetSocketAddress(n), (IoHandler)new PosGlueServerHandler(new PosDefaultJobEventProcessor(this.c)), (IoServiceConfig)socketAcceptorConfig);
        log.logInfo("Server now listening on port " + n);
    }
}

