/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.transaction;

import com.posdata.glue.PosException;
import com.posdata.glue.transaction.PosDefaultTransactionDefinition;
import com.posdata.glue.transaction.PosTransactionDefinition;
import com.posdata.glue.transaction.PosTransactionManager;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class PosDataSourceTransactionManager
implements PosTransactionManager {
    protected PosLog log = PosLogFactory.getLogger(this.getClass());
    private DataSourceTransactionManager a;
    private PosTransactionDefinition b;
    private ThreadLocal c = new ThreadLocal();

    public PosDataSourceTransactionManager() {
        this.a = new DataSourceTransactionManager();
        this.b = new PosDefaultTransactionDefinition();
    }

    public PosDataSourceTransactionManager(DataSource dataSource) {
        this();
        this.a.setDataSource(dataSource);
    }

    public void setDataSource(DataSource dataSource) {
        this.a.setDataSource(dataSource);
    }

    public void setTransactionDefinition(PosTransactionDefinition posTransactionDefinition) {
        this.b = posTransactionDefinition;
        this.log.logInfo("[" + posTransactionDefinition.getName() + "] transaction is re-configured -> " + posTransactionDefinition.toString());
    }

    public void startTransaction() throws PosException {
        TransactionStatus transactionStatus = this.getTransactionStatus();
        if (transactionStatus == null) {
            transactionStatus = this.a.getTransaction((TransactionDefinition)this.b);
            this.c.set(transactionStatus);
            this.log.logInfo("Glue: Transaction Start");
        } else {
            this.log.logFatal("------------------------------------------");
            this.log.logFatal("Already transaction was started!!");
            this.log.logFatal("Do not invoke 'startTransaction' twice!!");
            this.log.logFatal("------------------------------------------");
        }
    }

    public boolean commit() throws PosException {
        TransactionStatus transactionStatus;
        block3: {
            try {
                transactionStatus = this.getTransactionStatus();
                if (transactionStatus != null) break block3;
                this.log.logWarn("Glue: Transaction Status is empty. Commit operation is aborted");
                return false;
            }
            catch (TransactionException transactionException) {
                throw new PosException(transactionException.getMessage(), transactionException);
            }
        }
        this.a.commit(transactionStatus);
        this.log.logInfo("Glue: Commit Complete");
        return true;
    }

    public boolean rollback() throws PosException {
        TransactionStatus transactionStatus;
        block3: {
            try {
                transactionStatus = this.getTransactionStatus();
                if (transactionStatus != null) break block3;
                this.log.logWarn("Glue: Transaction Status is empty. Rollback operation is aborted");
                return false;
            }
            catch (TransactionException transactionException) {
                throw new PosException(transactionException.getMessage(), transactionException);
            }
        }
        this.a.rollback(transactionStatus);
        this.log.logInfo("Glue: Rollback Complete");
        return true;
    }

    protected TransactionDefinition getDefinition(int n, boolean bl) {
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition(0);
        defaultTransactionDefinition.setTimeout(5000);
        defaultTransactionDefinition.setReadOnly(bl);
        defaultTransactionDefinition.setIsolationLevel(n);
        defaultTransactionDefinition.setName("glue-transaction-definition");
        this.log.logInfo("glue-transaction-definition is created: " + defaultTransactionDefinition.toString());
        return defaultTransactionDefinition;
    }

    protected DataSourceTransactionManager getDataSourceTransactionManager() {
        return this.a;
    }

    protected TransactionStatus getTransactionStatus() {
        return (TransactionStatus)this.c.get();
    }

    public void clearTransactionStatus() {
        this.c.set(null);
        this.log.logInfo("Glue: Transaction Status is Cleared");
    }
}

