/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.util;

import com.posdata.glue.PosException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PosExcelReader {
    POIFSFileSystem a;
    HSSFWorkbook b;
    HSSFSheet c;
    HSSFRow d;

    public PosExcelReader(String string) {
        try {
            this.a = new POIFSFileSystem((InputStream)new FileInputStream(string));
            this.b = new HSSFWorkbook(this.a);
            this.c = this.b.getSheetAt(0);
        }
        catch (IOException iOException) {
            throw new PosException("Cannot instantiate PosExcelReader: " + iOException.getMessage(), iOException);
        }
    }

    public PosExcelReader(InputStream inputStream) {
        try {
            this.b = new HSSFWorkbook(inputStream);
            this.c = this.b.getSheetAt(0);
        }
        catch (IOException iOException) {
            throw new PosException("Cannot instantiate PosExcelReader: " + iOException.getMessage(), iOException);
        }
    }

    public void setSheet(String string) {
        this.c = this.b.getSheet(string);
    }

    public void setSheet(int n) {
        this.c = this.b.getSheetAt(n);
    }

    public int getFirstRowNum() {
        return this.c.getFirstRowNum();
    }

    public int getLastRowNum() {
        return this.c.getLastRowNum();
    }

    public void setRow(int n) {
        if (this.c == null) {
            throw new PosException("You didn't set sheet value");
        }
        this.d = this.c.getRow(n);
    }

    public boolean isValidRow(int n) {
        this.d = this.c.getRow(n);
        return this.d != null;
    }

    public Object getCellValue(int n) {
        if (this.d == null) {
            throw new PosException("You didn't set row value");
        }
        HSSFCell hSSFCell = this.d.getCell((short)n);
        if (hSSFCell == null) {
            return null;
        }
        switch (hSSFCell.getCellType()) {
            case 3: {
                return null;
            }
            case 1: {
                return hSSFCell.getRichStringCellValue().getString().trim();
            }
            case 4: {
                return new Boolean(hSSFCell.getBooleanCellValue());
            }
            case 0: {
                if (this.isDateValue(hSSFCell)) {
                    return hSSFCell.getDateCellValue();
                }
                return new Double(hSSFCell.getNumericCellValue());
            }
            case 2: {
                return new Double(hSSFCell.getNumericCellValue());
            }
        }
        throw new PosException("Can not return any values");
    }

    private boolean isDateValue(HSSFCell hSSFCell) {
        boolean bl = false;
        short s = hSSFCell.getCellStyle().getDataFormat();
        if (s > 13 && s < 23 || s > 175 && s != 177 && s != 179 && s < 198) {
            bl = true;
        }
        return bl;
    }
}

