/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.util.log;

import com.posdata.glue.PosException;
import com.posdata.glue.util.log.PosLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public class PosLogFactory {
    protected static boolean isLog4JAvailable;
    protected static boolean isJdk14Available;
    protected static Hashtable instances;
    static Class a;
    static Class b;
    static Class c;

    static {
        instances = new Hashtable();
        try {
            PosLogFactory.loadClass("org.apache.log4j.Logger");
            PosLogFactory.loadClass("org.apache.commons.logging.impl.Log4JLogger");
            isLog4JAvailable = true;
        }
        catch (Throwable throwable) {
            isLog4JAvailable = false;
        }
        try {
            PosLogFactory.loadClass("java.util.logging.Logger");
            PosLogFactory.loadClass("org.apache.commons.logging.impl.Jdk14Logger");
            isJdk14Available = true;
        }
        catch (Exception exception) {
            isJdk14Available = false;
        }
    }

    private static Class loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz2 = a;
            if (clazz2 == null) {
                try {
                    clazz2 = a = Class.forName("com.posdata.glue.util.log.PosLogFactory");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                }
            }
            clazz = clazz2.getClassLoader().loadClass(string);
        }
        return clazz;
    }

    public static PosLog getLogger(String string) {
        if (isLog4JAvailable) {
            return PosLogFactory.getLogger("PosLog4JLogger", string);
        }
        if (isJdk14Available) {
            return PosLogFactory.getLogger("PosJdk14Logger", string);
        }
        return PosLogFactory.getLogger("PosSimpleLogger", string);
    }

    public static PosLog getLogger(Class clazz) {
        return PosLogFactory.getLogger(clazz.getName());
    }

    public static PosLog getLogger(String string, String string2) {
        if (string == null) {
            throw new PosException("Logger class can not be NULL");
        }
        if (string2 == null) {
            throw new PosException("Logger instance name can not be NULL");
        }
        PosLog posLog = (PosLog)instances.get(string2);
        if (posLog == null) {
            posLog = PosLogFactory.newInstance(string, string2);
            instances.put(string2, posLog);
        }
        return posLog;
    }

    public static PosLog getLogger(String string, Class clazz) {
        return PosLogFactory.getLogger(string, clazz.getName());
    }

    private static PosLog newInstance(String string, String string2) {
        try {
            Class<?> clazz = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class<?> clazz2 = b;
                if (clazz2 == null) {
                    try {
                        clazz2 = b = Class.forName("com.posdata.glue.util.log.PosLog");
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                    }
                }
                clazz = classLoader.loadClass(String.valueOf(clazz2.getPackage().getName()) + "." + string);
            }
            Class[] classArray = new Class[1];
            Class<?> clazz3 = c;
            if (clazz3 == null) {
                try {
                    clazz3 = c = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (PosLog)constructor.newInstance(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PosException("Unable to load class for logger '" + string + "'");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PosException("Logger class does not have a single-arg constructor that takes an instance name");
        }
        catch (InstantiationException instantiationException) {
            throw new PosException("Unable to instantiate logger class '" + string + "', exception in constructor?");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PosException("Unable to instantiate logger class '" + string + "', exception in constructor?");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PosException("Unable to instantiate logger class '" + string + "', constructor not public");
        }
        catch (ClassCastException classCastException) {
            StringBuffer stringBuffer = new StringBuffer("Logger class '").append(string).append("' does not implement the '");
            Class<?> clazz = b;
            if (clazz == null) {
                try {
                    clazz = b = Class.forName("com.posdata.glue.util.log.PosLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new PosException(stringBuffer.append(clazz.getName()).toString());
        }
    }
}

