/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp.discovery;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoveryReceiver;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoverySender;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoverySenderThread;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IShutdownObservable;
import org.apache.jcs.engine.behavior.IShutdownObserver;

public class UDPDiscoveryService
implements IShutdownObserver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$socket$tcp$discovery$UDPDiscoveryService == null ? (class$org$apache$jcs$auxiliary$lateral$socket$tcp$discovery$UDPDiscoveryService = UDPDiscoveryService.class$("org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoveryService")) : class$org$apache$jcs$auxiliary$lateral$socket$tcp$discovery$UDPDiscoveryService));
    private static ClockDaemon senderDaemon;
    private Thread udpReceiverThread;
    private UDPDiscoveryReceiver receiver;
    private Map facades = new HashMap();
    private UDPDiscoverySenderThread sender = null;
    private String hostAddress = "unknown";
    private String discoveryAddress;
    private int discoveryPort;
    private int servicePort;
    private ITCPLateralCacheAttributes tcpLateralCacheAttributes;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$socket$tcp$discovery$UDPDiscoveryService;

    public UDPDiscoveryService(String discoveryAddress, int discoveryPort, int servicePort, ICompositeCacheManager cacheMgr) {
        ((IShutdownObservable)((Object)cacheMgr)).registerShutdownObserver(this);
        this.setDiscoveryAddress(discoveryAddress);
        this.setDiscoveryPort(discoveryPort);
        this.setServicePort(servicePort);
        try {
            this.hostAddress = InetAddress.getLocalHost().getHostAddress();
            if (log.isDebugEnabled()) {
                log.debug((Object)("hostAddress = [" + this.hostAddress + "]"));
            }
        }
        catch (UnknownHostException e1) {
            log.error((Object)"Couldn't get localhost address", (Throwable)e1);
        }
        try {
            this.receiver = new UDPDiscoveryReceiver(this, this.getDiscoveryAddress(), this.getDiscoveryPort(), cacheMgr);
            this.udpReceiverThread = new Thread(this.receiver);
            this.udpReceiverThread.setDaemon(true);
            this.udpReceiverThread.start();
        }
        catch (Exception e) {
            log.error((Object)("Problem creating UDPDiscoveryReceiver, address [" + this.getDiscoveryAddress() + "] port [" + this.getDiscoveryPort() + "] we won't be able to find any other caches"), (Throwable)e);
        }
        if (senderDaemon == null) {
            senderDaemon = new ClockDaemon();
            senderDaemon.setThreadFactory((ThreadFactory)new MyThreadFactory());
        }
        this.sender = new UDPDiscoverySenderThread(this.getDiscoveryAddress(), this.getDiscoveryPort(), this.hostAddress, this.getServicePort(), this.getCacheNames());
        senderDaemon.executePeriodically(30000L, (Runnable)this.sender, false);
    }

    public synchronized boolean addNoWaitFacade(LateralCacheNoWaitFacade facade, String cacheName) {
        boolean isNew = !this.facades.containsKey(cacheName);
        this.facades.put(cacheName, facade);
        if (isNew && this.sender != null) {
            this.sender.setCacheNames(this.getCacheNames());
        }
        return isNew;
    }

    protected void addNoWait(LateralCacheNoWait noWait) {
        LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(noWait.getCacheName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got facade for " + noWait.getCacheName() + " = " + facade));
        }
        if (facade != null) {
            boolean isNew = facade.addNoWait(noWait);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Called addNoWait, isNew = " + isNew));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Different nodes are configured differently.  Region [" + noWait.getCacheName() + "] is not configured to use the lateral cache."));
        }
    }

    /*
     * Loose catch block
     */
    protected void serviceRequestBroadcast() {
        block12: {
            UDPDiscoverySender sender;
            block11: {
                sender = null;
                sender = new UDPDiscoverySender(this.getDiscoveryAddress(), this.getDiscoveryPort());
                sender.passiveBroadcast(this.hostAddress, this.getServicePort(), this.getCacheNames());
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)"Called sender to issue a passive broadcast");
            }
            Object var4_2 = null;
            try {
                if (sender != null) {
                    sender.destroy();
                }
                break block12;
            }
            catch (Exception e2) {
                log.error((Object)"Problem closing Passive Broadcast sender, while servicing a request broadcast.", (Throwable)e2);
            }
            break block12;
            {
                catch (Exception e) {
                    log.error((Object)("Problem calling the UDP Discovery Sender. address [" + this.getDiscoveryAddress() + "] port [" + this.getDiscoveryPort() + "]"), (Throwable)e);
                    Object var4_3 = null;
                    try {
                        if (sender != null) {
                            sender.destroy();
                        }
                        break block12;
                    }
                    catch (Exception e2) {
                        log.error((Object)"Problem closing Passive Broadcast sender, while servicing a request broadcast.", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (sender != null) {
                        sender.destroy();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)"Problem closing Passive Broadcast sender, while servicing a request broadcast.", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    protected ArrayList getCacheNames() {
        ArrayList<String> keys = new ArrayList<String>();
        Set keySet = this.facades.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            keys.add(key);
        }
        return keys;
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Shutting down UDP discovery service receiver.");
        }
        try {
            this.receiver.shutdown();
            this.udpReceiverThread.interrupt();
        }
        catch (Exception e) {
            log.error((Object)"Problem interrupting UDP receiver thread.");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Shutting down UDP discovery service sender.");
        }
        try {
            senderDaemon.shutDown();
        }
        catch (Exception e) {
            log.error((Object)"Problem shutting down UDP sender.");
        }
    }

    protected void setDiscoveryAddress(String discoveryAddress) {
        this.discoveryAddress = discoveryAddress;
    }

    protected String getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    protected void setDiscoveryPort(int discoveryPort) {
        this.discoveryPort = discoveryPort;
    }

    protected int getDiscoveryPort() {
        return this.discoveryPort;
    }

    protected void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    protected int getServicePort() {
        return this.servicePort;
    }

    public void setTcpLateralCacheAttributes(ITCPLateralCacheAttributes tCPLateralCacheAttributes) {
        this.tcpLateralCacheAttributes = tCPLateralCacheAttributes;
    }

    public ITCPLateralCacheAttributes getTcpLateralCacheAttributes() {
        return this.tcpLateralCacheAttributes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

