/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.server.RMISocketFactory;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.RemoteUtils;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheServiceAdmin;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerAttributes;

public class RemoteCacheServerFactory
implements IRemoteCacheConstants {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServerFactory == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServerFactory = RemoteCacheServerFactory.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServerFactory));
    private static RemoteCacheServer remoteCacheServer;
    private static String serviceName;
    private static int DEFAULT_RMI_SOCKET_FACTORY_TIMEOUT_MS;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServerFactory;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;

    private RemoteCacheServerFactory() {
    }

    public static RemoteCacheServer getRemoteCacheServer() {
        return remoteCacheServer;
    }

    public static void startup(String host, int port, String propFile) throws IOException {
        if (remoteCacheServer != null) {
            throw new IllegalArgumentException("Server already started.");
        }
        Class clazz = class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer = RemoteCacheServerFactory.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServer")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;
        synchronized (clazz) {
            if (remoteCacheServer != null) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("ConfigFileName = [" + propFile + "]"));
            }
            try {
                RMISocketFactory.setSocketFactory(new RMISocketFactory(){

                    public Socket createSocket(String host, int port) throws IOException {
                        Socket socket = new Socket(host, port);
                        socket.setSoTimeout(DEFAULT_RMI_SOCKET_FACTORY_TIMEOUT_MS);
                        socket.setSoLinger(false, 0);
                        return socket;
                    }

                    public ServerSocket createServerSocket(int port) throws IOException {
                        return new ServerSocket(port);
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)"Problem setting custom RMI Socket Factory.", (Throwable)e);
            }
            RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
            rcsa.setConfigFileName(propFile);
            Properties prop = RemoteUtils.loadProps(propFile);
            String servicePortStr = prop.getProperty("remote.cache.service.port");
            int servicePort = -1;
            try {
                servicePort = Integer.parseInt(servicePortStr);
                rcsa.setServicePort(servicePort);
                log.debug((Object)("Remote cache service uses port number " + servicePort + "."));
            }
            catch (NumberFormatException ignore) {
                log.debug((Object)"Remote cache service port property remote.cache.service.port not specified.  An anonymous port will be used.");
            }
            String lccStr = prop.getProperty("remote.cluster.LocalClusterConsistency");
            if (lccStr == null) {
                lccStr = "true";
            }
            boolean lcc = Boolean.valueOf(lccStr);
            rcsa.setLocalClusterConsistency(lcc);
            String acgStr = prop.getProperty("remote.cluster.AllowClusterGet");
            if (acgStr == null) {
                acgStr = "true";
            }
            boolean acg = Boolean.valueOf(acgStr);
            rcsa.setAllowClusterGet(acg);
            remoteCacheServer = new RemoteCacheServer(rcsa);
            if (host == null) {
                host = "";
            }
            serviceName = prop.getProperty("remote.cache.service.name", IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL).trim();
            if (log.isInfoEnabled()) {
                log.info((Object)("Binding server to " + host + ":" + port + " with the name " + serviceName));
            }
            try {
                Naming.rebind("//" + host + ":" + port + "/" + serviceName, remoteCacheServer);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port);
            }
        }
    }

    static void shutdownImpl(String host, int port) throws IOException {
        if (remoteCacheServer == null) {
            return;
        }
        Class clazz = class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer = RemoteCacheServerFactory.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServer")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;
        synchronized (clazz) {
            if (remoteCacheServer == null) {
                return;
            }
            log.info((Object)("Unbinding host=" + host + ", port=" + port + ", serviceName=" + serviceName));
            try {
                Naming.unbind("//" + host + ":" + port + "/" + serviceName);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port + ", serviceName=" + serviceName);
            }
            catch (NotBoundException ex) {
                // empty catch block
            }
            remoteCacheServer.release();
            remoteCacheServer = null;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        String host;
        IRemoteCacheServiceAdmin admin;
        Remote obj;
        String registry;
        String serviceName;
        int port;
        Properties prop = args.length > 0 ? RemoteUtils.loadProps(args[args.length - 1]) : new Properties();
        try {
            port = Integer.parseInt(prop.getProperty("registry.port"));
        }
        catch (NumberFormatException ex) {
            port = 1099;
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-shutdown") != -1) {
            serviceName = prop.getProperty("remote.cache.service.name", IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL).trim();
            registry = "//:" + port + "/" + serviceName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("looking up server " + registry));
            }
            obj = Naming.lookup(registry);
            if (log.isDebugEnabled()) {
                log.debug((Object)"server found");
            }
            admin = (IRemoteCacheServiceAdmin)obj;
            try {
                admin.shutdown();
            }
            catch (Exception ex) {
                log.error((Object)"Problem calling shutdown.", (Throwable)ex);
            }
            log.debug((Object)"done.");
            System.exit(0);
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-stats") != -1) {
            log.debug((Object)"getting cache stats");
            try {
                serviceName = prop.getProperty("remote.cache.service.name", IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL).trim();
                registry = "//:" + port + "/" + serviceName;
                log.debug((Object)("looking up server " + registry));
                obj = Naming.lookup(registry);
                log.debug((Object)"server found");
                log.debug((Object)("obj = " + obj));
                admin = (IRemoteCacheServiceAdmin)obj;
                try {
                    System.out.println(admin.getStats().toString());
                    log.debug((Object)admin.getStats());
                }
                catch (Exception es) {
                    log.error((Object)es);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Problem getting stats.", (Throwable)ex);
            }
            log.debug((Object)"done.");
            System.exit(0);
        }
        if ((host = prop.getProperty("registry.host")) == null || host.trim().equals("") || host.trim().equals("localhost")) {
            log.debug((Object)"main> creating registry on the localhost");
            port = RemoteUtils.createRegistry(port);
        }
        log.debug((Object)"main> starting up RemoteCacheServer");
        RemoteCacheServerFactory.startup(host, port, args.length > 0 ? args[0] : null);
        log.debug((Object)"main> done");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_RMI_SOCKET_FACTORY_TIMEOUT_MS = 10000;
    }
}

