/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunner;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;

public class FJTaskRunnerGroup
implements Executor {
    protected final FJTaskRunner[] threads;
    protected final LinkedQueue entryQueue = new LinkedQueue();
    protected int activeCount = 0;
    protected int nstarted = 0;
    static final boolean COLLECT_STATS = true;
    long initTime = 0L;
    int entries = 0;
    static final int DEFAULT_SCAN_PRIORITY = 2;
    static final long SCANS_PER_SLEEP = 15L;
    static final long MAX_SLEEP_TIME = 100L;

    public FJTaskRunnerGroup(int groupSize) {
        this.threads = new FJTaskRunner[groupSize];
        this.initializeThreads();
        this.initTime = System.currentTimeMillis();
    }

    public void execute(Runnable r) throws InterruptedException {
        if (r instanceof FJTask) {
            this.entryQueue.put((FJTask)r);
        } else {
            this.entryQueue.put(new FJTask.Wrap(r));
        }
        this.signalNewTask();
    }

    public void executeTask(FJTask t) {
        try {
            this.entryQueue.put(t);
            this.signalNewTask();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void invoke(Runnable r) throws InterruptedException {
        InvokableFJTask w = new InvokableFJTask(r);
        this.entryQueue.put(w);
        this.signalNewTask();
        w.awaitTermination();
    }

    public void interruptAll() {
        Thread current = Thread.currentThread();
        boolean stopCurrent = false;
        for (int i = 0; i < this.threads.length; ++i) {
            FJTaskRunner t = this.threads[i];
            if (t == current) {
                stopCurrent = true;
                continue;
            }
            t.interrupt();
        }
        if (stopCurrent) {
            current.interrupt();
        }
    }

    public synchronized void setScanPriorities(int pri) {
        for (int i = 0; i < this.threads.length; ++i) {
            FJTaskRunner t = this.threads[i];
            t.setScanPriority(pri);
            if (t.active) continue;
            t.setPriority(pri);
        }
    }

    public synchronized void setRunPriorities(int pri) {
        for (int i = 0; i < this.threads.length; ++i) {
            FJTaskRunner t = this.threads[i];
            t.setRunPriority(pri);
            if (!t.active) continue;
            t.setPriority(pri);
        }
    }

    public int size() {
        return this.threads.length;
    }

    public synchronized int getActiveCount() {
        return this.activeCount;
    }

    public void stats() {
        long time = System.currentTimeMillis() - this.initTime;
        double secs = (double)time / 1000.0;
        long totalRuns = 0L;
        long totalScans = 0L;
        long totalSteals = 0L;
        System.out.print("Thread\tQ Cap\tScans\tNew\tRuns\n");
        for (int i = 0; i < this.threads.length; ++i) {
            FJTaskRunner t = this.threads[i];
            int truns = t.runs;
            totalRuns += (long)truns;
            int tscans = t.scans;
            totalScans += (long)tscans;
            int tsteals = t.steals;
            totalSteals += (long)tsteals;
            String star = this.getActive(t) ? "*" : " ";
            System.out.print("T" + i + star + "\t" + t.deqSize() + "\t" + tscans + "\t" + tsteals + "\t" + truns + "\n");
        }
        System.out.print("Total\t    \t" + totalScans + "\t" + totalSteals + "\t" + totalRuns + "\n");
        System.out.print("Execute: " + this.entries);
        System.out.print("\tTime: " + secs);
        long rps = 0L;
        if (secs != 0.0) {
            rps = Math.round((double)totalRuns / secs);
        }
        System.out.println("\tRate: " + rps);
    }

    protected FJTaskRunner[] getArray() {
        return this.threads;
    }

    protected FJTask pollEntryQueue() {
        try {
            FJTask t;
            FJTask fJTask = t = (FJTask)this.entryQueue.poll(0L);
            return fJTask;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            FJTask fJTask = null;
            return fJTask;
        }
    }

    protected synchronized boolean getActive(FJTaskRunner t) {
        return t.active;
    }

    protected synchronized void setActive(FJTaskRunner t) {
        if (!t.active) {
            t.active = true;
            ++this.activeCount;
            if (this.nstarted < this.threads.length) {
                this.threads[this.nstarted++].start();
            } else {
                this.notifyAll();
            }
        }
    }

    protected synchronized void setInactive(FJTaskRunner t) {
        if (t.active) {
            t.active = false;
            --this.activeCount;
        }
    }

    protected synchronized void checkActive(FJTaskRunner t, long scans) {
        this.setInactive(t);
        try {
            if (this.activeCount == 0 && this.entryQueue.peek() == null) {
                this.wait();
            } else {
                long msecs = scans / 15L;
                if (msecs > 100L) {
                    msecs = 100L;
                }
                int nsecs = msecs == (long)0 ? 1 : 0;
                this.wait(msecs, nsecs);
            }
        }
        catch (InterruptedException ex) {
            this.notify();
            Thread.currentThread().interrupt();
        }
    }

    protected synchronized void signalNewTask() {
        ++this.entries;
        if (this.nstarted < this.threads.length) {
            this.threads[this.nstarted++].start();
        } else {
            this.notify();
        }
    }

    protected void initializeThreads() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new FJTaskRunner(this);
        }
    }

    protected static final class InvokableFJTask
    extends FJTask {
        protected final Runnable wrapped;
        protected boolean terminated = false;

        protected InvokableFJTask(Runnable r) {
            this.wrapped = r;
        }

        public void run() {
            try {
                if (this.wrapped instanceof FJTask) {
                    FJTask.invoke((FJTask)this.wrapped);
                } else {
                    this.wrapped.run();
                }
                Object var2_1 = null;
                this.setTerminated();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.setTerminated();
                throw throwable;
            }
        }

        protected synchronized void setTerminated() {
            this.terminated = true;
            this.notifyAll();
        }

        protected synchronized void awaitTermination() throws InterruptedException {
            while (!this.terminated) {
                this.wait();
            }
        }
    }
}

