/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.lang.reflect.InvocationTargetException;

public class FutureResult {
    protected Object value_ = null;
    protected boolean ready_ = false;
    protected InvocationTargetException exception_ = null;

    public Runnable setter(final Callable function) {
        return new Runnable(){

            public void run() {
                try {
                    this.set(function.call());
                }
                catch (Throwable ex) {
                    this.setException(ex);
                }
            }
        };
    }

    protected Object doGet() throws InvocationTargetException {
        if (this.exception_ != null) {
            throw this.exception_;
        }
        return this.value_;
    }

    public synchronized Object get() throws InvocationTargetException, InterruptedException {
        while (!this.ready_) {
            this.wait();
        }
        return this.doGet();
    }

    public synchronized Object timedGet(long msecs) throws InvocationTargetException, InterruptedException, TimeoutException {
        long startTime = msecs <= (long)0 ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        if (this.ready_) {
            return this.doGet();
        }
        if (waitTime <= (long)0) {
            throw new TimeoutException(msecs);
        }
        do {
            this.wait(waitTime);
            if (!this.ready_) continue;
            return this.doGet();
        } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > (long)0);
        throw new TimeoutException(msecs);
    }

    public synchronized void set(Object newValue) {
        this.value_ = newValue;
        this.ready_ = true;
        this.notifyAll();
    }

    public synchronized void setException(Throwable ex) {
        this.exception_ = new InvocationTargetException(ex);
        this.ready_ = true;
        this.notifyAll();
    }

    public synchronized InvocationTargetException getException() {
        return this.exception_;
    }

    public synchronized boolean isReady() {
        return this.ready_;
    }

    public synchronized Object peek() {
        return this.value_;
    }

    public synchronized void clear() {
        this.value_ = null;
        this.exception_ = null;
        this.ready_ = false;
    }
}

