/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class Latch
implements Sync {
    protected boolean latched_ = false;

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Latch latch = this;
        synchronized (latch) {
            try {
                while (!this.latched_) {
                    this.wait();
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Latch latch = this;
        synchronized (latch) {
            try {
                if (this.latched_) {
                    return true;
                }
                if (msecs <= (long)0) {
                    return false;
                }
                long waitTime = msecs;
                long start = System.currentTimeMillis();
                do {
                    this.wait(waitTime);
                    if (!this.latched_) continue;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > (long)0);
                return false;
            }
            catch (Throwable throwable) {
                Object var13_8 = null;
                throw throwable;
            }
        }
    }

    public synchronized void release() {
        this.latched_ = true;
        this.notifyAll();
    }
}

